<?php
/**
 * Stripe Configuration
 * Load Stripe API keys from environment variables
 */

// Load configuration with fallback support
require_once __DIR__ . '/config_manager.php';

// Stripe API Configuration
class StripeConfig {
    // Get keys from configuration manager with fallback support
    
    // Business Configuration
    const BUSINESS_NAME = 'AppliedHE Xchange 2025';
    const CURRENCY = 'usd';
    const SUCCESS_URL = 'registration_success.php';
    const CANCEL_URL = 'registration_cancel.php';
    
    // Environment
    const IS_LIVE_MODE = true; // Set to true for production
    
    public static function getPublishableKey() {
        return getRequiredConfig('STRIPE_PUBLISHABLE_KEY');
    }
    
    public static function getSecretKey() {
        return getRequiredConfig('STRIPE_SECRET_KEY');
    }
    
    public static function getWebhookSecret() {
        return getRequiredConfig('STRIPE_WEBHOOK_SECRET');
    }
    
    public static function getBusinessName() {
        return self::BUSINESS_NAME;
    }
    
    public static function getCurrency() {
        return self::CURRENCY;
    }
    
    public static function isLiveMode() {
        return self::IS_LIVE_MODE;
    }
    
    public static function getSuccessUrl() {
        $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . 
                   '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']);
        return $baseUrl . '/' . self::SUCCESS_URL;
    }
    
    public static function getCancelUrl() {
        $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . 
                   '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']);
        return $baseUrl . '/' . self::CANCEL_URL;
    }
}

// Validate configuration
if (StripeConfig::getPublishableKey() === 'pk_test_YOUR_PUBLISHABLE_KEY_HERE' || 
    StripeConfig::getSecretKey() === 'sk_test_YOUR_SECRET_KEY_HERE') {
    error_log('WARNING: Stripe keys not configured. Please update stripe_config.php with your actual keys.');
}
?>
