-- Migration script to fix payment_transactions ENUM columns
-- This adds missing values to transaction_type and transaction_status ENUMs

-- Update the transaction_type ENUM to include 'admin_update'
ALTER TABLE payment_transactions 
MODIFY COLUMN transaction_type ENUM('gateway', 'bank_transfer', 'refund', 'admin_update') NOT NULL;

-- Update the transaction_status ENUM to include 'paid' and other missing statuses
ALTER TABLE payment_transactions 
MODIFY COLUMN transaction_status ENUM('pending', 'processing', 'completed', 'failed', 'cancelled', 'paid', 'expired') DEFAULT 'pending';

-- Verify the changes
SHOW COLUMNS FROM payment_transactions LIKE 'transaction_type';
SHOW COLUMNS FROM payment_transactions LIKE 'transaction_status';
