SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

CREATE TABLE `admin_activity_log` (
  `id` int(11) NOT NULL,
  `admin_user_id` int(11) NOT NULL,
  `action` varchar(100) NOT NULL,
  `target_type` varchar(50) DEFAULT NULL,
  `target_id` int(11) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES
(7, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 02:52:40'),
(8, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 02:52:43'),
(45, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 05:00:38'),
(46, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 05:00:40'),
(64, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 07:46:00'),
(65, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 07:46:11'),
(68, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 14:43:12'),
(69, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 05:13:34'),
(84, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 07:35:17'),
(85, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 07:35:33'),
(86, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 10:43:52'),
(87, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 10:43:53'),
(103, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 12:45:11'),
(104, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 12:45:13'),
(119, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 14:46:19'),
(120, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 14:46:30'),
(127, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 16:48:53'),
(128, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 16:48:55'),
(129, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 22:58:30'),
(130, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 01:26:10'),
(131, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 01:26:18'),
(132, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 03:28:28'),
(133, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 03:28:37'),
(146, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 05:48:12'),
(147, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 05:53:58'),
(182, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 08:01:59'),
(183, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 08:02:00'),
(184, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 12:17:41'),
(185, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 12:17:51'),
(192, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 14:42:11'),
(193, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 14:42:12'),
(194, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 05:22:50'),
(195, 1, 'SYSTEM_MIGRATION', 'admin_settings', NULL, 'Removed Early Bird Pricing feature', '127.0.0.1', NULL, '2025-08-20 06:20:13'),
(196, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:37:09'),
(197, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:37:11'),
(198, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 09:37:30'),
(199, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 09:37:32'),
(200, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 11:02:31'),
(201, 1, 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 12:35:13'),
(202, 1, 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 13:46:08'),
(203, 1, 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 15:55:15'),
(204, 1, 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 16:40:49'),
(205, 1, 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 01:43:29'),
(206, 2, 'login', NULL, NULL, 'User logged in', '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 02:47:54'),
(207, 3, 'login', NULL, NULL, 'User logged in', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 06:37:17'),
(208, 3, 'login', NULL, NULL, 'User logged in', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 08:51:52'),
(209, 4, 'login', NULL, NULL, 'User logged in', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 09:50:40'),
(210, 1, 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 12:19:00'),
(211, 1, 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 01:14:53'),
(212, 1, 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 03:32:39'),
(213, 1, 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 03:39:02'),
(214, 3, 'login', NULL, NULL, 'User logged in', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 04:48:15'),
(215, 1, 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 05:12:37'),
(216, 1, 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 07:20:53'),
(217, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 09:10:25'),
(218, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 09:10:27'),
(219, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 12:01:01'),
(220, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 12:01:03'),
(225, 1, 'SYSTEM_MIGRATION', 'products', NULL, 'Multiple Delegate Types Migration (multiple_delegate_types_2025_08_22_14_42_56): Created 6 new delegate type products and migrated existing registration data', '127.0.0.1', NULL, '2025-08-22 12:42:56'),
(226, 1, 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 14:13:57'),
(227, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 14:13:59'),
(235, 1, 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 05:28:46');

CREATE TABLE `admin_settings` (
  `id` int(11) NOT NULL,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text NOT NULL,
  `setting_type` enum('string','number','boolean','json','text','file','template','textarea') DEFAULT 'string',
  `description` text DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_by` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `admin_settings` (`id`, `setting_key`, `setting_value`, `setting_type`, `description`, `updated_at`, `updated_by`) VALUES
(2, 'earlyBirdActive', 'true', 'boolean', 'Enable early bird pricing', '2025-08-13 10:53:25', NULL),
(4, 'earlyBirdDeadline', '2025-08-31T23:59:59', 'string', 'Early bird registration deadline', '2025-08-13 10:53:25', NULL),
(5, 'earlyBirdPrice', '500', 'number', 'Early bird delegate pass price in USD', '2025-08-14 05:15:54', NULL),
(6, 'standardPrice', '550', 'number', 'Standard delegate pass price in USD', '2025-08-13 10:53:25', NULL),
(7, 'standardTablePrice', '550', 'number', 'Standard table presentation price in USD', '2025-08-14 05:15:58', NULL),
(8, 'doubleTablePrice', '850', 'number', 'Double table presentation price in USD', '2025-08-13 10:53:25', NULL),
(9, 'maxDelegates', '50', 'number', 'Maximum delegates per registration', '2025-08-13 10:53:25', NULL),
(10, 'maxTables', '100', 'number', 'Maximum table bookings allowed', '2025-08-13 10:53:25', NULL),
(11, 'eventName', 'AppliedHE Xchange 2025', 'text', 'Event name', '2025-08-13 10:53:25', NULL),
(12, 'eventDates', '27–28 November 2025', 'text', 'Event dates', '2025-08-13 10:53:25', NULL),
(13, 'eventLocation', 'Sunway University, Malaysia', 'text', 'Event location', '2025-08-13 10:53:25', NULL),
(14, 'bankName', 'DBS Bank Ltd Singapore', 'text', 'Bank name for transfers', '2025-08-13 10:53:25', NULL),
(15, 'accountName', 'AppliedHE Pte. Ltd.', 'text', 'Bank account name', '2025-08-20 07:48:30', NULL),
(16, 'accountNumber', '015-905678-3', 'text', 'Bank account number', '2025-08-20 06:22:35', NULL),
(17, 'swiftCode', 'DBSSSGSG', 'text', 'Bank SWIFT code', '2025-08-13 10:53:25', NULL),
(18, 'referencePrefix', 'XCHANGE2025', 'text', 'Payment reference prefix', '2025-08-13 10:53:25', NULL),
(19, 'dietaryOptions', '[\"None\",\"Non Veg (Chicken)\",\"Non Veg (Fish)\",\"Veg\"]', 'json', 'Available dietary requirement options', '2025-08-20 07:50:41', NULL),
(20, 'systemName', 'Xchange 2025 Registration System', 'text', 'System name', '2025-08-20 09:00:47', NULL),
(21, 'adminEmail', 'info@appliedhe.com', 'text', 'System administrator email', '2025-08-20 06:43:25', NULL),
(22, 'timezone', 'Asia/Kuala_Lumpur', 'text', 'System timezone', '2025-08-13 10:53:25', NULL),
(23, 'currency', 'USD', 'text', 'Default currency', '2025-08-13 10:53:25', NULL),
(24, 'dateFormat', 'M j, Y', 'text', 'Default date format', '2025-08-13 10:53:25', NULL),
(25, 'timeFormat', 'H:i', 'text', 'Default time format', '2025-08-13 10:53:25', NULL),
(26, 'eventPageUrl', 'https://appliedhe.com/xchange-2025-sunway/', 'text', 'URL for Return to Event Page button', '2025-08-20 06:10:49', NULL),
(27, 'invoiceTermsConditions', '• Payment is due within 7 days of invoice date\n• Please include the reference number with your payment\n• For any queries, contact us at finance@appliedhe.com\n• All prices are in USD and subject to change without notice\n• Registration is confirmed upon receipt of payment', 'text', 'Invoice terms and conditions', '2025-08-20 09:08:13', NULL),
(30, 'brevoApiKey', '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', 'string', NULL, '2025-08-14 01:40:03', NULL),
(31, 'senderEmail', 'noreply@xchange2025.com', 'string', NULL, '2025-08-14 01:27:15', NULL),
(32, 'senderName', 'Xchange 2025 Team', 'string', NULL, '2025-08-20 09:00:38', NULL),
(33, 'adminEmails', '[\"admin@xchange2025.com\"]', 'json', NULL, '2025-08-14 01:35:57', NULL),
(34, 'bankTransferDetails', 'Bank Name: DBS Bank Ltd Singapore\r\nAccount Name: AppliedHE Pte. Ltd.\r\nAccount Number: 015-905678-3\r\nSwift Code: DBSSSGSG', 'text', NULL, '2025-08-20 09:30:42', NULL),
(35, 'adminNotificationEmails', 'mcruwan@gmail.com', 'text', 'Admin notification email addresses (comma-separated)', '2025-08-14 01:30:37', NULL),
(36, 'brevoSenderName', 'AppliedHE', 'text', 'Brevo sender name', '2025-08-14 01:30:50', NULL),
(43, 'emailTemplate_pendingRegistration_subject', 'Registration Received - Payment Pending | {EVENT_NAME}', 'template', 'Subject line for pending registration emails', '2025-08-14 05:04:29', NULL),
(44, 'emailTemplate_pendingRegistration_greeting', 'Dear {CONTACT_NAME},', 'template', 'Greeting text for pending registration emails', '2025-08-14 05:04:29', NULL),
(45, 'emailTemplate_pendingRegistration_intro', 'Thank you for registering for {EVENT_NAME}! We have received your registration details.', 'template', 'Introduction text for pending registration emails', '2025-08-14 05:04:29', NULL),
(46, 'emailTemplate_pendingRegistration_instructions', 'Your registration is not yet confirmed. Please complete the payment to secure your spot.', 'template', 'Payment instructions text', '2025-08-14 05:04:29', NULL),
(47, 'emailTemplate_pendingRegistration_footer', 'Once we receive and verify your payment, we will send you a confirmation email with your complete registration details.\\n\\nIf you have any questions, please don\'t hesitate to contact us.\\n\\nBest regards,\\n{EVENT_NAME} Team', 'template', 'Footer text for pending registration emails', '2025-08-14 05:04:29', NULL),
(48, 'emailTemplate_confirmation_subject', 'Registration Confirmed - Welcome to {EVENT_NAME}!', 'template', 'Subject line for confirmation emails', '2025-08-14 05:04:36', NULL),
(49, 'emailTemplate_confirmation_greeting', 'Dear {CONTACT_NAME},', 'template', 'Greeting text for confirmation emails', '2025-08-14 05:04:29', NULL),
(50, 'emailTemplate_confirmation_intro', 'Congratulations! You are now officially registered for {EVENT_NAME}. We\'re excited to have you join us for this premier academic exchange event.', 'template', 'Introduction text for confirmation emails', '2025-08-14 05:04:29', NULL),
(51, 'emailTemplate_confirmation_nextSteps', 'You will receive event details and schedule closer to the event date. Delegate badges and materials will be prepared based on your registration. Any updates will be sent to this email address.', 'template', 'Next steps text for confirmation emails', '2025-08-14 05:04:29', NULL),
(52, 'emailTemplate_confirmation_footer', 'Please keep this email and your registration number {REGISTRATION_NUMBER} for your records.\\n\\nThank you for choosing {EVENT_NAME}. We look forward to seeing you at the event!\\n\\nBest regards,\\n{EVENT_NAME} Organizing Committee', 'template', 'Footer text for confirmation emails', '2025-08-14 05:04:29', NULL),
(53, 'emailTemplate_reminder_subject_24h', 'Payment Reminder (24h) - {EVENT_NAME}', 'template', 'Subject line for 24h payment reminders', '2025-08-14 05:04:29', NULL),
(54, 'emailTemplate_reminder_subject_48h', 'Payment Reminder (48h) - {EVENT_NAME}', 'template', 'Subject line for 48h payment reminders', '2025-08-14 05:04:29', NULL),
(55, 'emailTemplate_reminder_subject_7d', 'Final Payment Reminder - {EVENT_NAME}', 'template', 'Subject line for 7d payment reminders', '2025-08-14 05:04:29', NULL),
(56, 'emailTemplate_reminder_message_24h', 'We noticed your registration is still pending payment.', 'template', 'Message for 24h payment reminders', '2025-08-14 05:04:29', NULL),
(57, 'emailTemplate_reminder_message_48h', 'This is a friendly reminder that your payment is still pending.', 'template', 'Message for 48h payment reminders', '2025-08-14 05:04:29', NULL),
(58, 'emailTemplate_reminder_message_7d', 'Final reminder: Your registration will expire soon without payment.', 'template', 'Message for 7d payment reminders', '2025-08-14 05:04:29', NULL),
(59, 'emailTemplate_reminder_footer', 'Please complete your payment to secure your registration for {EVENT_NAME}.\\n\\nIf you have already made the payment, please disregard this reminder.\\n\\nBest regards,\\n{EVENT_NAME} Team', 'template', 'Footer text for reminder emails', '2025-08-14 05:04:29', NULL),
(60, 'emailTemplate_failure_subject', 'Payment Issue - {EVENT_NAME}', 'template', 'Subject line for payment failure emails', '2025-08-14 05:04:29', NULL),
(61, 'emailTemplate_failure_intro', 'We encountered an issue processing your payment for {EVENT_NAME} registration.', 'template', 'Introduction text for payment failure emails', '2025-08-14 05:04:29', NULL),
(62, 'emailTemplate_failure_instructions', 'Please try again or contact us for assistance. Your registration spot is still reserved for a limited time.', 'template', 'Instructions for payment failure emails', '2025-08-14 05:04:29', NULL),
(63, 'emailTemplate_failure_footer', 'If you continue to experience issues, please contact our support team.\\n\\nBest regards,\\n{EVENT_NAME} Team', 'template', 'Footer text for payment failure emails', '2025-08-14 05:04:29', NULL),
(66, 'emailTemplate_pending_registration_html', '        <!DOCTYPE html>\n        <html>\n        <head>\n            <meta charset=\'UTF-8\'>\n            <title>Registration Received - Payment Pending | AppliedHE Xchange 2025</title>\n            <style>\n                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\n                .container { max-width: 600px; margin: 0 auto; padding: 20px; }\n                .header { background: #f1f5f9; color: #1e293b; padding: 20px; text-align: center; border-bottom: 1px solid #e2e8f0; }\n                .content { padding: 20px; background: #f9fafb; }\n                .status-pending { background: #fef3c7; border: 1px solid #f59e0b; padding: 15px; border-radius: 5px; margin: 20px 0; }\n                .bank-details { background: #e0f2fe; border: 1px solid #0284c7; padding: 15px; border-radius: 5px; margin: 20px 0; }\n                .footer { text-align: center; padding: 20px; color: #666; font-size: 12px; }\n                .btn { display: inline-block; background: #2563eb; color: white; padding: 12px 24px; text-decoration: none; border-radius: 5px; margin: 10px 0; }\n            </style>\n        </head>\n        <body>\n            <div class=\'container\'>\n                <div class=\'header\'>\n                    <img src=\"https://apps.appliedhe.one/xchange_reg/uploads/event_logo_1755135911.png\" alt=\"AppliedHE Xchange 2025 Logo\" style=\"max-width: 300px; max-height: 120px; height: auto; display: block; margin: 0 auto;\">\n                    <h1 style=\'color: #1e293b; margin: 20px 0 0 0; font-size: 28px; font-weight: 700;\'>\n                        AppliedHE Xchange 2025\n                    </h1>\n                    <p style=\'color: #64748b; margin: 8px 0 0 0; font-size: 16px;\'>Registration Received</p>\n                </div>\n                \n                <div class=\'content\'>\n                    <p>Dear John Smith,</p>\n                    \n                    <p>Thank you for registering for AppliedHE Xchange 2025 ! We have received your registration details.</p>\n                    \n                    <div class=\'status-pending\'>\n                        <strong>⏳ Registration Status: PENDING PAYMENT</strong><br>\n                        Your registration is not yet confirmed. Please complete the payment to secure your spot.\n                    </div>\n                    \n                    \n        <div style=\'background: #fefce8; border: 2px solid #eab308; padding: 20px; border-radius: 8px; margin: 20px 0;\'>\n            <h3 style=\'margin: 0 0 15px 0; color: #a16207;\'>🛒 Your Order Details</h3>\n            <p style=\'margin: 0 0 15px 0; color: #713f12;\'>Here\'s exactly what you\'re registering and paying for:</p>\n            \n            <table style=\'width: 100%; border-collapse: collapse; background: white; border-radius: 5px; overflow: hidden;\'>\n                <thead>\n                    <tr style=\'background: #f59e0b; color: white;\'>\n                        <th style=\'padding: 12px; text-align: left; border-bottom: 1px solid #d97706;\'>Item</th>\n                        <th style=\'padding: 12px; text-align: center; border-bottom: 1px solid #d97706;\'>Qty</th>\n                        <th style=\'padding: 12px; text-align: right; border-bottom: 1px solid #d97706;\'>Unit Price</th>\n                        <th style=\'padding: 12px; text-align: right; border-bottom: 1px solid #d97706;\'>Total</th>\n                    </tr>\n                </thead>\n                <tbody>\n                    <tr style=\'border-bottom: 1px solid #f3f4f6;\'>\n                        <td style=\'padding: 12px;\'>\n                            <strong>Early Bird Delegate Pass</strong><br>\n                            <small style=\'color: #6b7280;\'>Full conference access, materials, meals</small>\n                        </td>\n                        <td style=\'padding: 12px; text-align: center;\'>3</td>\n                        <td style=\'padding: 12px; text-align: right;\'>USD $1.00</td>\n                        <td style=\'padding: 12px; text-align: right; font-weight: bold;\'>USD $3.00</td>\n                    </tr>\n                    <tr style=\'border-bottom: 1px solid #f3f4f6;\'>\n                        <td style=\'padding: 12px;\'>\n                            <strong>Standard Table Presentation</strong><br>\n                            <small style=\'color: #6b7280;\'>Table space for poster/materials display</small>\n                        </td>\n                        <td style=\'padding: 12px; text-align: center;\'>1</td>\n                        <td style=\'padding: 12px; text-align: right;\'>USD $1.00</td>\n                        <td style=\'padding: 12px; text-align: right; font-weight: bold;\'>USD $1.00</td>\n                    </tr>\n                    <tr style=\'background: #f9fafb; border-top: 2px solid #e5e7eb;\'>\n                        <td colspan=\'3\' style=\'padding: 15px; text-align: right; font-weight: bold; font-size: 16px;\'>\n                            TOTAL AMOUNT DUE:\n                        </td>\n                        <td style=\'padding: 15px; text-align: right; font-weight: bold; font-size: 18px; color: #dc2626;\'>\n                            USD $1,500.00\n                        </td>\n                    </tr>\n                </tbody>\n            </table>\n        </div>\n                    \n                    <div style=\'background: #f0f9ff; border: 1px solid #0284c7; padding: 20px; border-radius: 8px; margin: 20px 0;\'>\n                        <h3 style=\'margin: 0 0 15px 0; color: #0c4a6e;\'>📋 Registration Summary</h3>\n                        <table style=\'width: 100%; border-collapse: collapse;\'>\n                            <tr>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #e2e8f0;\'><strong>Registration Number:</strong></td>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #e2e8f0; text-align: right;\'>XC25-ABC123</td>\n                            </tr>\n                            <tr>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #e2e8f0;\'><strong>Contact Person:</strong></td>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #e2e8f0; text-align: right;\'>John Smith</td>\n                            </tr>\n                            <tr>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #e2e8f0;\'><strong>University:</strong></td>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #e2e8f0; text-align: right;\'>Sample University</td>\n                            </tr>\n                            <tr>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #e2e8f0;\'><strong>Payment Method:</strong></td>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #e2e8f0; text-align: right;\'>Bank Transfer</td>\n                            </tr>\n                        </table>\n                    </div>\n                    \n                    <div class=\'bank-details\'>\n                        <h3>🏦 Bank Transfer Instructions:</h3>\n                        <div>Bank Name: [Your Bank Name]<br />\nAccount Name: [Account Name]<br />\nAccount Number: [Account Number]<br />\nSwift Code: [Swift Code]<br />\nReference: Use your registration number</div>\n                        <p><strong>Payment Reference:</strong> XC25-ABC123</p>\n                        <p><strong>Amount:</strong> USD $1,500.00</p>\n                    </div>\n                    \n                    <p><strong>Important:</strong> Please include your registration number <strong>XC25-ABC123</strong> as the payment reference when making the bank transfer.</p>\n                    \n                    <p>Once we receive and verify your payment, we will send you a confirmation email with your complete registration details.\\n\\nIf you have any questions, please don&#039;t hesitate to contact us.\\n\\nBest regards,\\nAppliedHE Xchange 2025 Team</p>\n                </div>\n                \n                <div class=\'footer\'>\n                    <p>This is an automated email. Please do not reply to this email.</p>\n                </div>\n            </div>\n        </body>\n        </html>', 'template', 'Custom HTML template for pending registration', '2025-08-14 05:09:59', 'admin'),
(75, 'companyLogo', 'uploads/company_logo_1755396113.png', 'file', 'Company/Organization logo image', '2025-08-17 02:01:53', NULL),
(76, 'eventLogo', 'uploads/event_logo_1755396116.png', 'file', 'Event logo image', '2025-08-17 02:01:56', NULL),
(81, 'brevoSenderEmail', 'info@appliedhe.com', '', 'Brevo sender email address', '2025-08-20 06:24:27', NULL),
(83, 'companyAddress', '7 Temasek Boulevard #12-07 Suntec Tower One', 'text', 'Company address line 1', '2025-08-20 09:08:13', NULL),
(84, 'companyAddress2', 'Singapore 038987', 'text', 'Company address line 2', '2025-08-20 09:08:13', NULL),
(85, 'companyPhone', '+65 1234 5678', 'text', 'Company phone number', '2025-08-20 09:08:13', NULL),
(100, 'emailTemplate_registration_confirmation_html', '        <!DOCTYPE html>\n        <html>\n        <head>\n            <meta charset=\'UTF-8\'>\n            <title>Registration Confirmed - Welcome to AppliedHE Xchange 2025!</title>\n            <style>\n                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\n                .container { max-width: 600px; margin: 0 auto; padding: 20px; }\n                .header { background: #f1f5f9; color: #1e293b; padding: 20px; text-align: center; border-bottom: 1px solid #e2e8f0; }\n                .content { padding: 20px; background: #f9fafb; }\n                .status-confirmed { background: #d1fae5; border: 1px solid #059669; padding: 15px; border-radius: 5px; margin: 20px 0; }\n                .details-box { background: white; border: 1px solid #d1d5db; padding: 15px; border-radius: 5px; margin: 20px 0; }\n                .footer { text-align: center; padding: 20px; color: #666; font-size: 12px; }\n            </style>\n        </head>\n        <body>\n            <div class=\'container\'>\n                <div class=\'header\'>\n                    <img src=\"http://localhost/Xchange_version_2/uploads/event_logo_1755396116.png\" alt=\"AppliedHE Xchange 2025 Logo\" style=\"max-width: 300px; max-height: 120px; height: auto; display: block; margin: 0 auto;\">\n                    <h1 style=\'color: #1e293b; margin: 20px 0 0 0; font-size: 28px; font-weight: 700;\'>\n                        Welcome to AppliedHE Xchange 2025!\n                    </h1>\n                    <p style=\'color: #64748b; margin: 8px 0 0 0; font-size: 16px;\'>Registration Confirmed</p>\n                </div>\n                \n                <div class=\'content\'>\n                    <p>Dear John Smith,</p>\n                    \n                    <div class=\'status-confirmed\'>\n                        <strong>✅ Registration Status: CONFIRMED</strong><br>\n                        Your payment has been received and your registration is now complete!\n                    </div>\n                    \n                    <p>Congratulations! You are now officially registered for AppliedHE Xchange 2025. We&#039;re excited to have you join us for this premier academic exchange event.</p>\n                    \n                    \n        <div style=\'background: #fefce8; border: 2px solid #eab308; padding: 20px; border-radius: 8px; margin: 20px 0;\'>\n            <h3 style=\'margin: 0 0 15px 0; color: #a16207;\'>🛒 Your Order Details</h3>\n            <p style=\'margin: 0 0 15px 0; color: #713f12;\'>Here\'s exactly what you\'re registering and paying for:</p>\n            \n            <table style=\'width: 100%; border-collapse: collapse; background: white; border-radius: 5px; overflow: hidden;\'>\n                <thead>\n                    <tr style=\'background: #f59e0b; color: white;\'>\n                        <th style=\'padding: 12px; text-align: left; border-bottom: 1px solid #d97706;\'>Item</th>\n                        <th style=\'padding: 12px; text-align: center; border-bottom: 1px solid #d97706;\'>Qty</th>\n                        <th style=\'padding: 12px; text-align: right; border-bottom: 1px solid #d97706;\'>Unit Price</th>\n                        <th style=\'padding: 12px; text-align: right; border-bottom: 1px solid #d97706;\'>Total</th>\n                    </tr>\n                </thead>\n                <tbody>\n                    <tr style=\'border-bottom: 1px solid #f3f4f6;\'>\n                        <td style=\'padding: 12px;\'>\n                            <strong>Early Bird Delegate Pass</strong><br>\n                            <small style=\'color: #6b7280;\'>Full conference access, materials, meals</small>\n                        </td>\n                        <td style=\'padding: 12px; text-align: center;\'>2</td>\n                        <td style=\'padding: 12px; text-align: right;\'>USD $500.00</td>\n                        <td style=\'padding: 12px; text-align: right; font-weight: bold;\'>USD $1,000.00</td>\n                    </tr>\n                    <tr style=\'border-bottom: 1px solid #f3f4f6;\'>\n                        <td style=\'padding: 12px;\'>\n                            <strong>Standard Table Presentation</strong><br>\n                            <small style=\'color: #6b7280;\'>Table space for poster/materials display</small>\n                        </td>\n                        <td style=\'padding: 12px; text-align: center;\'>1</td>\n                        <td style=\'padding: 12px; text-align: right;\'>USD $550.00</td>\n                        <td style=\'padding: 12px; text-align: right; font-weight: bold;\'>USD $550.00</td>\n                    </tr>\n                        <tr style=\'border-bottom: 1px solid #f3f4f6;\'>\n                            <td style=\'padding: 12px;\'>\n                                <strong>Premium Sponsorship Package</strong><br>\n                                <small style=\'color: #6b7280;\'>Brand visibility and networking opportunities</small>\n                            </td>\n                            <td style=\'padding: 12px; text-align: center;\'>1</td>\n                            <td style=\'padding: 12px; text-align: right;\'>USD $25,000.00</td>\n                            <td style=\'padding: 12px; text-align: right; font-weight: bold;\'>USD $25,000.00</td>\n                        </tr>\n                        <tr style=\'border-bottom: 1px solid #f3f4f6;\'>\n                            <td style=\'padding: 12px;\'>\n                                <strong>Networking Event Sponsorship</strong><br>\n                                <small style=\'color: #6b7280;\'>Exclusive networking session branding</small>\n                            </td>\n                            <td style=\'padding: 12px; text-align: center;\'>1</td>\n                            <td style=\'padding: 12px; text-align: right;\'>USD $15,000.00</td>\n                            <td style=\'padding: 12px; text-align: right; font-weight: bold;\'>USD $15,000.00</td>\n                        </tr>\n                    <tr style=\'background: #f9fafb; border-top: 2px solid #e5e7eb;\'>\n                        <td colspan=\'3\' style=\'padding: 15px; text-align: right; font-weight: bold; font-size: 16px;\'>\n                            TOTAL AMOUNT DUE:\n                        </td>\n                        <td style=\'padding: 15px; text-align: right; font-weight: bold; font-size: 18px; color: #dc2626;\'>\n                            USD $88,900.00\n                        </td>\n                    </tr>\n                </tbody>\n            </table>\n        </div>\n                    \n                    <div style=\'background: #d1fae5; border: 1px solid #10b981; padding: 20px; border-radius: 8px; margin: 20px 0;\'>\n                        <h3 style=\'margin: 0 0 15px 0; color: #065f46;\'>✅ Payment Confirmed</h3>\n                        <table style=\'width: 100%; border-collapse: collapse;\'>\n                            <tr>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #a7f3d0;\'><strong>Registration Number:</strong></td>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #a7f3d0; text-align: right;\'>XC25-ABC123</td>\n                            </tr>\n                            <tr>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #a7f3d0;\'><strong>Contact Person:</strong></td>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #a7f3d0; text-align: right;\'>John Smith</td>\n                            </tr>\n                            <tr>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #a7f3d0;\'><strong>University:</strong></td>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #a7f3d0; text-align: right;\'>Sample University</td>\n                            </tr>\n                            <tr>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #a7f3d0;\'><strong>Total Amount Paid:</strong></td>\n                                <td style=\'padding: 8px 0; border-bottom: 1px solid #a7f3d0; text-align: right; font-weight: bold; color: #059669;\'>USD $88,900.00</td>\n                            </tr>\n                            <tr>\n                                <td style=\'padding: 8px 0;\'><strong>Payment Status:</strong></td>\n                                <td style=\'padding: 8px 0; text-align: right; font-weight: bold; color: #059669;\'>✅ CONFIRMED</td>\n                            </tr>\n                        </table>\n                    </div>\n                    \n                    <h3>📅 What\'s Next?</h3>\n                    <p>You will receive event details and schedule closer to the event date. Delegate badges and materials will be prepared based on your registration. Any updates will be sent to this email address.</p>\n                    \n                    <p>Please keep this email and your registration number XC25-ABC123 for your records.\\n\\nThank you for choosing AppliedHE Xchange 2025. We look forward to seeing you at the event!\\n\\nBest regards,\\nAppliedHE Xchange 2025 Organizing Committee</p>\n                </div>\n                \n                <div class=\'footer\'>\n                    <p>This is an automated email. Please do not reply to this email.</p>\n                    <p>For questions, please contact our support team.</p>\n                </div>\n            </div>\n        </body>\n        </html>', 'template', 'Custom HTML template for registration confirmation', '2025-08-20 08:23:21', 'admin');

CREATE TABLE `admin_users` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `full_name` varchar(100) NOT NULL,
  `email` varchar(255) NOT NULL,
  `role` enum('super_admin','manager','viewer') NOT NULL DEFAULT 'viewer',
  `is_active` tinyint(1) DEFAULT 1,
  `last_login` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `admin_users` (`id`, `username`, `password_hash`, `full_name`, `email`, `role`, `is_active`, `last_login`, `created_at`, `updated_at`, `created_by`) VALUES
(1, 'admin', '$2y$10$gyFpsCqoO8KSmrzf43sE3ucb972kNQkAY665lbXBdWIuAnadmKWLK', 'System Administrator', 'admin@xchange2025.com', 'super_admin', 1, '2025-08-24 05:28:46', '2025-08-13 08:25:07', '2025-08-24 05:28:46', NULL),
(2, 'suba', '$2y$10$qtS7zZLJHFd65vwHXT4MYuQpherJpOIexKE5HONn3ryDymDJkdbDe', 'Suba', 'suba@dyits.com.my', 'super_admin', 1, '2025-08-21 02:47:54', '2025-08-13 11:00:24', '2025-08-21 02:47:54', 1),
(3, 'roshel', '$2y$10$s9neP7vcIr7Loo6vlg7Ro.maL4N.Qp0Xk2il3A4y7NhVxVHKIhx3y', 'Roshel', 'roshel@dyits.com.my', 'super_admin', 1, '2025-08-22 04:48:15', '2025-08-13 11:00:44', '2025-08-22 04:48:15', 1),
(4, 'hansi', '$2y$10$7l37tm3XD.KrqLe4h/fByOgnp4WP/hMOAWN.Bb0.qLuRXlR.u2tzS', 'Hansi', 'hansi@dyits.com.my', 'super_admin', 1, '2025-08-21 09:50:40', '2025-08-13 11:01:00', '2025-08-21 09:50:40', 1),
(5, 'shiwantha', '$2y$10$TAHY5ak.LaNwUnv2xwpb5uYsKsrSUt41i78LwMWuWCulPtRYmGjAK', 'Shinwahtha', 'shiwantha@dyits.com.my', 'super_admin', 1, '2025-08-14 08:33:09', '2025-08-13 11:01:19', '2025-08-14 08:33:09', 1);

CREATE TABLE `delegates` (
  `id` int(11) NOT NULL,
  `registration_id` int(11) NOT NULL,
  `delegate_number` int(11) NOT NULL,
  `full_name` varchar(255) NOT NULL,
  `badge_name` varchar(100) NOT NULL,
  `designation` varchar(255) NOT NULL,
  `dietary_requirements` varchar(100) DEFAULT NULL,
  `special_assistance` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES
(1, 1, 1, 'Ruwan Chinthaka', 'Ruwan', 'CTO', 'non-veg-(chicken)', 'No', '2025-08-20 12:54:46', '2025-08-20 12:54:46'),
(2, 1, 2, 'Roshel', 'Doe', 'Manager', '', '', '2025-08-20 12:54:46', '2025-08-20 12:54:46'),
(5, 3, 1, 'Suba Raj', 'Suba', 'Professor', 'non-veg-(chicken)', '', '2025-08-21 02:44:30', '2025-08-21 02:44:30'),
(6, 3, 2, 'Suba - Deg 1', 'Deg 1', 'Professor', 'non-veg-(chicken)', '', '2025-08-21 02:44:30', '2025-08-21 02:44:30'),
(7, 3, 3, 'Suba - Deg 2', 'Deg 2', 'Student', 'non-veg-(fish)', '', '2025-08-21 02:44:30', '2025-08-21 02:44:30'),
(8, 3, 4, 'Suba - Deg 3', 'Deg 3', 'Student', 'veg', '', '2025-08-21 02:44:30', '2025-08-21 02:44:30'),
(9, 4, 1, 'Raj Suba', 'Suba', 'Manager', '', '', '2025-08-21 02:47:27', '2025-08-21 02:47:27'),
(10, 5, 1, 'Suba Raj', 'Suba', 'Manager', '', '', '2025-08-21 03:00:55', '2025-08-21 03:00:55'),
(11, 6, 1, 's', 'sfdsf', 's', '', '', '2025-08-22 01:15:25', '2025-08-22 01:15:25'),
(12, 7, 1, 'Ruwan', 'mcruwan', 'abc', '[\"None\"]', '', '2025-08-22 15:10:40', '2025-08-22 15:10:40');
CREATE TABLE `dietary_summary` (
`dietary_requirements` varchar(100)
,`count` bigint(21)
);

CREATE TABLE `email_notifications` (
  `id` int(11) NOT NULL,
  `registration_id` int(11) DEFAULT NULL,
  `email_type` enum('pending_registration','registration_confirmation','payment_failure','payment_reminder_24h','payment_reminder_48h','payment_reminder_7d','admin_notification') NOT NULL,
  `recipient_email` varchar(255) NOT NULL,
  `recipient_name` varchar(255) DEFAULT NULL,
  `subject` varchar(500) NOT NULL,
  `status` enum('sent','failed','pending') DEFAULT 'pending',
  `sent_at` timestamp NULL DEFAULT current_timestamp(),
  `brevo_message_id` varchar(255) DEFAULT NULL,
  `error_message` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `email_notifications` (`id`, `registration_id`, `email_type`, `recipient_email`, `recipient_name`, `subject`, `status`, `sent_at`, `brevo_message_id`, `error_message`) VALUES
(3, 1, 'registration_confirmation', 'mcruwan@gmail.com', 'Ruwan Chinthaka', 'Registration Confirmed - Welcome to AppliedHE Xchange 2025!', 'sent', '2025-08-21 02:29:15', '<202508210229.90280517373@smtp-relay.mailin.fr>', NULL),
(4, 3, 'pending_registration', 'suba@dyits.com.my', 'Suba Raj', 'Registration Received - Payment Pending | AppliedHE Xchange 2025', 'sent', '2025-08-21 02:44:31', '<202508210244.58535548125@smtp-relay.mailin.fr>', NULL),
(5, 3, 'registration_confirmation', 'suba@dyits.com.my', 'Suba Raj', 'Registration Confirmed - Welcome to AppliedHE Xchange 2025!', 'sent', '2025-08-21 02:48:33', '<202508210248.48906041759@smtp-relay.mailin.fr>', NULL),
(6, 5, 'pending_registration', 'suba@dyits.com.my', 'Suba Raj', 'Registration Received - Payment Pending | AppliedHE Xchange 2025', 'sent', '2025-08-21 03:00:56', '<202508210300.33498293586@smtp-relay.mailin.fr>', NULL),
(7, 5, 'registration_confirmation', 'suba@dyits.com.my', 'Suba Raj', 'Registration Confirmed - Welcome to AppliedHE Xchange 2025!', 'sent', '2025-08-21 03:01:44', '<202508210301.29577902565@smtp-relay.mailin.fr>', NULL);

CREATE TABLE `frontend_display_config` (
  `id` int(11) NOT NULL,
  `page_section` varchar(50) NOT NULL COMMENT 'Section identifier (e.g., delegate_passes, table_presentations)',
  `category_id` int(11) DEFAULT NULL COMMENT 'Product category ID to display (NULL means use all categories)',
  `display_order` int(11) DEFAULT 0 COMMENT 'Order in which to display categories',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'Whether this configuration is active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `delegate_description` text DEFAULT NULL COMMENT 'Custom description for delegate passes section',
  `table_description` text DEFAULT NULL COMMENT 'Custom description for table presentations section',
  `sponsorship_description` text DEFAULT NULL COMMENT 'Custom description for sponsorship packages section',
  `addon_description` text DEFAULT NULL COMMENT 'Custom description for add-on services section',
  `sponsor_description` text DEFAULT NULL COMMENT 'Custom description for sponsor packages section'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `frontend_display_config` (`id`, `page_section`, `category_id`, `display_order`, `is_active`, `created_at`, `updated_at`, `delegate_description`, `table_description`, `sponsorship_description`, `addon_description`, `sponsor_description`) VALUES
(17, 'delegate_passes', 3, 0, 1, '2025-08-18 06:48:56', '2025-08-18 06:48:56', '', NULL, NULL, NULL, NULL),
(28, 'sponsor_tab', 5, 0, 1, '2025-08-19 03:31:45', '2025-08-19 03:31:45', NULL, NULL, NULL, NULL, 'Sponsorship opportunities'),
(34, 'other_sponsorship', 6, 0, 1, '2025-08-19 04:00:39', '2025-08-19 04:00:39', NULL, NULL, NULL, NULL, NULL),
(35, 'sponsorship', 5, 0, 1, '2025-08-19 04:04:18', '2025-08-19 04:04:18', NULL, NULL, NULL, NULL, NULL),
(36, 'table_presentations', 4, 0, 1, '2025-08-19 04:04:20', '2025-08-19 04:04:20', NULL, NULL, NULL, NULL, NULL);

CREATE TABLE `payment_transactions` (
  `id` int(11) NOT NULL,
  `registration_id` int(11) DEFAULT NULL,
  `registration_number` varchar(50) DEFAULT NULL,
  `transaction_type` enum('gateway','bank_transfer','refund','admin_update') NOT NULL,
  `transaction_status` enum('pending','processing','completed','failed','cancelled','paid','expired') DEFAULT 'pending',
  `transaction_reference` varchar(100) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `currency` varchar(3) DEFAULT 'USD',
  `gateway_transaction_id` varchar(255) DEFAULT NULL,
  `gateway_response` text DEFAULT NULL,
  `bank_reference` varchar(100) DEFAULT NULL,
  `transfer_date` date DEFAULT NULL,
  `bank_confirmation` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `payment_transactions` (`id`, `registration_id`, `registration_number`, `transaction_type`, `transaction_status`, `transaction_reference`, `amount`, `currency`, `gateway_transaction_id`, `gateway_response`, `bank_reference`, `transfer_date`, `bank_confirmation`, `created_at`, `updated_at`) VALUES
(1, 1, 'XC25-MXFAY9', 'gateway', 'pending', NULL, 88900.00, 'usd', 'cs_live_b1TDRBoilBcBPVR1PNpEAjCLdzlJWwYzSXNFo9E2I4Lsqc4p5KtpTscJPh', NULL, NULL, NULL, NULL, '2025-08-20 12:54:48', '2025-08-20 12:54:48'),
(6, 1, NULL, 'admin_update', 'completed', 'XC25-MXFAY9', 88900.00, 'USD', NULL, NULL, NULL, NULL, '', '2025-08-21 02:29:14', '2025-08-21 02:29:14'),
(7, 3, 'XC25-292253', 'bank_transfer', 'pending', 'XC25-292253', 3050.00, 'USD', NULL, NULL, 'XC25-292253', NULL, NULL, '2025-08-21 02:44:30', '2025-08-21 02:44:30'),
(8, 4, 'XC25-FEUGPF', 'gateway', 'pending', NULL, 10100.00, 'usd', 'cs_live_b1w8ajfqJa8zD8pZn5n4XqvsR3wcj2LRbPM7Pf0fhU4qPkYzMtIEjJ4In2', NULL, NULL, NULL, NULL, '2025-08-21 02:47:29', '2025-08-21 02:47:29'),
(9, 3, NULL, 'admin_update', 'completed', 'XC25-292253', 3050.00, 'USD', NULL, NULL, NULL, NULL, '', '2025-08-21 02:48:33', '2025-08-21 02:48:33'),
(10, 4, NULL, 'admin_update', 'failed', 'XC25-FEUGPF', 10100.00, 'USD', NULL, NULL, NULL, NULL, '', '2025-08-21 02:52:17', '2025-08-21 02:52:17'),
(11, 5, 'XC25-TPBO64', 'bank_transfer', 'pending', 'XC25-TPBO64', 43600.00, 'USD', NULL, NULL, 'XC25-TPBO64', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55'),
(12, 5, NULL, 'admin_update', 'completed', 'XC25-TPBO64', 43600.00, 'USD', NULL, NULL, NULL, NULL, '', '2025-08-21 03:01:43', '2025-08-21 03:01:43'),
(13, 6, 'XC25-FLA262', 'gateway', 'pending', NULL, 11600.00, 'usd', 'cs_live_b1P06zTLrnW1kk1dMLAKKK0usSMkdsc92MbNcwlU9smVOyrSgn9WvglZfQ', NULL, NULL, NULL, NULL, '2025-08-22 01:15:26', '2025-08-22 01:15:26'),
(14, 6, NULL, 'admin_update', 'failed', 'XC25-FLA262', 11600.00, 'USD', NULL, NULL, NULL, NULL, '', '2025-08-22 04:25:51', '2025-08-22 04:25:51');

CREATE TABLE `products` (
  `id` int(11) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `product_code` varchar(50) NOT NULL,
  `name` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `base_price` decimal(10,2) NOT NULL,
  `currency` varchar(3) DEFAULT 'USD',
  `total_stock` int(11) DEFAULT NULL,
  `reserved_stock` int(11) DEFAULT 0,
  `sold_stock` int(11) DEFAULT 0,
  `available_stock` int(11) GENERATED ALWAYS AS (case when `total_stock` is null then 999999 else greatest(0,`total_stock` - `reserved_stock` - `sold_stock`) end) STORED,
  `sale_start_date` datetime DEFAULT NULL,
  `sale_end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `requires_approval` tinyint(1) DEFAULT 0,
  `max_per_registration` int(11) DEFAULT 1,
  `display_order` int(11) DEFAULT 0,
  `metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES
(3, 4, 'TABLETOP_STANDARD', 'Table‑top Presentation – Standard', '<div>Ideal for showcasing programs and partnerships.</div><div>-Includes 1 table, 4 chairs</div><div>-Up to 2 standing banners (self‑produced)</div>', 550.00, 'USD', 15, 0, 2, '2025-07-30 19:50:00', '2025-11-28 19:51:00', 1, 0, 10, 0, NULL, '2025-08-17 03:01:16', '2025-08-21 02:28:59'),
(4, 4, 'TABLETOP_DOUBLE', 'Table‑top Presentation – Double', '<div>Ideal for showcasing programs and partnerships.</div><div>-Includes 1 table, 4 chairs</div><div>-Up to 2 standing banners (self‑produced)</div>', 850.00, 'USD', 15, 0, 2, '2025-07-31 11:51:00', '2025-11-29 11:51:00', 1, 0, 10, 0, NULL, '2025-08-17 03:01:29', '2025-08-21 02:28:59'),
(6, 3, 'DELEGATE_PASS', 'Delegates (Legacy - Migrated)', 'Access to all sessions, exhibits, and networking.', 100.00, 'USD', NULL, 0, 2, NULL, NULL, 0, 0, 1, 0, NULL, '2025-08-18 13:01:13', '2025-08-22 12:42:56'),
(7, 5, 'PLATINUM_SPONSOR', 'Platinum Sponsor', 'Includes 8 delegate passes<br data-start=\"72\" data-end=\"75\"><i>\r\nView all included items on the events page</i>', 10000.00, 'USD', NULL, 0, 2, NULL, NULL, 1, 0, 5, 0, NULL, '2025-08-18 16:26:54', '2025-08-21 02:28:59'),
(8, 6, 'ELEVATOR_PITCH', 'Elevator Pitch', 'Showcase your institution or service with a focused, high-impact pitch using a prime networking break.', 500.00, 'USD', NULL, 0, 2, NULL, NULL, 1, 0, 5, 1, NULL, '2025-08-19 03:47:46', '2025-08-21 09:49:23'),
(11, 5, 'GOLD_SPONSOR', 'Gold Sponsor', 'Includes 6 delegate passes<br data-start=\"72\" data-end=\"75\">\r\nView all included items on the events page', 8000.00, 'USD', NULL, 0, 2, NULL, NULL, 1, 0, 5, 0, NULL, '2025-08-19 05:58:32', '2025-08-21 02:28:59'),
(12, 5, 'SILVER_SPONSOR', 'Silver Sponsor', 'Includes 4 delegate passes<br data-start=\"72\" data-end=\"75\">\r\nView all included items on the events page', 5500.00, 'USD', NULL, 0, 2, NULL, NULL, 1, 0, 5, 0, NULL, '2025-08-19 06:08:05', '2025-08-21 02:28:59'),
(13, 5, 'BRONZE_SPONSOR', 'Bronze Sponsor', 'Includes 2 delegate passes<br data-start=\"72\" data-end=\"75\">\r\nView all included items on the events page', 5500.00, 'USD', NULL, 0, 2, NULL, NULL, 1, 0, 5, 0, NULL, '2025-08-19 06:09:06', '2025-08-21 02:28:59'),
(14, 6, 'IN_AD_IN_PB', 'institution Ad in Program Book', 'Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.', 1000.00, 'USD', NULL, 0, 2, NULL, NULL, 0, 0, 5, 0, NULL, '2025-08-19 06:23:51', '2025-08-21 08:54:57'),
(15, 6, 'CONF_LANYARD', 'Conference Lanyard', '2 complimentary delegate registrations<br>View all included items on the events page', 8800.00, 'USD', NULL, 0, 2, NULL, NULL, 1, 0, 5, 3, NULL, '2025-08-19 06:26:14', '2025-08-21 09:49:46'),
(16, 6, 'CONF_BAG', 'Conference Bag Sponsorship', '3 complimentary delegate registrations <br>View all included items on the events page', 9900.00, 'USD', NULL, 0, 2, NULL, NULL, 1, 0, 5, 4, NULL, '2025-08-19 06:41:50', '2025-08-21 09:56:49'),
(17, 6, 'VI_PL_PA', 'Visibility Plus Package', 'Maximize brand visibility across events globally<br>View all included items on the events page', 2500.00, 'USD', NULL, 0, 0, NULL, NULL, 1, 0, 5, 2, NULL, '2025-08-21 08:52:59', '2025-08-21 09:49:34'),
(26, 3, 'DELEGATE_EARLY_BIRD', 'Early Bird Delegate', 'Discounted delegate pass for early registrations. Access to all sessions, exhibits, and networking.', 450.00, 'USD', NULL, 0, 0, NULL, NULL, 1, 0, 50, 1, '{\"type\":\"early_bird\",\"eligibility\":[\"general\"],\"approval_required\":false,\"description_short\":\"Early registration discount\"}', '2025-08-22 12:42:56', '2025-08-22 12:42:56'),
(27, 3, 'DELEGATE_STANDARD', 'Standard Delegate', 'Regular delegate pass. Access to all sessions, exhibits, and networking.', 550.00, 'USD', NULL, 0, 0, NULL, NULL, 0, 0, 50, 2, '{\"type\":\"standard\",\"eligibility\":[\"general\"],\"approval_required\":false,\"description_short\":\"Regular registration\"}', '2025-08-22 12:42:56', '2025-08-22 14:18:04'),
(28, 3, 'DELEGATE_STUDENT', 'Student Delegate', 'Discounted pass for students. Access to all sessions, exhibits, and networking. Student verification may be required.', 300.00, 'USD', NULL, 0, 0, NULL, NULL, 0, 0, 50, 3, '{\"type\":\"student\",\"eligibility\":[\"students\"],\"approval_required\":false,\"description_short\":\"Student discount\",\"verification_note\":\"Student ID may be required at event\"}', '2025-08-22 12:42:56', '2025-08-22 14:17:57'),
(29, 3, 'DELEGATE_SPEAKER', 'Speaker', 'Complimentary pass for event speakers. Full access to all sessions, exhibits, and networking.', 0.00, 'USD', 50, 0, 0, NULL, NULL, 0, 0, 20, 4, '{\"type\":\"speaker\",\"eligibility\":[\"speakers\"],\"approval_required\":false,\"complimentary\":true,\"description_short\":\"Complimentary for speakers\"}', '2025-08-22 12:42:56', '2025-08-22 14:17:59'),
(30, 3, 'DELEGATE_VIP', 'VIP Delegate', 'Premium delegate experience with exclusive access to VIP areas, priority seating, and enhanced networking opportunities.', 800.00, 'USD', 30, 0, 0, NULL, NULL, 0, 0, 20, 5, '{\"type\":\"vip\",\"eligibility\":[\"general\"],\"approval_required\":false,\"premium\":true,\"description_short\":\"Premium experience with exclusive access\"}', '2025-08-22 12:42:56', '2025-08-22 14:18:01'),
(31, 3, 'DELEGATE_ORGANIZER', 'Event Organizer', 'Complimentary pass for event organizers and staff. Full access to all sessions, exhibits, and networking.', 0.00, 'USD', 20, 0, 0, NULL, NULL, 0, 0, 10, 6, '{\"type\":\"organizer\",\"eligibility\":[\"organizers\"],\"approval_required\":false,\"complimentary\":true,\"description_short\":\"Complimentary for organizers\"}', '2025-08-22 12:42:56', '2025-08-22 14:17:55');

CREATE TABLE `product_activity_log` (
  `id` int(11) NOT NULL,
  `activity_type` enum('product_create','product_update','product_delete','product_status_change','category_create','category_update','category_delete','category_assign','pricing_create','pricing_update','pricing_delete','discount_create','discount_update','discount_delete','discount_status_change','stock_adjustment','stock_reservation','stock_confirmation','stock_release','purchase_create','purchase_update','purchase_cancel','purchase_refund','bulk_operation','import_data','export_data','system_maintenance') NOT NULL,
  `product_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `pricing_id` int(11) DEFAULT NULL,
  `discount_id` int(11) DEFAULT NULL,
  `registration_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `user_name` varchar(255) NOT NULL,
  `user_role` varchar(100) NOT NULL,
  `action_description` text NOT NULL,
  `old_values` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `new_values` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `session_id` varchar(255) DEFAULT NULL,
  `affected_count` int(11) DEFAULT 1,
  `severity` enum('low','medium','high','critical') DEFAULT 'medium',
  `tags` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `product_activity_log` (`id`, `activity_type`, `product_id`, `category_id`, `pricing_id`, `discount_id`, `registration_id`, `user_id`, `user_name`, `user_role`, `action_description`, `old_values`, `new_values`, `ip_address`, `user_agent`, `session_id`, `affected_count`, `severity`, `tags`, `created_at`) VALUES
(1, 'category_create', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Created category: Delegate Passes', NULL, '{\"name\":\"Delegate Passes\",\"description\":\"\",\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"category\",\"create\"]', '2025-08-17 02:08:28'),
(2, 'category_create', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Created category: Delegate Passes', NULL, '{\"name\":\"Delegate Passes\",\"description\":\"\",\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"category\",\"create\"]', '2025-08-17 02:09:39'),
(5, 'category_create', NULL, 3, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Created category: Delegate Pass', NULL, '{\"name\":\"Delegate Pass\",\"description\":\"\",\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"category\",\"create\"]', '2025-08-17 02:14:36'),
(6, 'product_create', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Created product: Early Bird (DELEGATE_PASS)', NULL, '{\"category_id\":\"3\",\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird\",\"description\":\"\",\"base_price\":500,\"total_stock\":200,\"max_per_registration\":20,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"create\",\"catalog\"]', '2025-08-17 02:15:40'),
(7, 'category_create', NULL, 4, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Created category: Presentations', NULL, '{\"name\":\"Presentations\",\"description\":\"\",\"display_order\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"category\",\"create\"]', '2025-08-17 02:59:31'),
(8, 'product_create', 3, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Created product: Standard Table (TABLETOP_STANDARD)', NULL, '{\"category_id\":\"4\",\"product_code\":\"TABLETOP_STANDARD\",\"name\":\"Standard Table\",\"description\":\"\",\"base_price\":550,\"total_stock\":15,\"max_per_registration\":10,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"create\",\"catalog\"]', '2025-08-17 03:01:16'),
(9, 'product_update', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Double Table - product_code: \'TABLETOP_STANDARD_COPY\' → \'TABLETOP_DOUBLE\', name: \'Standard Table (Copy)\' → \'Double Table\', base_price: \'550.00\' → \'850\'', '{\"id\":4,\"category_id\":4,\"product_code\":\"TABLETOP_STANDARD_COPY\",\"name\":\"Standard Table (Copy)\",\"description\":\"\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:29\",\"updated_at\":\"2025-08-17 11:01:29\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_DOUBLE\",\"category_id\":\"4\",\"name\":\"Double Table\",\"description\":\"\",\"base_price\":850,\"total_stock\":15,\"max_per_registration\":10,\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 03:01:56'),
(10, 'product_update', 3, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Standard Table - description: \'\' → \'<span style=\"color: rgb(100, 116, 139); font-size: 12px;\">1 table, 4 chairs<br></span><span style=\"color: rgb(100, 116, 139); font-size: 12px;\">Up to 2 banners</span>\'', '{\"id\":3,\"category_id\":4,\"product_code\":\"TABLETOP_STANDARD\",\"name\":\"Standard Table\",\"description\":\"\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:16\",\"updated_at\":\"2025-08-17 11:01:16\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_STANDARD\",\"category_id\":\"4\",\"name\":\"Standard Table\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">1 table, 4 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":550,\"total_stock\":15,\"max_per_registration\":10,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 03:05:40'),
(11, 'product_update', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Double Table - description: \'\' → \'<span style=\"color: rgb(100, 116, 139); font-size: 12px;\">Double table, 8 chairs<br></span><span style=\"color: rgb(100, 116, 139); font-size: 12px;\">Up to 2 banners</span>\'', '{\"id\":4,\"category_id\":4,\"product_code\":\"TABLETOP_DOUBLE\",\"name\":\"Double Table\",\"description\":\"\",\"base_price\":\"850.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:29\",\"updated_at\":\"2025-08-17 11:02:20\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_DOUBLE\",\"category_id\":\"4\",\"name\":\"Double Table\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Double table, 8 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":850,\"total_stock\":15,\"max_per_registration\":10,\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 03:05:54'),
(12, 'product_update', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Double Table ttt - name: \'Double Table\' → \'Double Table ttt\'', '{\"id\":4,\"category_id\":4,\"product_code\":\"TABLETOP_DOUBLE\",\"name\":\"Double Table\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Double table, 8 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":\"850.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:29\",\"updated_at\":\"2025-08-17 11:05:54\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_DOUBLE\",\"category_id\":\"4\",\"name\":\"Double Table ttt\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Double table, 8 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":850,\"total_stock\":15,\"max_per_registration\":10,\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 03:19:08'),
(13, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 1 - name: \'Early Bird\' → \'Early Bird test 1\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird\",\"description\":\"\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-17 10:22:59\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Early Bird test 1\",\"description\":\"\",\"base_price\":500,\"total_stock\":200,\"max_per_registration\":20,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 03:35:59'),
(14, 'product_update', 3, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Standard Table test 1 - name: \'Standard Table\' → \'Standard Table test 1\'', '{\"id\":3,\"category_id\":4,\"product_code\":\"TABLETOP_STANDARD\",\"name\":\"Standard Table\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">1 table, 4 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:16\",\"updated_at\":\"2025-08-17 11:05:40\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_STANDARD\",\"category_id\":\"4\",\"name\":\"Standard Table test 1\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">1 table, 4 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":550,\"total_stock\":15,\"max_per_registration\":10,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 03:36:21'),
(15, 'product_status_change', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Double Table ttt', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 03:36:28'),
(16, 'product_status_change', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Double Table ttt', '{\"is_active\":1}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 03:39:32'),
(17, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 1 - sale_start_date: \'\' → \'2025-08-01T11:49\', sale_end_date: \'\' → \'2025-11-30T11:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird test 1\",\"description\":\"\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-17 11:39:32\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Early Bird test 1\",\"description\":\"\",\"base_price\":500,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-08-01T11:49\",\"sale_end_date\":\"2025-11-30T11:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 03:50:18'),
(18, 'product_update', 3, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Standard Table test 1 - sale_start_date: \'\' → \'2025-08-01T11:50\', sale_end_date: \'\' → \'2025-11-30T11:51\'', '{\"id\":3,\"category_id\":4,\"product_code\":\"TABLETOP_STANDARD\",\"name\":\"Standard Table test 1\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">1 table, 4 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:16\",\"updated_at\":\"2025-08-17 11:36:21\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_STANDARD\",\"category_id\":\"4\",\"name\":\"Standard Table test 1\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">1 table, 4 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":550,\"total_stock\":15,\"max_per_registration\":10,\"sale_start_date\":\"2025-08-01T11:50\",\"sale_end_date\":\"2025-11-30T11:51\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 03:51:09'),
(19, 'product_update', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Double Table ttt - sale_start_date: \'\' → \'2025-08-01T11:51\', sale_end_date: \'\' → \'2025-11-30T11:51\'', '{\"id\":4,\"category_id\":4,\"product_code\":\"TABLETOP_DOUBLE\",\"name\":\"Double Table ttt\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Double table, 8 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":\"850.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:29\",\"updated_at\":\"2025-08-17 11:39:32\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_DOUBLE\",\"category_id\":\"4\",\"name\":\"Double Table ttt\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Double table, 8 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":850,\"total_stock\":15,\"max_per_registration\":10,\"sale_start_date\":\"2025-08-01T11:51\",\"sale_end_date\":\"2025-11-30T11:51\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 03:51:24'),
(20, 'product_update', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Double Table ttt - sale_start_date: \'2025-08-01 11:51:00\' → \'2025-08-01T11:51\', sale_end_date: \'2025-11-30 11:51:00\' → \'2025-11-30T11:51\'', '{\"id\":4,\"category_id\":4,\"product_code\":\"TABLETOP_DOUBLE\",\"name\":\"Double Table ttt\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Double table, 8 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":\"850.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":\"2025-08-01 11:51:00\",\"sale_end_date\":\"2025-11-30 11:51:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:29\",\"updated_at\":\"2025-08-17 11:51:24\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_DOUBLE\",\"category_id\":\"4\",\"name\":\"Double Table ttt\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Double table, 8 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":850,\"total_stock\":15,\"max_per_registration\":10,\"sale_start_date\":\"2025-08-01T11:51\",\"sale_end_date\":\"2025-11-30T11:51\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 04:16:38'),
(21, 'product_update', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Double Table ttt - sale_start_date: \'2025-08-01 11:51:00\' → \'2025-08-01T11:51\', sale_end_date: \'2025-11-30 11:51:00\' → \'2025-11-30T11:51\'', '{\"id\":4,\"category_id\":4,\"product_code\":\"TABLETOP_DOUBLE\",\"name\":\"Double Table ttt\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Double table, 8 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":\"850.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":\"2025-08-01 11:51:00\",\"sale_end_date\":\"2025-11-30 11:51:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:29\",\"updated_at\":\"2025-08-17 12:16:38\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_DOUBLE\",\"category_id\":\"4\",\"name\":\"Double Table ttt\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Double table, 8 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":850,\"total_stock\":15,\"max_per_registration\":10,\"sale_start_date\":\"2025-08-01T11:51\",\"sale_end_date\":\"2025-11-30T11:51\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 04:21:10'),
(22, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Early Bird test 1 (Copy)', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 04:23:27'),
(23, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Early Bird test 1 (Copy)', '{\"is_active\":1}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 04:25:47'),
(24, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 2 - name: \'Early Bird test 1 (Copy)\' → \'Early Bird test 2\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":5,\"category_id\":3,\"product_code\":\"DELEGATE_PASS_COPY\",\"name\":\"Early Bird test 1 (Copy)\",\"description\":\"\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 12:23:25\",\"updated_at\":\"2025-08-17 12:25:47\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS_COPY\",\"category_id\":\"3\",\"name\":\"Early Bird test 2\",\"description\":\"\",\"base_price\":500,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 04:26:41'),
(25, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 2 - base_price: \'500.00\' → \'550\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":5,\"category_id\":3,\"product_code\":\"DELEGATE_PASS_COPY\",\"name\":\"Early Bird test 2\",\"description\":\"\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 12:23:25\",\"updated_at\":\"2025-08-17 12:26:41\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS_COPY\",\"category_id\":\"3\",\"name\":\"Early Bird test 2\",\"description\":\"\",\"base_price\":550,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 04:32:52'),
(26, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Early Bird test 2', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 04:39:15'),
(27, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Early Bird test 2', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 04:39:48'),
(28, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Early Bird test 2', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 04:42:18'),
(29, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Early Bird test 2', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 04:43:25'),
(30, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Early Bird test 2', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 04:44:45'),
(31, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Early Bird test 2', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 04:44:47'),
(32, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Early Bird test 2', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 04:44:49'),
(33, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Early Bird test 2', '{\"is_active\":0}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 04:44:54'),
(34, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 1 - description: \'\' → \'test 1&nbsp;<br>test 2\', sale_start_date: \'2025-08-01 11:49:00\' → \'2025-08-01T03:49\', sale_end_date: \'2025-11-30 11:49:00\' → \'2025-11-30T03:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird test 1\",\"description\":\"\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-08-01 11:49:00\",\"sale_end_date\":\"2025-11-30 11:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-17 12:44:54\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Early Bird test 1\",\"description\":\"test 1&nbsp;<br>test 2\",\"base_price\":500,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-08-01T03:49\",\"sale_end_date\":\"2025-11-30T03:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 04:45:25'),
(35, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 1 - sale_start_date: \'2025-08-01 03:49:00\' → \'2025-08-01T03:49\', sale_end_date: \'2025-11-30 03:49:00\' → \'2025-11-30T03:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird test 1\",\"description\":\"test 1&nbsp;<br>test 2\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-08-01 03:49:00\",\"sale_end_date\":\"2025-11-30 03:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-17 12:45:58\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Early Bird test 1\",\"description\":\"test 1&nbsp;<br>test 2\",\"base_price\":500,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-08-01T03:49\",\"sale_end_date\":\"2025-11-30T03:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 04:45:58'),
(36, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 1 - description: \'test 1&nbsp;<br>test 2\' → \'<br>\', sale_start_date: \'2025-08-01 03:49:00\' → \'2025-07-31T19:49\', sale_end_date: \'2025-11-30 03:49:00\' → \'2025-11-29T19:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird test 1\",\"description\":\"test 1&nbsp;<br>test 2\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-08-01 03:49:00\",\"sale_end_date\":\"2025-11-30 03:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-17 12:45:58\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Early Bird test 1\",\"description\":\"<br>\",\"base_price\":500,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-31T19:49\",\"sale_end_date\":\"2025-11-29T19:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 05:00:59'),
(37, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 1 - description: \'<br>\' → \'abc\', sale_start_date: \'2025-07-31 19:49:00\' → \'2025-07-31T11:49\', sale_end_date: \'2025-11-29 19:49:00\' → \'2025-11-29T11:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird test 1\",\"description\":\"<br>\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-31 19:49:00\",\"sale_end_date\":\"2025-11-29 19:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-17 13:00:59\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Early Bird test 1\",\"description\":\"abc\",\"base_price\":500,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-31T11:49\",\"sale_end_date\":\"2025-11-29T11:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 05:03:59'),
(38, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 1 - description: \'abc\' → \'<br>\', sale_start_date: \'2025-07-31 11:49:00\' → \'2025-07-31T03:49\', sale_end_date: \'2025-11-29 11:49:00\' → \'2025-11-29T03:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird test 1\",\"description\":\"abc\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-31 11:49:00\",\"sale_end_date\":\"2025-11-29 11:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-17 13:03:59\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Early Bird test 1\",\"description\":\"<br>\",\"base_price\":500,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-31T03:49\",\"sale_end_date\":\"2025-11-29T03:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 05:04:08'),
(39, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Early Bird test 2', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 05:11:17'),
(40, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Early Bird test 2', '{\"is_active\":1}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 05:11:32'),
(41, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Early Bird test 2', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 05:12:27'),
(42, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Early Bird test 2', '{\"is_active\":0}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 05:12:30'),
(43, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 1 - description: \'<br>\' → \'abcff\', sale_start_date: \'2025-07-31 03:49:00\' → \'2025-07-30T19:49\', sale_end_date: \'2025-11-29 03:49:00\' → \'2025-11-28T19:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird test 1\",\"description\":\"<br>\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-31 03:49:00\",\"sale_end_date\":\"2025-11-29 03:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-17 13:12:30\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Early Bird test 1\",\"description\":\"abcff\",\"base_price\":500,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-30T19:49\",\"sale_end_date\":\"2025-11-28T19:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 05:19:27'),
(44, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 1 - sale_start_date: \'2025-07-30 19:49:00\' → \'2025-07-30T19:49\', sale_end_date: \'2025-11-28 19:49:00\' → \'2025-11-28T19:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird test 1\",\"description\":\"abcff\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-30 19:49:00\",\"sale_end_date\":\"2025-11-28 19:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-17 13:19:50\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Early Bird test 1\",\"description\":\"abcff\",\"base_price\":500,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-30T19:49\",\"sale_end_date\":\"2025-11-28T19:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 05:19:50'),
(45, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 1 - sale_start_date: \'2025-07-30 19:49:00\' → \'2025-07-30T19:49\', sale_end_date: \'2025-11-28 19:49:00\' → \'2025-11-28T19:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird test 1\",\"description\":\"abcff\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-30 19:49:00\",\"sale_end_date\":\"2025-11-28 19:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-17 13:19:59\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Early Bird test 1\",\"description\":\"abcff\",\"base_price\":500,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-30T19:49\",\"sale_end_date\":\"2025-11-28T19:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 05:19:59'),
(46, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Early Bird test 2', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 05:22:35'),
(47, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Early Bird test 2', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 05:24:45'),
(48, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Early Bird test 2', '{\"is_active\":0}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 05:24:56'),
(49, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Early Bird test 2', '{\"is_active\":0}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 05:25:03'),
(50, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Early Bird test 2', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 05:25:10'),
(51, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Early Bird test 2', '{\"is_active\":1}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 05:49:04'),
(52, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Early Bird test 2', '{\"is_active\":1}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 05:51:05'),
(53, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Early Bird test 2', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-17 07:46:16'),
(54, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 1 - base_price: \'500.00\' → \'550\', sale_start_date: \'2025-07-30 19:49:00\' → \'2025-07-30T11:49\', sale_end_date: \'2025-11-28 19:49:00\' → \'2025-11-28T11:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird test 1\",\"description\":\"abcff\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-30 19:49:00\",\"sale_end_date\":\"2025-11-28 19:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-17 13:49:04\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Early Bird test 1\",\"description\":\"abcff\",\"base_price\":550,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-30T11:49\",\"sale_end_date\":\"2025-11-28T11:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'ccdk8k4m08jivaradiic0c9nfi', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-17 07:48:40'),
(55, 'product_status_change', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Double Table ttt', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-18 05:13:52'),
(56, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 1 - base_price: \'550.00\' → \'580\', sale_start_date: \'2025-07-30 11:49:00\' → \'2025-07-30T03:49\', sale_end_date: \'2025-11-28 11:49:00\' → \'2025-11-28T03:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird test 1\",\"description\":\"abcff\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-30 11:49:00\",\"sale_end_date\":\"2025-11-28 11:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-17 15:48:40\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Early Bird test 1\",\"description\":\"abcff\",\"base_price\":580,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-30T03:49\",\"sale_end_date\":\"2025-11-28T03:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 05:14:51'),
(57, 'product_status_change', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Double Table ttt', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-18 05:15:33'),
(58, 'product_status_change', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Double Table ttt', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-18 05:18:10'),
(59, 'product_status_change', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Double Table ttt', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-18 05:18:20'),
(60, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 2 - product_code: \'DELEGATE_PASS_COPY\' → \'DELEGATE_PASS_C\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":5,\"category_id\":3,\"product_code\":\"DELEGATE_PASS_COPY\",\"name\":\"Early Bird test 2\",\"description\":\"\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 12:23:25\",\"updated_at\":\"2025-08-17 15:46:16\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS_C\",\"category_id\":\"3\",\"name\":\"Early Bird test 2\",\"description\":\"\",\"base_price\":550,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 10:44:02'),
(61, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird test 2 - product_code: \'DELEGATE_PASS_COPY\' → \'DELEGATE_PASS2\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":5,\"category_id\":3,\"product_code\":\"DELEGATE_PASS_COPY\",\"name\":\"Early Bird test 2\",\"description\":\"\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 12:23:25\",\"updated_at\":\"2025-08-18 18:44:02\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS2\",\"category_id\":\"3\",\"name\":\"Early Bird test 2\",\"description\":\"\",\"base_price\":550,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 10:46:43');
INSERT INTO `product_activity_log` (`id`, `activity_type`, `product_id`, `category_id`, `pricing_id`, `discount_id`, `registration_id`, `user_id`, `user_name`, `user_role`, `action_description`, `old_values`, `new_values`, `ip_address`, `user_agent`, `session_id`, `affected_count`, `severity`, `tags`, `created_at`) VALUES
(63, 'product_update', 3, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Standard Table test 1 - product_code: \'TABLETOP_STANDARD\' → \'TABLETOP_STANDARD1\', sale_start_date: \'2025-08-01 11:50:00\' → \'2025-08-01T03:50\', sale_end_date: \'2025-11-30 11:51:00\' → \'2025-11-30T03:51\'', '{\"id\":3,\"category_id\":4,\"product_code\":\"TABLETOP_STANDARD\",\"name\":\"Standard Table test 1\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">1 table, 4 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":\"2025-08-01 11:50:00\",\"sale_end_date\":\"2025-11-30 11:51:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:16\",\"updated_at\":\"2025-08-18 15:57:39\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_STANDARD1\",\"category_id\":\"4\",\"name\":\"Standard Table test 1\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">1 table, 4 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":550,\"total_stock\":15,\"max_per_registration\":10,\"sale_start_date\":\"2025-08-01T03:50\",\"sale_end_date\":\"2025-11-30T03:51\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 10:49:42'),
(64, 'product_update', 3, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Table‑top Presentation – Standard - product_code: \'TABLETOP_STANDARD1\' → \'TABLETOP_STANDARD\', name: \'Standard Table test 1\' → \'Table‑top Presentation – Standard\', description: \'<span style=\"color: rgb(100, 116, 139); font-size: 12px;\">1 table, 4 chairs<br></span><span style=\"color: rgb(100, 116, 139); font-size: 12px;\">Up to 2 banners</span>\' → \'<p style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 15px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 16px; line-height: inherit; font-family: Poppins, -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen-Sans, Ubuntu, Cantarell, &quot;Helvetica Neue&quot;, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; color: rgb(30, 30, 30);\">Ideal for showcasing programs and partnerships.</p><ul style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 15px; margin-left: 30px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 16px; line-height: inherit; font-family: Poppins, -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen-Sans, Ubuntu, Cantarell, &quot;Helvetica Neue&quot;, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; list-style-position: outside; list-style-image: initial; color: rgb(0, 0, 0);\"><li style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 10px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\"><span style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline;\">Price</span>: USD 550</li><li style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 10px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\">Includes 1 table, 4 chairs</li><li style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 10px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\">Up to 2 standing banners (self‑produced)</li></ul>\', sale_start_date: \'2025-08-01 03:50:00\' → \'2025-07-31T19:50\', sale_end_date: \'2025-11-30 03:51:00\' → \'2025-11-29T19:51\'', '{\"id\":3,\"category_id\":4,\"product_code\":\"TABLETOP_STANDARD1\",\"name\":\"Standard Table test 1\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">1 table, 4 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":\"2025-08-01 03:50:00\",\"sale_end_date\":\"2025-11-30 03:51:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:16\",\"updated_at\":\"2025-08-18 18:49:42\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_STANDARD\",\"category_id\":\"4\",\"name\":\"Table\\u2011top Presentation \\u2013 Standard\",\"description\":\"<p style=\\\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 15px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 16px; line-height: inherit; font-family: Poppins, -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen-Sans, Ubuntu, Cantarell, &quot;Helvetica Neue&quot;, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; color: rgb(30, 30, 30);\\\">Ideal for showcasing programs and partnerships.<\\/p><ul style=\\\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 15px; margin-left: 30px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 16px; line-height: inherit; font-family: Poppins, -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen-Sans, Ubuntu, Cantarell, &quot;Helvetica Neue&quot;, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; list-style-position: outside; list-style-image: initial; color: rgb(0, 0, 0);\\\"><li style=\\\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 10px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\\\"><span style=\\\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline;\\\">Price<\\/span>: USD 550<\\/li><li style=\\\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 10px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\\\">Includes 1 table, 4 chairs<\\/li><li style=\\\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 10px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\\\">Up to 2 standing banners (self\\u2011produced)<\\/li><\\/ul>\",\"base_price\":550,\"total_stock\":15,\"max_per_registration\":10,\"sale_start_date\":\"2025-07-31T19:50\",\"sale_end_date\":\"2025-11-29T19:51\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 10:52:38'),
(65, 'product_update', 3, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Table‑top Presentation – Standard - description: \'<p style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 15px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 16px; line-height: inherit; font-family: Poppins, -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen-Sans, Ubuntu, Cantarell, &quot;Helvetica Neue&quot;, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; color: rgb(30, 30, 30);\">Ideal for showcasing programs and partnerships.</p><ul style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 15px; margin-left: 30px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 16px; line-height: inherit; font-family: Poppins, -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen-Sans, Ubuntu, Cantarell, &quot;Helvetica Neue&quot;, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; list-style-position: outside; list-style-image: initial; color: rgb(0, 0, 0);\"><li style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 10px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\"><span style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline;\">Price</span>: USD 550</li><li style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 10px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\">Includes 1 table, 4 chairs</li><li style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 10px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\">Up to 2 standing banners (self‑produced)</li></ul>\' → \'<div>Ideal for showcasing programs and partnerships.</div><div><span style=\"font-family: inherit;\">-Includes 1 table, 4 chairs</span></div><div>-Up to 2 standing banners (self‑produced)</div>\', sale_start_date: \'2025-07-31 19:50:00\' → \'2025-07-31T11:50\', sale_end_date: \'2025-11-29 19:51:00\' → \'2025-11-29T11:51\'', '{\"id\":3,\"category_id\":4,\"product_code\":\"TABLETOP_STANDARD\",\"name\":\"Table\\u2011top Presentation \\u2013 Standard\",\"description\":\"<p style=\\\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 15px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 16px; line-height: inherit; font-family: Poppins, -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen-Sans, Ubuntu, Cantarell, &quot;Helvetica Neue&quot;, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; color: rgb(30, 30, 30);\\\">Ideal for showcasing programs and partnerships.<\\/p><ul style=\\\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 15px; margin-left: 30px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 16px; line-height: inherit; font-family: Poppins, -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen-Sans, Ubuntu, Cantarell, &quot;Helvetica Neue&quot;, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; list-style-position: outside; list-style-image: initial; color: rgb(0, 0, 0);\\\"><li style=\\\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 10px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\\\"><span style=\\\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline;\\\">Price<\\/span>: USD 550<\\/li><li style=\\\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 10px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\\\">Includes 1 table, 4 chairs<\\/li><li style=\\\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin-top: 0px; margin-bottom: 10px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\\\">Up to 2 standing banners (self\\u2011produced)<\\/li><\\/ul>\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":\"2025-07-31 19:50:00\",\"sale_end_date\":\"2025-11-29 19:51:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:16\",\"updated_at\":\"2025-08-18 18:52:38\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_STANDARD\",\"category_id\":\"4\",\"name\":\"Table\\u2011top Presentation \\u2013 Standard\",\"description\":\"<div>Ideal for showcasing programs and partnerships.<\\/div><div><span style=\\\"font-family: inherit;\\\">-Includes 1 table, 4 chairs<\\/span><\\/div><div>-Up to 2 standing banners (self\\u2011produced)<\\/div>\",\"base_price\":550,\"total_stock\":15,\"max_per_registration\":10,\"sale_start_date\":\"2025-07-31T11:50\",\"sale_end_date\":\"2025-11-29T11:51\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 10:53:29'),
(66, 'product_update', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Table‑top Presentation – Double - name: \'Double Table ttt\' → \'Table‑top Presentation – Double\', description: \'<span style=\"color: rgb(100, 116, 139); font-size: 12px;\">Double table, 8 chairs<br></span><span style=\"color: rgb(100, 116, 139); font-size: 12px;\">Up to 2 banners</span>\' → \'<div><font color=\"#64748b\"><span style=\"font-size: 12px;\">For larger displays or team presence.</span></font></div><div><font color=\"#64748b\"><span style=\"font-size: 12px;\">-Includes double table, 8 chairs</span></font></div><div><font color=\"#64748b\"><span style=\"font-size: 12px;\">-Up to 2 standing banners (self‑produced)</span></font></div>\', sale_start_date: \'2025-08-01 11:51:00\' → \'2025-08-01T03:51\', sale_end_date: \'2025-11-30 11:51:00\' → \'2025-11-30T03:51\'', '{\"id\":4,\"category_id\":4,\"product_code\":\"TABLETOP_DOUBLE\",\"name\":\"Double Table ttt\",\"description\":\"<span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Double table, 8 chairs<br><\\/span><span style=\\\"color: rgb(100, 116, 139); font-size: 12px;\\\">Up to 2 banners<\\/span>\",\"base_price\":\"850.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":\"2025-08-01 11:51:00\",\"sale_end_date\":\"2025-11-30 11:51:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:29\",\"updated_at\":\"2025-08-18 13:18:20\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_DOUBLE\",\"category_id\":\"4\",\"name\":\"Table\\u2011top Presentation \\u2013 Double\",\"description\":\"<div><font color=\\\"#64748b\\\"><span style=\\\"font-size: 12px;\\\">For larger displays or team presence.<\\/span><\\/font><\\/div><div><font color=\\\"#64748b\\\"><span style=\\\"font-size: 12px;\\\">-Includes double table, 8 chairs<\\/span><\\/font><\\/div><div><font color=\\\"#64748b\\\"><span style=\\\"font-size: 12px;\\\">-Up to 2 standing banners (self\\u2011produced)<\\/span><\\/font><\\/div>\",\"base_price\":850,\"total_stock\":15,\"max_per_registration\":10,\"sale_start_date\":\"2025-08-01T03:51\",\"sale_end_date\":\"2025-11-30T03:51\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 10:54:17'),
(67, 'product_update', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Table‑top Presentation – Double - sale_start_date: \'2025-08-01 03:51:00\' → \'2025-07-31T19:51\', sale_end_date: \'2025-11-30 03:51:00\' → \'2025-11-29T19:51\'', '{\"id\":4,\"category_id\":4,\"product_code\":\"TABLETOP_DOUBLE\",\"name\":\"Table\\u2011top Presentation \\u2013 Double\",\"description\":\"<div><font color=\\\"#64748b\\\"><span style=\\\"font-size: 12px;\\\">For larger displays or team presence.<\\/span><\\/font><\\/div><div><font color=\\\"#64748b\\\"><span style=\\\"font-size: 12px;\\\">-Includes double table, 8 chairs<\\/span><\\/font><\\/div><div><font color=\\\"#64748b\\\"><span style=\\\"font-size: 12px;\\\">-Up to 2 standing banners (self\\u2011produced)<\\/span><\\/font><\\/div>\",\"base_price\":\"850.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":\"2025-08-01 03:51:00\",\"sale_end_date\":\"2025-11-30 03:51:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:29\",\"updated_at\":\"2025-08-18 18:54:17\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_DOUBLE\",\"category_id\":\"4\",\"name\":\"Table\\u2011top Presentation \\u2013 Double\",\"description\":\"<div><font color=\\\"#64748b\\\"><span style=\\\"font-size: 12px;\\\">For larger displays or team presence.<\\/span><\\/font><\\/div><div><font color=\\\"#64748b\\\"><span style=\\\"font-size: 12px;\\\">-Includes double table, 8 chairs<\\/span><\\/font><\\/div><div><font color=\\\"#64748b\\\"><span style=\\\"font-size: 12px;\\\">-Up to 2 standing banners (self\\u2011produced)<\\/span><\\/font><\\/div>\",\"base_price\":850,\"total_stock\":15,\"max_per_registration\":10,\"sale_start_date\":\"2025-07-31T19:51\",\"sale_end_date\":\"2025-11-29T19:51\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 10:54:54'),
(68, 'product_update', 3, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Table‑top Presentation – Standard - description: \'<div>Ideal for showcasing programs and partnerships.</div><div><span style=\"font-family: inherit;\">-Includes 1 table, 4 chairs</span></div><div>-Up to 2 standing banners (self‑produced)</div>\' → \'<br>\', sale_start_date: \'2025-07-31 11:50:00\' → \'2025-07-31T03:50\', sale_end_date: \'2025-11-29 11:51:00\' → \'2025-11-29T03:51\'', '{\"id\":3,\"category_id\":4,\"product_code\":\"TABLETOP_STANDARD\",\"name\":\"Table\\u2011top Presentation \\u2013 Standard\",\"description\":\"<div>Ideal for showcasing programs and partnerships.<\\/div><div><span style=\\\"font-family: inherit;\\\">-Includes 1 table, 4 chairs<\\/span><\\/div><div>-Up to 2 standing banners (self\\u2011produced)<\\/div>\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":\"2025-07-31 11:50:00\",\"sale_end_date\":\"2025-11-29 11:51:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:16\",\"updated_at\":\"2025-08-18 18:53:29\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_STANDARD\",\"category_id\":\"4\",\"name\":\"Table\\u2011top Presentation \\u2013 Standard\",\"description\":\"<br>\",\"base_price\":550,\"total_stock\":15,\"max_per_registration\":10,\"sale_start_date\":\"2025-07-31T03:50\",\"sale_end_date\":\"2025-11-29T03:51\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 10:55:04'),
(69, 'product_update', 3, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Table‑top Presentation – Standard - description: \'<br>\' → \'<div>Ideal for showcasing programs and partnerships.</div><div>-Includes 1 table, 4 chairs</div><div>-Up to 2 standing banners (self‑produced)</div>\', sale_start_date: \'2025-07-31 03:50:00\' → \'2025-07-30T19:50\', sale_end_date: \'2025-11-29 03:51:00\' → \'2025-11-28T19:51\'', '{\"id\":3,\"category_id\":4,\"product_code\":\"TABLETOP_STANDARD\",\"name\":\"Table\\u2011top Presentation \\u2013 Standard\",\"description\":\"<br>\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":\"2025-07-31 03:50:00\",\"sale_end_date\":\"2025-11-29 03:51:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:16\",\"updated_at\":\"2025-08-18 18:55:04\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_STANDARD\",\"category_id\":\"4\",\"name\":\"Table\\u2011top Presentation \\u2013 Standard\",\"description\":\"<div>Ideal for showcasing programs and partnerships.<\\/div><div>-Includes 1 table, 4 chairs<\\/div><div>-Up to 2 standing banners (self\\u2011produced)<\\/div>\",\"base_price\":550,\"total_stock\":15,\"max_per_registration\":10,\"sale_start_date\":\"2025-07-30T19:50\",\"sale_end_date\":\"2025-11-28T19:51\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 10:55:13'),
(70, 'product_update', 4, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Table‑top Presentation – Double - description: \'<div><font color=\"#64748b\"><span style=\"font-size: 12px;\">For larger displays or team presence.</span></font></div><div><font color=\"#64748b\"><span style=\"font-size: 12px;\">-Includes double table, 8 chairs</span></font></div><div><font color=\"#64748b\"><span style=\"font-size: 12px;\">-Up to 2 standing banners (self‑produced)</span></font></div>\' → \'<div>Ideal for showcasing programs and partnerships.</div><div>-Includes 1 table, 4 chairs</div><div>-Up to 2 standing banners (self‑produced)</div>\', sale_start_date: \'2025-07-31 19:51:00\' → \'2025-07-31T11:51\', sale_end_date: \'2025-11-29 19:51:00\' → \'2025-11-29T11:51\'', '{\"id\":4,\"category_id\":4,\"product_code\":\"TABLETOP_DOUBLE\",\"name\":\"Table\\u2011top Presentation \\u2013 Double\",\"description\":\"<div><font color=\\\"#64748b\\\"><span style=\\\"font-size: 12px;\\\">For larger displays or team presence.<\\/span><\\/font><\\/div><div><font color=\\\"#64748b\\\"><span style=\\\"font-size: 12px;\\\">-Includes double table, 8 chairs<\\/span><\\/font><\\/div><div><font color=\\\"#64748b\\\"><span style=\\\"font-size: 12px;\\\">-Up to 2 standing banners (self\\u2011produced)<\\/span><\\/font><\\/div>\",\"base_price\":\"850.00\",\"currency\":\"USD\",\"total_stock\":15,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":15,\"sale_start_date\":\"2025-07-31 19:51:00\",\"sale_end_date\":\"2025-11-29 19:51:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":10,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 11:01:29\",\"updated_at\":\"2025-08-18 18:54:54\",\"category_name\":\"Presentations\"}', '{\"product_code\":\"TABLETOP_DOUBLE\",\"category_id\":\"4\",\"name\":\"Table\\u2011top Presentation \\u2013 Double\",\"description\":\"<div>Ideal for showcasing programs and partnerships.<\\/div><div>-Includes 1 table, 4 chairs<\\/div><div>-Up to 2 standing banners (self\\u2011produced)<\\/div>\",\"base_price\":850,\"total_stock\":15,\"max_per_registration\":10,\"sale_start_date\":\"2025-07-31T11:51\",\"sale_end_date\":\"2025-11-29T11:51\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 10:58:22'),
(71, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird - name: \'Early Bird test 1\' → \'Early Bird\', sale_start_date: \'2025-07-30 03:49:00\' → \'2025-07-29T19:49\', sale_end_date: \'2025-11-28 03:49:00\' → \'2025-11-27T19:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird test 1\",\"description\":\"abcff\",\"base_price\":\"580.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-30 03:49:00\",\"sale_end_date\":\"2025-11-28 03:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-18 18:49:53\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Early Bird\",\"description\":\"abcff\",\"base_price\":580,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-29T19:49\",\"sale_end_date\":\"2025-11-27T19:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 10:58:53'),
(72, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Early Bird - base_price: \'580.00\' → \'550\', sale_start_date: \'2025-07-29 19:49:00\' → \'2025-07-29T11:49\', sale_end_date: \'2025-11-27 19:49:00\' → \'2025-11-27T11:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird\",\"description\":\"abcff\",\"base_price\":\"580.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-29 19:49:00\",\"sale_end_date\":\"2025-11-27 19:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-18 18:59:14\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Early Bird\",\"description\":\"abcff\",\"base_price\":550,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-29T11:49\",\"sale_end_date\":\"2025-11-27T11:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 10:59:26'),
(73, 'category_create', NULL, 5, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Created category: Sponsorship', NULL, '{\"name\":\"Sponsorship\",\"description\":\"\",\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"category\",\"create\"]', '2025-08-18 11:04:05'),
(74, 'category_create', NULL, 6, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Created category: Other Sponsorship', NULL, '{\"name\":\"Other Sponsorship\",\"description\":\"\",\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"category\",\"create\"]', '2025-08-18 11:04:18'),
(75, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Delegates - name: \'Early Bird\' → \'Delegates\', sale_start_date: \'2025-07-29 11:49:00\' → \'2025-07-29T03:49\', sale_end_date: \'2025-11-27 11:49:00\' → \'2025-11-27T03:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Early Bird\",\"description\":\"abcff\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-29 11:49:00\",\"sale_end_date\":\"2025-11-27 11:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-18 18:59:26\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Delegates\",\"description\":\"abcff\",\"base_price\":550,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-29T03:49\",\"sale_end_date\":\"2025-11-27T03:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 12:51:18'),
(76, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Delegates - sale_start_date: \'2025-07-29 03:49:00\' → \'2025-07-28T19:49\', sale_end_date: \'2025-11-27 03:49:00\' → \'2025-11-26T19:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Delegates\",\"description\":\"abcff\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-29 03:49:00\",\"sale_end_date\":\"2025-11-27 03:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-18 20:51:18\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Delegates\",\"description\":\"abcff\",\"base_price\":550,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-28T19:49\",\"sale_end_date\":\"2025-11-26T19:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 12:52:13'),
(77, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Delegates - sale_start_date: \'2025-07-28 19:49:00\' → \'2025-07-28T11:49\', sale_end_date: \'2025-11-26 19:49:00\' → \'2025-11-26T11:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Delegates\",\"description\":\"abcff\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-28 19:49:00\",\"sale_end_date\":\"2025-11-26 19:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-18 20:52:13\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Delegates\",\"description\":\"abcff\",\"base_price\":550,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-28T11:49\",\"sale_end_date\":\"2025-11-26T11:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 12:54:31'),
(78, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Delegates - sale_start_date: \'2025-07-28 11:49:00\' → \'2025-07-28T03:49\', sale_end_date: \'2025-11-26 11:49:00\' → \'2025-11-26T03:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Delegates\",\"description\":\"abcff\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-28 11:49:00\",\"sale_end_date\":\"2025-11-26 11:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-18 20:54:31\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Delegates\",\"description\":\"abcff\",\"base_price\":550,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-28T03:49\",\"sale_end_date\":\"2025-11-26T03:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 12:55:06'),
(79, 'product_create', 6, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Created product: sdsd (dsdsd)', NULL, '{\"category_id\":\"6\",\"product_code\":\"dsdsd\",\"name\":\"sdsd\",\"description\":\"\",\"base_price\":100,\"total_stock\":null,\"max_per_registration\":1,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"create\",\"catalog\"]', '2025-08-18 13:01:13'),
(80, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Delegates - sale_start_date: \'2025-07-28 03:49:00\' → \'2025-07-27T19:49\', sale_end_date: \'2025-11-26 03:49:00\' → \'2025-11-25T19:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Delegates\",\"description\":\"abcff\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-28 03:49:00\",\"sale_end_date\":\"2025-11-26 03:49:00\",\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-18 20:55:06\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Delegates\",\"description\":\"abcff\",\"base_price\":550,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-27T19:49\",\"sale_end_date\":\"2025-11-25T19:49\",\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 13:01:27'),
(81, 'product_update', 6, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: aaaaaaaaa - name: \'sdsd\' → \'aaaaaaaaa\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":6,\"category_id\":6,\"product_code\":\"dsdsd\",\"name\":\"sdsd\",\"description\":\"\",\"base_price\":\"100.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":1,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-18 21:01:13\",\"updated_at\":\"2025-08-18 21:01:13\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"dsdsd\",\"category_id\":\"6\",\"name\":\"aaaaaaaaa\",\"description\":\"\",\"base_price\":100,\"total_stock\":null,\"max_per_registration\":1,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 13:05:42'),
(82, 'product_status_change', 6, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: aaaaaaaaa', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-18 13:07:13'),
(83, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Delegates', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-18 13:07:14'),
(84, 'product_update', 6, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: aaaaaaaaa - category_id: \'6\' → \'3\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":6,\"category_id\":6,\"product_code\":\"dsdsd\",\"name\":\"aaaaaaaaa\",\"description\":\"\",\"base_price\":\"100.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":1,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-18 21:01:13\",\"updated_at\":\"2025-08-18 21:07:13\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"dsdsd\",\"category_id\":\"3\",\"name\":\"aaaaaaaaa\",\"description\":\"\",\"base_price\":100,\"total_stock\":null,\"max_per_registration\":1,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 13:07:44'),
(85, 'product_update', 6, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Delegates - name: \'aaaaaaaaa\' → \'Delegates\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":6,\"category_id\":3,\"product_code\":\"dsdsd\",\"name\":\"aaaaaaaaa\",\"description\":\"\",\"base_price\":\"100.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":1,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-18 21:01:13\",\"updated_at\":\"2025-08-18 21:09:43\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"dsdsd\",\"category_id\":\"3\",\"name\":\"Delegates\",\"description\":\"\",\"base_price\":100,\"total_stock\":null,\"max_per_registration\":1,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 13:32:18'),
(86, 'product_update', 6, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Delegates - description: \'\' → \'Access to all sessions, exhibits, and networking.\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":6,\"category_id\":3,\"product_code\":\"dsdsd\",\"name\":\"Delegates\",\"description\":\"\",\"base_price\":\"100.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":1,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-18 21:01:13\",\"updated_at\":\"2025-08-18 21:32:18\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"dsdsd\",\"category_id\":\"3\",\"name\":\"Delegates\",\"description\":\"Access to all sessions, exhibits, and networking.\",\"base_price\":100,\"total_stock\":null,\"max_per_registration\":1,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 13:39:57'),
(87, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Delegates', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-18 13:41:07'),
(88, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Delegates', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-18 13:41:15'),
(89, 'product_create', 7, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Created product: Platinum (Platinum Sponsor)', NULL, '{\"category_id\":\"5\",\"product_code\":\"Platinum Sponsor\",\"name\":\"Platinum\",\"description\":\"\",\"base_price\":10000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"create\",\"catalog\"]', '2025-08-18 16:26:54'),
(90, 'product_status_change', 7, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Platinum', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-18 16:35:56'),
(91, 'product_update', 7, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Platinum - product_code: \'Platinum Sponsor\' → \'Platinum_Sponsor\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":7,\"category_id\":5,\"product_code\":\"Platinum Sponsor\",\"name\":\"Platinum\",\"description\":\"\",\"base_price\":\"10000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 00:26:54\",\"updated_at\":\"2025-08-19 00:35:56\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"Platinum_Sponsor\",\"category_id\":\"5\",\"name\":\"Platinum\",\"description\":\"\",\"base_price\":10000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'vghsjlorhl11k2tju86iiedfi0', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-18 16:45:08'),
(92, 'product_update', 8, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Platinum (Copy) - category_id: \'5\' → \'6\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\', is_active: \'0\' → \'1\'', '{\"id\":8,\"category_id\":5,\"product_code\":\"Platinum_Sponsor_COPY\",\"name\":\"Platinum (Copy)\",\"description\":\"\",\"base_price\":\"10000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 11:47:46\",\"updated_at\":\"2025-08-19 11:47:46\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"Platinum_Sponsor_COPY\",\"category_id\":\"6\",\"name\":\"Platinum (Copy)\",\"description\":\"\",\"base_price\":10000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 03:47:55'),
(93, 'product_update', 8, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Platinum (Copy) - total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":8,\"category_id\":6,\"product_code\":\"Platinum_Sponsor_COPY\",\"name\":\"Platinum (Copy)\",\"description\":\"\",\"base_price\":\"10000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 11:47:46\",\"updated_at\":\"2025-08-19 11:47:55\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"Platinum_Sponsor_COPY\",\"category_id\":\"6\",\"name\":\"Platinum (Copy)\",\"description\":\"\",\"base_price\":10000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 04:13:01'),
(94, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Platinum (Copy)', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-19 05:06:57'),
(95, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Platinum (Copy) (Copy)', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-19 05:07:04');
INSERT INTO `product_activity_log` (`id`, `activity_type`, `product_id`, `category_id`, `pricing_id`, `discount_id`, `registration_id`, `user_id`, `user_name`, `user_role`, `action_description`, `old_values`, `new_values`, `ip_address`, `user_agent`, `session_id`, `affected_count`, `severity`, `tags`, `created_at`) VALUES
(96, 'category_update', NULL, 6, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated category: Other Sponsorship - display_order: \'0\' → \'4\'', '{\"id\":6,\"name\":\"Other Sponsorship\",\"description\":\"\",\"display_order\":0,\"is_active\":1,\"created_at\":\"2025-08-18 19:04:18\",\"updated_at\":\"2025-08-18 19:04:18\"}', '{\"name\":\"Other Sponsorship\",\"description\":\"\",\"display_order\":4,\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"category\",\"update\"]', '2025-08-19 05:56:06'),
(97, 'category_update', NULL, 5, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated category: Sponsorship - display_order: \'0\' → \'3\'', '{\"id\":5,\"name\":\"Sponsorship\",\"description\":\"\",\"display_order\":0,\"is_active\":1,\"created_at\":\"2025-08-18 19:04:05\",\"updated_at\":\"2025-08-18 19:04:05\"}', '{\"name\":\"Sponsorship\",\"description\":\"\",\"display_order\":3,\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"category\",\"update\"]', '2025-08-19 05:56:14'),
(98, 'product_update', 7, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Platinum Sponsor - product_code: \'Platinum_Sponsor\' → \'PLATINUM_SPONSOR\', name: \'Platinum\' → \'Platinum Sponsor\', description: \'\' → \'<div>8 Delegate passes</div><div>Double‑wide table</div><div>Premium pull-up banner (high-traffic zone)</div><div>Hero leaderboard (970 × 250)</div><div>Logo prominence on all channels</div><div>Digital certificate &amp; e-badge</div><div>Institution brochure insert in Conference Bag</div><div>Branded welcome pack insert 5‑min keynote</div><div>Elevator Pitch</div><div>GDPR-compliant attendee list</div><div>App.LE Club membership (1 yr)</div>\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":7,\"category_id\":5,\"product_code\":\"Platinum_Sponsor\",\"name\":\"Platinum\",\"description\":\"\",\"base_price\":\"10000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 00:26:54\",\"updated_at\":\"2025-08-19 00:45:08\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"PLATINUM_SPONSOR\",\"category_id\":\"5\",\"name\":\"Platinum Sponsor\",\"description\":\"<div>8 Delegate passes<\\/div><div>Double\\u2011wide table<\\/div><div>Premium pull-up banner (high-traffic zone)<\\/div><div>Hero leaderboard (970 \\u00d7 250)<\\/div><div>Logo prominence on all channels<\\/div><div>Digital certificate &amp; e-badge<\\/div><div>Institution brochure insert in Conference Bag<\\/div><div>Branded welcome pack insert 5\\u2011min keynote<\\/div><div>Elevator Pitch<\\/div><div>GDPR-compliant attendee list<\\/div><div>App.LE Club membership (1 yr)<\\/div>\",\"base_price\":10000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 05:58:10'),
(99, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Platinum (Copy)', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-19 05:58:19'),
(101, 'product_update', 11, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Gold Sponsor - product_code: \'PLATINUM_SPONSOR_COPY2\' → \'GOLD_SPONSOR\', name: \'Platinum Sponsor (Copy)\' → \'Gold Sponsor\', description: \'<div>8 Delegate passes</div><div>Double‑wide table</div><div>Premium pull-up banner (high-traffic zone)</div><div>Hero leaderboard (970 × 250)</div><div>Logo prominence on all channels</div><div>Digital certificate &amp; e-badge</div><div>Institution brochure insert in Conference Bag</div><div>Branded welcome pack insert 5‑min keynote</div><div>Elevator Pitch</div><div>GDPR-compliant attendee list</div><div>App.LE Club membership (1 yr)</div>\' → \'<div>6 Delegate passes</div><div>Double‑wide table</div><div>Premium pull-up banner (high-traffic zone)</div><div>Leaderboard (728 × 90)</div><div>Logo prominence on all channels</div><div>Digital certificate &amp; e-badge</div><div>Institution brochure insert in Conference Bag</div><div>Elevator Pitch</div><div>GDPR-compliant attendee list</div><div>App.LE Club membership (1 yr)</div>\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":11,\"category_id\":5,\"product_code\":\"PLATINUM_SPONSOR_COPY2\",\"name\":\"Platinum Sponsor (Copy)\",\"description\":\"<div>8 Delegate passes<\\/div><div>Double\\u2011wide table<\\/div><div>Premium pull-up banner (high-traffic zone)<\\/div><div>Hero leaderboard (970 \\u00d7 250)<\\/div><div>Logo prominence on all channels<\\/div><div>Digital certificate &amp; e-badge<\\/div><div>Institution brochure insert in Conference Bag<\\/div><div>Branded welcome pack insert 5\\u2011min keynote<\\/div><div>Elevator Pitch<\\/div><div>GDPR-compliant attendee list<\\/div><div>App.LE Club membership (1 yr)<\\/div>\",\"base_price\":\"10000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 13:58:32\",\"updated_at\":\"2025-08-19 13:58:32\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"GOLD_SPONSOR\",\"category_id\":\"5\",\"name\":\"Gold Sponsor\",\"description\":\"<div>6 Delegate passes<\\/div><div>Double\\u2011wide table<\\/div><div>Premium pull-up banner (high-traffic zone)<\\/div><div>Leaderboard (728 \\u00d7 90)<\\/div><div>Logo prominence on all channels<\\/div><div>Digital certificate &amp; e-badge<\\/div><div>Institution brochure insert in Conference Bag<\\/div><div>Elevator Pitch<\\/div><div>GDPR-compliant attendee list<\\/div><div>App.LE Club membership (1 yr)<\\/div>\",\"base_price\":10000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 05:59:25'),
(102, 'product_status_change', 11, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Gold Sponsor', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-19 05:59:29'),
(103, 'product_update', 7, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Platinum Sponsor - description: \'<div>8 Delegate passes</div><div>Double‑wide table</div><div>Premium pull-up banner (high-traffic zone)</div><div>Hero leaderboard (970 × 250)</div><div>Logo prominence on all channels</div><div>Digital certificate &amp; e-badge</div><div>Institution brochure insert in Conference Bag</div><div>Branded welcome pack insert 5‑min keynote</div><div>Elevator Pitch</div><div>GDPR-compliant attendee list</div><div>App.LE Club membership (1 yr)</div>\' → \'<br>\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":7,\"category_id\":5,\"product_code\":\"PLATINUM_SPONSOR\",\"name\":\"Platinum Sponsor\",\"description\":\"<div>8 Delegate passes<\\/div><div>Double\\u2011wide table<\\/div><div>Premium pull-up banner (high-traffic zone)<\\/div><div>Hero leaderboard (970 \\u00d7 250)<\\/div><div>Logo prominence on all channels<\\/div><div>Digital certificate &amp; e-badge<\\/div><div>Institution brochure insert in Conference Bag<\\/div><div>Branded welcome pack insert 5\\u2011min keynote<\\/div><div>Elevator Pitch<\\/div><div>GDPR-compliant attendee list<\\/div><div>App.LE Club membership (1 yr)<\\/div>\",\"base_price\":\"10000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 00:26:54\",\"updated_at\":\"2025-08-19 13:58:10\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"PLATINUM_SPONSOR\",\"category_id\":\"5\",\"name\":\"Platinum Sponsor\",\"description\":\"<br>\",\"base_price\":10000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 06:02:59'),
(104, 'product_update', 11, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Gold Sponsor - description: \'<div>6 Delegate passes</div><div>Double‑wide table</div><div>Premium pull-up banner (high-traffic zone)</div><div>Leaderboard (728 × 90)</div><div>Logo prominence on all channels</div><div>Digital certificate &amp; e-badge</div><div>Institution brochure insert in Conference Bag</div><div>Elevator Pitch</div><div>GDPR-compliant attendee list</div><div>App.LE Club membership (1 yr)</div>\' → \'<br>\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":11,\"category_id\":5,\"product_code\":\"GOLD_SPONSOR\",\"name\":\"Gold Sponsor\",\"description\":\"<div>6 Delegate passes<\\/div><div>Double\\u2011wide table<\\/div><div>Premium pull-up banner (high-traffic zone)<\\/div><div>Leaderboard (728 \\u00d7 90)<\\/div><div>Logo prominence on all channels<\\/div><div>Digital certificate &amp; e-badge<\\/div><div>Institution brochure insert in Conference Bag<\\/div><div>Elevator Pitch<\\/div><div>GDPR-compliant attendee list<\\/div><div>App.LE Club membership (1 yr)<\\/div>\",\"base_price\":\"10000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 13:58:32\",\"updated_at\":\"2025-08-19 13:59:29\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"GOLD_SPONSOR\",\"category_id\":\"5\",\"name\":\"Gold Sponsor\",\"description\":\"<br>\",\"base_price\":10000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 06:03:09'),
(105, 'product_update', 7, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Platinum Sponsor - description: \'<br>\' → \'Includes&nbsp;8 Delegate passes<br>View all included items at events page\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":7,\"category_id\":5,\"product_code\":\"PLATINUM_SPONSOR\",\"name\":\"Platinum Sponsor\",\"description\":\"<br>\",\"base_price\":\"10000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 00:26:54\",\"updated_at\":\"2025-08-19 14:02:59\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"PLATINUM_SPONSOR\",\"category_id\":\"5\",\"name\":\"Platinum Sponsor\",\"description\":\"Includes&nbsp;8 Delegate passes<br>View all included items at events page\",\"base_price\":10000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 06:04:28'),
(106, 'product_update', 7, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Platinum Sponsor - description: \'Includes&nbsp;8 Delegate passes<br>View all included items at events page\' → \'Includes 8 delegate passes<br data-start=\"72\" data-end=\"75\"><i>\r\nView all included items on the events page</i>\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":7,\"category_id\":5,\"product_code\":\"PLATINUM_SPONSOR\",\"name\":\"Platinum Sponsor\",\"description\":\"Includes&nbsp;8 Delegate passes<br>View all included items at events page\",\"base_price\":\"10000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 00:26:54\",\"updated_at\":\"2025-08-19 14:04:28\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"PLATINUM_SPONSOR\",\"category_id\":\"5\",\"name\":\"Platinum Sponsor\",\"description\":\"Includes 8 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\"><i>\\r\\nView all included items on the events page<\\/i>\",\"base_price\":10000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 06:07:27'),
(107, 'product_update', 11, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Gold Sponsor - description: \'<br>\' → \'Includes 6 delegate passes<br data-start=\"72\" data-end=\"75\">\r\nView all included items on the events page\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":11,\"category_id\":5,\"product_code\":\"GOLD_SPONSOR\",\"name\":\"Gold Sponsor\",\"description\":\"<br>\",\"base_price\":\"10000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 13:58:32\",\"updated_at\":\"2025-08-19 14:03:09\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"GOLD_SPONSOR\",\"category_id\":\"5\",\"name\":\"Gold Sponsor\",\"description\":\"Includes 6 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\">\\r\\nView all included items on the events page\",\"base_price\":10000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 06:07:44'),
(108, 'product_update', 12, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Silver Sponsor - product_code: \'GOLD_SPONSOR_COPY\' → \'SILVER_SPONSOR\', name: \'Gold Sponsor (Copy)\' → \'Silver Sponsor\', description: \'Includes 6 delegate passes<br data-start=\"72\" data-end=\"75\">\r\nView all included items on the events page\' → \'Includes 4 delegate passes<br data-start=\"72\" data-end=\"75\">\r\nView all included items on the events page\', base_price: \'10000.00\' → \'5500\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":12,\"category_id\":5,\"product_code\":\"GOLD_SPONSOR_COPY\",\"name\":\"Gold Sponsor (Copy)\",\"description\":\"Includes 6 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\">\\r\\nView all included items on the events page\",\"base_price\":\"10000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 14:08:05\",\"updated_at\":\"2025-08-19 14:08:05\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"SILVER_SPONSOR\",\"category_id\":\"5\",\"name\":\"Silver Sponsor\",\"description\":\"Includes 4 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\">\\r\\nView all included items on the events page\",\"base_price\":5500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 06:08:40'),
(109, 'product_status_change', 12, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Silver Sponsor', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-19 06:08:45'),
(110, 'product_update', 11, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Gold Sponsor - base_price: \'10000.00\' → \'8000\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":11,\"category_id\":5,\"product_code\":\"GOLD_SPONSOR\",\"name\":\"Gold Sponsor\",\"description\":\"Includes 6 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\">\\r\\nView all included items on the events page\",\"base_price\":\"10000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 13:58:32\",\"updated_at\":\"2025-08-19 14:07:44\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"GOLD_SPONSOR\",\"category_id\":\"5\",\"name\":\"Gold Sponsor\",\"description\":\"Includes 6 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\">\\r\\nView all included items on the events page\",\"base_price\":8000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 06:09:00'),
(111, 'product_update', 13, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Bronze Sponsor - product_code: \'SILVER_SPONSOR_COPY\' → \'BRONZE_SPONSOR\', name: \'Silver Sponsor (Copy)\' → \'Bronze Sponsor\', description: \'Includes 4 delegate passes<br data-start=\"72\" data-end=\"75\">\r\nView all included items on the events page\' → \'Includes 2 delegate passes<br data-start=\"72\" data-end=\"75\">\r\nView all included items on the events page\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":13,\"category_id\":5,\"product_code\":\"SILVER_SPONSOR_COPY\",\"name\":\"Silver Sponsor (Copy)\",\"description\":\"Includes 4 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\">\\r\\nView all included items on the events page\",\"base_price\":\"5500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 14:09:06\",\"updated_at\":\"2025-08-19 14:09:06\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"BRONZE_SPONSOR\",\"category_id\":\"5\",\"name\":\"Bronze Sponsor\",\"description\":\"Includes 2 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\">\\r\\nView all included items on the events page\",\"base_price\":5500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 06:09:34'),
(112, 'product_status_change', 13, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Bronze Sponsor', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-19 06:09:44'),
(113, 'product_status_change', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Platinum (Copy) (Copy)', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-19 06:22:51'),
(115, 'product_update', 8, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Elevator Pitch - product_code: \'Platinum_Sponsor_COPY\' → \'ELEVATOR_PITCH\', name: \'Platinum (Copy)\' → \'Elevator Pitch\', description: \'\' → \'Showcase your institution or service with a focused, high-impact pitch using a prime networking break.\', base_price: \'10000.00\' → \'500\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":8,\"category_id\":6,\"product_code\":\"Platinum_Sponsor_COPY\",\"name\":\"Platinum (Copy)\",\"description\":\"\",\"base_price\":\"10000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 11:47:46\",\"updated_at\":\"2025-08-19 12:13:01\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"ELEVATOR_PITCH\",\"category_id\":\"6\",\"name\":\"Elevator Pitch\",\"description\":\"Showcase your institution or service with a focused, high-impact pitch using a prime networking break.\",\"base_price\":500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 06:23:46'),
(116, 'product_update', 14, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: nstitution Ad in Program Book - product_code: \'ELEVATOR_PITCH_COPY\' → \'IN_AD_IN_PB\', name: \'Elevator Pitch (Copy)\' → \'nstitution Ad in Program Book\', description: \'Showcase your institution or service with a focused, high-impact pitch using a prime networking break.\' → \'<span class=\"a_GcMg font-feature-liga-off font-feature-clig-off font-feature-calt-off text-decoration-none text-strikethrough-none\" style=\"color: rgba(0,0,0,var(--O42jJQ,1)); caret-color: rgb(0, 0, 0); --Ys-XuQ: none; font-kerning: none;\">Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.</span>\', base_price: \'500.00\' → \'1000\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":14,\"category_id\":6,\"product_code\":\"ELEVATOR_PITCH_COPY\",\"name\":\"Elevator Pitch (Copy)\",\"description\":\"Showcase your institution or service with a focused, high-impact pitch using a prime networking break.\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 14:23:51\",\"updated_at\":\"2025-08-19 14:23:51\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"IN_AD_IN_PB\",\"category_id\":\"6\",\"name\":\"nstitution Ad in Program Book\",\"description\":\"<span class=\\\"a_GcMg font-feature-liga-off font-feature-clig-off font-feature-calt-off text-decoration-none text-strikethrough-none\\\" style=\\\"color: rgba(0,0,0,var(--O42jJQ,1)); caret-color: rgb(0, 0, 0); --Ys-XuQ: none; font-kerning: none;\\\">Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.<\\/span>\",\"base_price\":1000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 06:25:08'),
(117, 'product_status_change', 14, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: nstitution Ad in Program Book', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-19 06:25:18'),
(118, 'product_update', 14, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: nstitution Ad in Program Book - description: \'<span class=\"a_GcMg font-feature-liga-off font-feature-clig-off font-feature-calt-off text-decoration-none text-strikethrough-none\" style=\"color: rgba(0,0,0,var(--O42jJQ,1)); caret-color: rgb(0, 0, 0); --Ys-XuQ: none; font-kerning: none;\">Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.</span>\' → \'Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":14,\"category_id\":6,\"product_code\":\"IN_AD_IN_PB\",\"name\":\"nstitution Ad in Program Book\",\"description\":\"<span class=\\\"a_GcMg font-feature-liga-off font-feature-clig-off font-feature-calt-off text-decoration-none text-strikethrough-none\\\" style=\\\"color: rgba(0,0,0,var(--O42jJQ,1)); caret-color: rgb(0, 0, 0); --Ys-XuQ: none; font-kerning: none;\\\">Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.<\\/span>\",\"base_price\":\"1000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 14:23:51\",\"updated_at\":\"2025-08-19 14:25:18\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"IN_AD_IN_PB\",\"category_id\":\"6\",\"name\":\"nstitution Ad in Program Book\",\"description\":\"Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.\",\"base_price\":1000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 06:25:40'),
(119, 'product_update', 14, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: institution Ad in Program Book - name: \'nstitution Ad in Program Book\' → \'institution Ad in Program Book\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":14,\"category_id\":6,\"product_code\":\"IN_AD_IN_PB\",\"name\":\"nstitution Ad in Program Book\",\"description\":\"Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.\",\"base_price\":\"1000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 14:23:51\",\"updated_at\":\"2025-08-19 14:25:40\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"IN_AD_IN_PB\",\"category_id\":\"6\",\"name\":\"institution Ad in Program Book\",\"description\":\"Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.\",\"base_price\":1000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 06:26:04'),
(120, 'product_update', 15, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Conference Lanyard - product_code: \'IN_AD_IN_PB_COPY\' → \'CONF_LANYARD\', name: \'institution Ad in Program Book (Copy)\' → \'Conference Lanyard\', description: \'Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.\' → \'2 complimentary delegate registrations<br>View all included items on the events page\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":15,\"category_id\":6,\"product_code\":\"IN_AD_IN_PB_COPY\",\"name\":\"institution Ad in Program Book (Copy)\",\"description\":\"Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.\",\"base_price\":\"1000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 14:26:14\",\"updated_at\":\"2025-08-19 14:26:14\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"CONF_LANYARD\",\"category_id\":\"6\",\"name\":\"Conference Lanyard\",\"description\":\"2 complimentary delegate registrations<br>View all included items on the events page\",\"base_price\":1000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 06:27:37'),
(121, 'product_status_change', 15, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Conference Lanyard', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-19 06:41:42'),
(122, 'product_update', 16, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Conference Bag Sponsorship - product_code: \'CONF_LANYARD_COPY\' → \'CONF_BAG\', name: \'Conference Lanyard (Copy)\' → \'Conference Bag Sponsorship\', description: \'2 complimentary delegate registrations<br>View all included items on the events page\' → \'<span class=\"a_GcMg font-feature-liga-off font-feature-clig-off font-feature-calt-off text-decoration-none text-strikethrough-none\" style=\"color: rgba(0,0,0,var(--O42jJQ,1)); caret-color: rgb(0, 0, 0); --Ys-XuQ: none; font-kerning: none;\">3 complimentary delegate registrations</span><br>View all included items on the events page\', base_price: \'1000.00\' → \'11000\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":16,\"category_id\":6,\"product_code\":\"CONF_LANYARD_COPY\",\"name\":\"Conference Lanyard (Copy)\",\"description\":\"2 complimentary delegate registrations<br>View all included items on the events page\",\"base_price\":\"1000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 14:41:50\",\"updated_at\":\"2025-08-19 14:41:50\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"CONF_BAG\",\"category_id\":\"6\",\"name\":\"Conference Bag Sponsorship\",\"description\":\"<span class=\\\"a_GcMg font-feature-liga-off font-feature-clig-off font-feature-calt-off text-decoration-none text-strikethrough-none\\\" style=\\\"color: rgba(0,0,0,var(--O42jJQ,1)); caret-color: rgb(0, 0, 0); --Ys-XuQ: none; font-kerning: none;\\\">3 complimentary delegate registrations<\\/span><br>View all included items on the events page\",\"base_price\":11000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 06:42:48'),
(123, 'product_status_change', 16, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Conference Bag Sponsorship', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-19 06:42:57'),
(124, 'product_update', NULL, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Delegates - product_code: \'DELEGATE_PASS\' → \'oldd\', sale_start_date: \'2025-07-27 19:49:00\' → \'2025-07-27T11:49\', sale_end_date: \'2025-11-25 19:49:00\' → \'2025-11-25T11:49\'', '{\"id\":1,\"category_id\":3,\"product_code\":\"DELEGATE_PASS\",\"name\":\"Delegates\",\"description\":\"abcff\",\"base_price\":\"550.00\",\"currency\":\"USD\",\"total_stock\":200,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":200,\"sale_start_date\":\"2025-07-27 19:49:00\",\"sale_end_date\":\"2025-11-25 19:49:00\",\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":20,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-17 10:15:40\",\"updated_at\":\"2025-08-18 21:41:15\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"oldd\",\"category_id\":\"3\",\"name\":\"Delegates\",\"description\":\"abcff\",\"base_price\":550,\"total_stock\":200,\"max_per_registration\":20,\"sale_start_date\":\"2025-07-27T11:49\",\"sale_end_date\":\"2025-11-25T11:49\",\"is_active\":0,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 13:15:25'),
(125, 'product_update', 6, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Delegates - product_code: \'dsdsd\' → \'DELEGATE_PASS\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":6,\"category_id\":3,\"product_code\":\"dsdsd\",\"name\":\"Delegates\",\"description\":\"Access to all sessions, exhibits, and networking.\",\"base_price\":\"100.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":1,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-18 21:01:13\",\"updated_at\":\"2025-08-18 21:51:48\",\"category_name\":\"Delegate Pass\"}', '{\"product_code\":\"DELEGATE_PASS\",\"category_id\":\"3\",\"name\":\"Delegates\",\"description\":\"Access to all sessions, exhibits, and networking.\",\"base_price\":100,\"total_stock\":null,\"max_per_registration\":1,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 13:15:30'),
(126, 'product_update', 7, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Platinum Sponsor - total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":7,\"category_id\":5,\"product_code\":\"PLATINUM_SPONSOR\",\"name\":\"Platinum Sponsor\",\"description\":\"Includes 8 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\"><i>\\r\\nView all included items on the events page<\\/i>\",\"base_price\":\"10000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 00:26:54\",\"updated_at\":\"2025-08-19 14:07:27\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"PLATINUM_SPONSOR\",\"category_id\":\"5\",\"name\":\"Platinum Sponsor\",\"description\":\"Includes 8 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\"><i>\\r\\nView all included items on the events page<\\/i>\",\"base_price\":10000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 13:15:39'),
(127, 'product_update', 11, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Gold Sponsor - total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":11,\"category_id\":5,\"product_code\":\"GOLD_SPONSOR\",\"name\":\"Gold Sponsor\",\"description\":\"Includes 6 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\">\\r\\nView all included items on the events page\",\"base_price\":\"8000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 13:58:32\",\"updated_at\":\"2025-08-19 14:09:00\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"GOLD_SPONSOR\",\"category_id\":\"5\",\"name\":\"Gold Sponsor\",\"description\":\"Includes 6 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\">\\r\\nView all included items on the events page\",\"base_price\":8000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 13:16:01'),
(128, 'product_update', 12, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Silver Sponsor - total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":12,\"category_id\":5,\"product_code\":\"SILVER_SPONSOR\",\"name\":\"Silver Sponsor\",\"description\":\"Includes 4 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\">\\r\\nView all included items on the events page\",\"base_price\":\"5500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 14:08:05\",\"updated_at\":\"2025-08-19 14:08:45\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"SILVER_SPONSOR\",\"category_id\":\"5\",\"name\":\"Silver Sponsor\",\"description\":\"Includes 4 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\">\\r\\nView all included items on the events page\",\"base_price\":5500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 13:16:23'),
(129, 'product_update', 13, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Updated product: Bronze Sponsor - total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":13,\"category_id\":5,\"product_code\":\"BRONZE_SPONSOR\",\"name\":\"Bronze Sponsor\",\"description\":\"Includes 2 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\">\\r\\nView all included items on the events page\",\"base_price\":\"5500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 14:09:06\",\"updated_at\":\"2025-08-19 14:09:44\",\"category_name\":\"Sponsorship\"}', '{\"product_code\":\"BRONZE_SPONSOR\",\"category_id\":\"5\",\"name\":\"Bronze Sponsor\",\"description\":\"Includes 2 delegate passes<br data-start=\\\"72\\\" data-end=\\\"75\\\">\\r\\nView all included items on the events page\",\"base_price\":5500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'p7odnfephaphg29p50i7d575j8', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-19 13:16:38'),
(131, 'product_update', 17, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Visibility Plus Package - product_code: \'IN_AD_IN_PB_COPY\' → \'VI_PL_PA\', name: \'institution Ad in Program Book (Copy)\' → \'Visibility Plus Package\', description: \'Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.\' → \'<div>Maximize your brand exposure across both the event and AppliedHE’s global media channels.</div><div><br></div><div>Logo prominence on main event backdrop and official channels</div><div><br></div><div>Institution brochure insert in every delegate’s conference bag</div><div><br></div><div>Xtra! Xtra! banner placement on AppliedHE’s global higher education news platform</div>\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":17,\"category_id\":6,\"product_code\":\"IN_AD_IN_PB_COPY\",\"name\":\"institution Ad in Program Book (Copy)\",\"description\":\"Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.\",\"base_price\":\"1000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-21 08:52:59\",\"updated_at\":\"2025-08-21 08:52:59\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"VI_PL_PA\",\"category_id\":\"6\",\"name\":\"Visibility Plus Package\",\"description\":\"<div>Maximize your brand exposure across both the event and AppliedHE\\u2019s global media channels.<\\/div><div><br><\\/div><div>Logo prominence on main event backdrop and official channels<\\/div><div><br><\\/div><div>Institution brochure insert in every delegate\\u2019s conference bag<\\/div><div><br><\\/div><div>Xtra! Xtra! banner placement on AppliedHE\\u2019s global higher education news platform<\\/div>\",\"base_price\":1000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":0,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 08:54:40'),
(132, 'product_status_change', 14, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Product deactivated: institution Ad in Program Book', '{\"is_active\":1}', '{\"is_active\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-21 08:54:57'),
(133, 'product_status_change', 17, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Product activated: Visibility Plus Package', '{\"is_active\":0}', '{\"is_active\":1}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-21 08:55:08');
INSERT INTO `product_activity_log` (`id`, `activity_type`, `product_id`, `category_id`, `pricing_id`, `discount_id`, `registration_id`, `user_id`, `user_name`, `user_role`, `action_description`, `old_values`, `new_values`, `ip_address`, `user_agent`, `session_id`, `affected_count`, `severity`, `tags`, `created_at`) VALUES
(134, 'product_update', 17, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Visibility Plus Package - base_price: \'1000.00\' → \'2500\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":17,\"category_id\":6,\"product_code\":\"VI_PL_PA\",\"name\":\"Visibility Plus Package\",\"description\":\"<div>Maximize your brand exposure across both the event and AppliedHE\\u2019s global media channels.<\\/div><div><br><\\/div><div>Logo prominence on main event backdrop and official channels<\\/div><div><br><\\/div><div>Institution brochure insert in every delegate\\u2019s conference bag<\\/div><div><br><\\/div><div>Xtra! Xtra! banner placement on AppliedHE\\u2019s global higher education news platform<\\/div>\",\"base_price\":\"1000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-21 08:52:59\",\"updated_at\":\"2025-08-21 08:55:08\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"VI_PL_PA\",\"category_id\":\"6\",\"name\":\"Visibility Plus Package\",\"description\":\"<div>Maximize your brand exposure across both the event and AppliedHE\\u2019s global media channels.<\\/div><div><br><\\/div><div>Logo prominence on main event backdrop and official channels<\\/div><div><br><\\/div><div>Institution brochure insert in every delegate\\u2019s conference bag<\\/div><div><br><\\/div><div>Xtra! Xtra! banner placement on AppliedHE\\u2019s global higher education news platform<\\/div>\",\"base_price\":2500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 08:58:45'),
(135, 'product_update', 17, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Visibility Plus Package - description: \'<div>Maximize your brand exposure across both the event and AppliedHE’s global media channels.</div><div><br></div><div>Logo prominence on main event backdrop and official channels</div><div><br></div><div>Institution brochure insert in every delegate’s conference bag</div><div><br></div><div>Xtra! Xtra! banner placement on AppliedHE’s global higher education news platform</div>\' → \'<div>Maximize your brand exposure across both the event and AppliedHE’s global media channels.</div><div>Logo prominence on main event backdrop and official channels</div><div>Institution brochure insert in every delegate’s conference bag</div><div>Xtra! Xtra! banner placement on AppliedHE’s global higher education news platform</div>\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":17,\"category_id\":6,\"product_code\":\"VI_PL_PA\",\"name\":\"Visibility Plus Package\",\"description\":\"<div>Maximize your brand exposure across both the event and AppliedHE\\u2019s global media channels.<\\/div><div><br><\\/div><div>Logo prominence on main event backdrop and official channels<\\/div><div><br><\\/div><div>Institution brochure insert in every delegate\\u2019s conference bag<\\/div><div><br><\\/div><div>Xtra! Xtra! banner placement on AppliedHE\\u2019s global higher education news platform<\\/div>\",\"base_price\":\"2500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-21 08:52:59\",\"updated_at\":\"2025-08-21 08:58:45\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"VI_PL_PA\",\"category_id\":\"6\",\"name\":\"Visibility Plus Package\",\"description\":\"<div>Maximize your brand exposure across both the event and AppliedHE\\u2019s global media channels.<\\/div><div>Logo prominence on main event backdrop and official channels<\\/div><div>Institution brochure insert in every delegate\\u2019s conference bag<\\/div><div>Xtra! Xtra! banner placement on AppliedHE\\u2019s global higher education news platform<\\/div>\",\"base_price\":2500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 08:59:40'),
(136, 'product_update', 17, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Visibility Plus Package - description: \'<div>Maximize your brand exposure across both the event and AppliedHE’s global media channels.</div><div>Logo prominence on main event backdrop and official channels</div><div>Institution brochure insert in every delegate’s conference bag</div><div>Xtra! Xtra! banner placement on AppliedHE’s global higher education news platform</div>\' → \'<div><article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\" data-testid=\"conversation-turn-2\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"961f7309-5347-424e-a292-9e5be8a7c039\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><p data-start=\"0\" data-end=\"110\" data-is-last-node=\"\" data-is-only-node=\"\">Maximize brand visibility through event backdrops, delegate materials, and AppliedHE’s global media platforms</p><p data-start=\"0\" data-end=\"110\" data-is-last-node=\"\" data-is-only-node=\"\"><span style=\"font-family: inherit;\">View all included items on the events page</span></p></div></div></div></div></div></div></article></div>\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":17,\"category_id\":6,\"product_code\":\"VI_PL_PA\",\"name\":\"Visibility Plus Package\",\"description\":\"<div>Maximize your brand exposure across both the event and AppliedHE\\u2019s global media channels.<\\/div><div>Logo prominence on main event backdrop and official channels<\\/div><div>Institution brochure insert in every delegate\\u2019s conference bag<\\/div><div>Xtra! Xtra! banner placement on AppliedHE\\u2019s global higher education news platform<\\/div>\",\"base_price\":\"2500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-21 08:52:59\",\"updated_at\":\"2025-08-21 08:59:40\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"VI_PL_PA\",\"category_id\":\"6\",\"name\":\"Visibility Plus Package\",\"description\":\"<div><article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\\\" data-testid=\\\"conversation-turn-2\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"961f7309-5347-424e-a292-9e5be8a7c039\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><p data-start=\\\"0\\\" data-end=\\\"110\\\" data-is-last-node=\\\"\\\" data-is-only-node=\\\"\\\">Maximize brand visibility through event backdrops, delegate materials, and AppliedHE\\u2019s global media platforms<\\/p><p data-start=\\\"0\\\" data-end=\\\"110\\\" data-is-last-node=\\\"\\\" data-is-only-node=\\\"\\\"><span style=\\\"font-family: inherit;\\\">View all included items on the events page<\\/span><\\/p><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/article><\\/div>\",\"base_price\":2500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:05:08'),
(137, 'product_update', 17, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Visibility Plus Package - description: \'<div><article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\" data-testid=\"conversation-turn-2\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"961f7309-5347-424e-a292-9e5be8a7c039\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><p data-start=\"0\" data-end=\"110\" data-is-last-node=\"\" data-is-only-node=\"\">Maximize brand visibility through event backdrops, delegate materials, and AppliedHE’s global media platforms</p><p data-start=\"0\" data-end=\"110\" data-is-last-node=\"\" data-is-only-node=\"\"><span style=\"font-family: inherit;\">View all included items on the events page</span></p></div></div></div></div></div></div></article></div>\' → \'<article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\" data-testid=\"conversation-turn-2\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"961f7309-5347-424e-a292-9e5be8a7c039\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-4\" data-testid=\"conversation-turn-4\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"1a5bd7e6-300c-464b-98fa-c9e8af267e62\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><p data-start=\"0\" data-end=\"101\" data-is-last-node=\"\" data-is-only-node=\"\">Maximize brand visibility through event backdrops, materials, and AppliedHE’s global media platforms.</p></div></div></div></div><div class=\"flex min-h-[46px] justify-start\"></div><div class=\"mt-3 w-full empty:hidden\"><div class=\"text-center\"></div></div></div></div></article><div aria-hidden=\"true\" data-edge=\"true\" class=\"pointer-events-none h-px w-px\"></div><p data-start=\"0\" data-end=\"110\" data-is-last-node=\"\" data-is-only-node=\"\"><span style=\"font-family: inherit;\">View all included items on the events page</span></p></div></div></div></div></div></div></article>\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":17,\"category_id\":6,\"product_code\":\"VI_PL_PA\",\"name\":\"Visibility Plus Package\",\"description\":\"<div><article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\\\" data-testid=\\\"conversation-turn-2\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"961f7309-5347-424e-a292-9e5be8a7c039\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><p data-start=\\\"0\\\" data-end=\\\"110\\\" data-is-last-node=\\\"\\\" data-is-only-node=\\\"\\\">Maximize brand visibility through event backdrops, delegate materials, and AppliedHE\\u2019s global media platforms<\\/p><p data-start=\\\"0\\\" data-end=\\\"110\\\" data-is-last-node=\\\"\\\" data-is-only-node=\\\"\\\"><span style=\\\"font-family: inherit;\\\">View all included items on the events page<\\/span><\\/p><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/article><\\/div>\",\"base_price\":\"2500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-21 08:52:59\",\"updated_at\":\"2025-08-21 09:05:08\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"VI_PL_PA\",\"category_id\":\"6\",\"name\":\"Visibility Plus Package\",\"description\":\"<article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\\\" data-testid=\\\"conversation-turn-2\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"961f7309-5347-424e-a292-9e5be8a7c039\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-4\\\" data-testid=\\\"conversation-turn-4\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"1a5bd7e6-300c-464b-98fa-c9e8af267e62\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><p data-start=\\\"0\\\" data-end=\\\"101\\\" data-is-last-node=\\\"\\\" data-is-only-node=\\\"\\\">Maximize brand visibility through event backdrops, materials, and AppliedHE\\u2019s global media platforms.<\\/p><\\/div><\\/div><\\/div><\\/div><div class=\\\"flex min-h-[46px] justify-start\\\"><\\/div><div class=\\\"mt-3 w-full empty:hidden\\\"><div class=\\\"text-center\\\"><\\/div><\\/div><\\/div><\\/div><\\/article><div aria-hidden=\\\"true\\\" data-edge=\\\"true\\\" class=\\\"pointer-events-none h-px w-px\\\"><\\/div><p data-start=\\\"0\\\" data-end=\\\"110\\\" data-is-last-node=\\\"\\\" data-is-only-node=\\\"\\\"><span style=\\\"font-family: inherit;\\\">View all included items on the events page<\\/span><\\/p><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/article>\",\"base_price\":2500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:06:17'),
(138, 'product_update', 17, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Visibility Plus Package - description: \'<article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\" data-testid=\"conversation-turn-2\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"961f7309-5347-424e-a292-9e5be8a7c039\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-4\" data-testid=\"conversation-turn-4\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"1a5bd7e6-300c-464b-98fa-c9e8af267e62\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><p data-start=\"0\" data-end=\"101\" data-is-last-node=\"\" data-is-only-node=\"\">Maximize brand visibility through event backdrops, materials, and AppliedHE’s global media platforms.</p></div></div></div></div><div class=\"flex min-h-[46px] justify-start\"></div><div class=\"mt-3 w-full empty:hidden\"><div class=\"text-center\"></div></div></div></div></article><div aria-hidden=\"true\" data-edge=\"true\" class=\"pointer-events-none h-px w-px\"></div><p data-start=\"0\" data-end=\"110\" data-is-last-node=\"\" data-is-only-node=\"\"><span style=\"font-family: inherit;\">View all included items on the events page</span></p></div></div></div></div></div></div></article>\' → \'<article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\" data-testid=\"conversation-turn-2\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"961f7309-5347-424e-a292-9e5be8a7c039\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-4\" data-testid=\"conversation-turn-4\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"1a5bd7e6-300c-464b-98fa-c9e8af267e62\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-5\" data-testid=\"conversation-turn-6\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"8e7b71ca-b068-42d6-a39a-3083292324d0\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><p data-start=\"0\" data-end=\"49\" data-is-last-node=\"\" data-is-only-node=\"\">Maximize brand visibility across events globally.</p></div></div></div></div><div class=\"flex min-h-[46px] justify-start\"></div><div class=\"mt-3 w-full empty:hidden\"><div class=\"text-center\"></div></div></div></div></article><div aria-hidden=\"true\" data-edge=\"true\" class=\"pointer-events-none h-px w-px\"></div><p data-start=\"0\" data-end=\"101\" data-is-last-node=\"\" data-is-only-node=\"\"><span style=\"font-family: inherit;\">View all included items on the events page</span></p></div></div></div></div></div></div></article></div></div></div></div></div></div></article>\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":17,\"category_id\":6,\"product_code\":\"VI_PL_PA\",\"name\":\"Visibility Plus Package\",\"description\":\"<article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\\\" data-testid=\\\"conversation-turn-2\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"961f7309-5347-424e-a292-9e5be8a7c039\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-4\\\" data-testid=\\\"conversation-turn-4\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"1a5bd7e6-300c-464b-98fa-c9e8af267e62\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><p data-start=\\\"0\\\" data-end=\\\"101\\\" data-is-last-node=\\\"\\\" data-is-only-node=\\\"\\\">Maximize brand visibility through event backdrops, materials, and AppliedHE\\u2019s global media platforms.<\\/p><\\/div><\\/div><\\/div><\\/div><div class=\\\"flex min-h-[46px] justify-start\\\"><\\/div><div class=\\\"mt-3 w-full empty:hidden\\\"><div class=\\\"text-center\\\"><\\/div><\\/div><\\/div><\\/div><\\/article><div aria-hidden=\\\"true\\\" data-edge=\\\"true\\\" class=\\\"pointer-events-none h-px w-px\\\"><\\/div><p data-start=\\\"0\\\" data-end=\\\"110\\\" data-is-last-node=\\\"\\\" data-is-only-node=\\\"\\\"><span style=\\\"font-family: inherit;\\\">View all included items on the events page<\\/span><\\/p><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/article>\",\"base_price\":\"2500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-21 08:52:59\",\"updated_at\":\"2025-08-21 09:06:17\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"VI_PL_PA\",\"category_id\":\"6\",\"name\":\"Visibility Plus Package\",\"description\":\"<article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\\\" data-testid=\\\"conversation-turn-2\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"961f7309-5347-424e-a292-9e5be8a7c039\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-4\\\" data-testid=\\\"conversation-turn-4\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"1a5bd7e6-300c-464b-98fa-c9e8af267e62\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-5\\\" data-testid=\\\"conversation-turn-6\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"8e7b71ca-b068-42d6-a39a-3083292324d0\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><p data-start=\\\"0\\\" data-end=\\\"49\\\" data-is-last-node=\\\"\\\" data-is-only-node=\\\"\\\">Maximize brand visibility across events globally.<\\/p><\\/div><\\/div><\\/div><\\/div><div class=\\\"flex min-h-[46px] justify-start\\\"><\\/div><div class=\\\"mt-3 w-full empty:hidden\\\"><div class=\\\"text-center\\\"><\\/div><\\/div><\\/div><\\/div><\\/article><div aria-hidden=\\\"true\\\" data-edge=\\\"true\\\" class=\\\"pointer-events-none h-px w-px\\\"><\\/div><p data-start=\\\"0\\\" data-end=\\\"101\\\" data-is-last-node=\\\"\\\" data-is-only-node=\\\"\\\"><span style=\\\"font-family: inherit;\\\">View all included items on the events page<\\/span><\\/p><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/article><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/article>\",\"base_price\":2500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:07:33');
INSERT INTO `product_activity_log` (`id`, `activity_type`, `product_id`, `category_id`, `pricing_id`, `discount_id`, `registration_id`, `user_id`, `user_name`, `user_role`, `action_description`, `old_values`, `new_values`, `ip_address`, `user_agent`, `session_id`, `affected_count`, `severity`, `tags`, `created_at`) VALUES
(139, 'product_update', 17, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Visibility Plus Package - description: \'<article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\" data-testid=\"conversation-turn-2\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"961f7309-5347-424e-a292-9e5be8a7c039\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-4\" data-testid=\"conversation-turn-4\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"1a5bd7e6-300c-464b-98fa-c9e8af267e62\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-5\" data-testid=\"conversation-turn-6\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"8e7b71ca-b068-42d6-a39a-3083292324d0\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><p data-start=\"0\" data-end=\"49\" data-is-last-node=\"\" data-is-only-node=\"\">Maximize brand visibility across events globally.</p></div></div></div></div><div class=\"flex min-h-[46px] justify-start\"></div><div class=\"mt-3 w-full empty:hidden\"><div class=\"text-center\"></div></div></div></div></article><div aria-hidden=\"true\" data-edge=\"true\" class=\"pointer-events-none h-px w-px\"></div><p data-start=\"0\" data-end=\"101\" data-is-last-node=\"\" data-is-only-node=\"\"><span style=\"font-family: inherit;\">View all included items on the events page</span></p></div></div></div></div></div></div></article></div></div></div></div></div></div></article>\' → \'<article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\" data-testid=\"conversation-turn-2\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"961f7309-5347-424e-a292-9e5be8a7c039\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-4\" data-testid=\"conversation-turn-4\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"1a5bd7e6-300c-464b-98fa-c9e8af267e62\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-5\" data-testid=\"conversation-turn-6\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"8e7b71ca-b068-42d6-a39a-3083292324d0\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><p data-start=\"0\" data-end=\"49\" data-is-last-node=\"\" data-is-only-node=\"\">Maximize brand visibility across events globally<br>View all included items on the events page</p></div></div></div></div></div></div></article></div></div></div></div></div></div></article></div></div></div></div></div></div></article>\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":17,\"category_id\":6,\"product_code\":\"VI_PL_PA\",\"name\":\"Visibility Plus Package\",\"description\":\"<article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\\\" data-testid=\\\"conversation-turn-2\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"961f7309-5347-424e-a292-9e5be8a7c039\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-4\\\" data-testid=\\\"conversation-turn-4\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"1a5bd7e6-300c-464b-98fa-c9e8af267e62\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-5\\\" data-testid=\\\"conversation-turn-6\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"8e7b71ca-b068-42d6-a39a-3083292324d0\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><p data-start=\\\"0\\\" data-end=\\\"49\\\" data-is-last-node=\\\"\\\" data-is-only-node=\\\"\\\">Maximize brand visibility across events globally.<\\/p><\\/div><\\/div><\\/div><\\/div><div class=\\\"flex min-h-[46px] justify-start\\\"><\\/div><div class=\\\"mt-3 w-full empty:hidden\\\"><div class=\\\"text-center\\\"><\\/div><\\/div><\\/div><\\/div><\\/article><div aria-hidden=\\\"true\\\" data-edge=\\\"true\\\" class=\\\"pointer-events-none h-px w-px\\\"><\\/div><p data-start=\\\"0\\\" data-end=\\\"101\\\" data-is-last-node=\\\"\\\" data-is-only-node=\\\"\\\"><span style=\\\"font-family: inherit;\\\">View all included items on the events page<\\/span><\\/p><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/article><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/article>\",\"base_price\":\"2500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-21 08:52:59\",\"updated_at\":\"2025-08-21 09:07:33\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"VI_PL_PA\",\"category_id\":\"6\",\"name\":\"Visibility Plus Package\",\"description\":\"<article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\\\" data-testid=\\\"conversation-turn-2\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"961f7309-5347-424e-a292-9e5be8a7c039\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-4\\\" data-testid=\\\"conversation-turn-4\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"1a5bd7e6-300c-464b-98fa-c9e8af267e62\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-5\\\" data-testid=\\\"conversation-turn-6\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"8e7b71ca-b068-42d6-a39a-3083292324d0\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><p data-start=\\\"0\\\" data-end=\\\"49\\\" data-is-last-node=\\\"\\\" data-is-only-node=\\\"\\\">Maximize brand visibility across events globally<br>View all included items on the events page<\\/p><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/article><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/article><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/article>\",\"base_price\":2500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:09:41'),
(140, 'product_update', 16, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Conference Bag Sponsorship - description: \'<span class=\"a_GcMg font-feature-liga-off font-feature-clig-off font-feature-calt-off text-decoration-none text-strikethrough-none\" style=\"color: rgba(0,0,0,var(--O42jJQ,1)); caret-color: rgb(0, 0, 0); --Ys-XuQ: none; font-kerning: none;\">3 complimentary delegate registrations</span><br>View all included items on the events page\' → \'<div><font color=\"#000000\"><span style=\"caret-color: rgb(0, 0, 0);\">3 complimentary delegate registrations</span></font></div><div><font color=\"#000000\"><span style=\"caret-color: rgb(0, 0, 0);\">View all included items on the events page</span></font></div>\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":16,\"category_id\":6,\"product_code\":\"CONF_BAG\",\"name\":\"Conference Bag Sponsorship\",\"description\":\"<span class=\\\"a_GcMg font-feature-liga-off font-feature-clig-off font-feature-calt-off text-decoration-none text-strikethrough-none\\\" style=\\\"color: rgba(0,0,0,var(--O42jJQ,1)); caret-color: rgb(0, 0, 0); --Ys-XuQ: none; font-kerning: none;\\\">3 complimentary delegate registrations<\\/span><br>View all included items on the events page\",\"base_price\":\"11000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":2,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 06:41:50\",\"updated_at\":\"2025-08-21 02:28:59\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"CONF_BAG\",\"category_id\":\"6\",\"name\":\"Conference Bag Sponsorship\",\"description\":\"<div><font color=\\\"#000000\\\"><span style=\\\"caret-color: rgb(0, 0, 0);\\\">3 complimentary delegate registrations<\\/span><\\/font><\\/div><div><font color=\\\"#000000\\\"><span style=\\\"caret-color: rgb(0, 0, 0);\\\">View all included items on the events page<\\/span><\\/font><\\/div>\",\"base_price\":11000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:10:05'),
(141, 'product_update', 16, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Conference Bag Sponsorship - description: \'<div><font color=\"#000000\"><span style=\"caret-color: rgb(0, 0, 0);\">3 complimentary delegate registrations</span></font></div><div><font color=\"#000000\"><span style=\"caret-color: rgb(0, 0, 0);\">View all included items on the events page</span></font></div>\' → \'<div style=\"font-family: Poppins, system-ui, -apple-system, &quot;Segoe UI&quot;, Roboto, Ubuntu, Cantarell, &quot;Noto Sans&quot;, sans-serif; font-size: 14px; white-space-collapse: collapse;\"><font color=\"#000000\"><span style=\"caret-color: rgb(0, 0, 0);\">3 complimentary delegate registrations</span></font></div><div style=\"font-family: Poppins, system-ui, -apple-system, &quot;Segoe UI&quot;, Roboto, Ubuntu, Cantarell, &quot;Noto Sans&quot;, sans-serif; font-size: 14px; white-space-collapse: collapse;\"><font color=\"#000000\"><span style=\"caret-color: rgb(0, 0, 0);\">View all included items on the events page</span></font></div>\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":16,\"category_id\":6,\"product_code\":\"CONF_BAG\",\"name\":\"Conference Bag Sponsorship\",\"description\":\"<div><font color=\\\"#000000\\\"><span style=\\\"caret-color: rgb(0, 0, 0);\\\">3 complimentary delegate registrations<\\/span><\\/font><\\/div><div><font color=\\\"#000000\\\"><span style=\\\"caret-color: rgb(0, 0, 0);\\\">View all included items on the events page<\\/span><\\/font><\\/div>\",\"base_price\":\"11000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":2,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 06:41:50\",\"updated_at\":\"2025-08-21 09:10:05\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"CONF_BAG\",\"category_id\":\"6\",\"name\":\"Conference Bag Sponsorship\",\"description\":\"<div style=\\\"font-family: Poppins, system-ui, -apple-system, &quot;Segoe UI&quot;, Roboto, Ubuntu, Cantarell, &quot;Noto Sans&quot;, sans-serif; font-size: 14px; white-space-collapse: collapse;\\\"><font color=\\\"#000000\\\"><span style=\\\"caret-color: rgb(0, 0, 0);\\\">3 complimentary delegate registrations<\\/span><\\/font><\\/div><div style=\\\"font-family: Poppins, system-ui, -apple-system, &quot;Segoe UI&quot;, Roboto, Ubuntu, Cantarell, &quot;Noto Sans&quot;, sans-serif; font-size: 14px; white-space-collapse: collapse;\\\"><font color=\\\"#000000\\\"><span style=\\\"caret-color: rgb(0, 0, 0);\\\">View all included items on the events page<\\/span><\\/font><\\/div>\",\"base_price\":11000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:14:00'),
(142, 'product_update', 17, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Visibility Plus Package - description: \'<article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\" data-testid=\"conversation-turn-2\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"961f7309-5347-424e-a292-9e5be8a7c039\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-4\" data-testid=\"conversation-turn-4\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"1a5bd7e6-300c-464b-98fa-c9e8af267e62\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><article class=\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\" tabindex=\"-1\" dir=\"auto\" data-turn-id=\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-5\" data-testid=\"conversation-turn-6\" data-scroll-anchor=\"true\" data-turn=\"assistant\"><div class=\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\"><div class=\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\" tabindex=\"-1\"><div class=\"flex max-w-full flex-col grow\"><div data-message-author-role=\"assistant\" data-message-id=\"8e7b71ca-b068-42d6-a39a-3083292324d0\" dir=\"auto\" class=\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\" data-message-model-slug=\"gpt-5\"><div class=\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\"><div class=\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\"><p data-start=\"0\" data-end=\"49\" data-is-last-node=\"\" data-is-only-node=\"\">Maximize brand visibility across events globally<br>View all included items on the events page</p></div></div></div></div></div></div></article></div></div></div></div></div></div></article></div></div></div></div></div></div></article>\' → \'Maximize brand visibility across events globally.\r\n<br>View all included items on the events page\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":17,\"category_id\":6,\"product_code\":\"VI_PL_PA\",\"name\":\"Visibility Plus Package\",\"description\":\"<article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-3\\\" data-testid=\\\"conversation-turn-2\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"961f7309-5347-424e-a292-9e5be8a7c039\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-4\\\" data-testid=\\\"conversation-turn-4\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"1a5bd7e6-300c-464b-98fa-c9e8af267e62\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><article class=\\\"text-token-text-primary w-full focus:outline-none scroll-mt-[calc(var(--header-height)+min(200px,max(70px,20svh)))]\\\" tabindex=\\\"-1\\\" dir=\\\"auto\\\" data-turn-id=\\\"request-WEB:2d39a8d7-3faa-4c1b-adf6-993f9427ecf8-5\\\" data-testid=\\\"conversation-turn-6\\\" data-scroll-anchor=\\\"true\\\" data-turn=\\\"assistant\\\"><div class=\\\"text-base my-auto mx-auto pb-10 [--thread-content-margin:--spacing(4)] @[37rem]:[--thread-content-margin:--spacing(6)] @[72rem]:[--thread-content-margin:--spacing(16)] px-(--thread-content-margin)\\\"><div class=\\\"[--thread-content-max-width:32rem] @[34rem]:[--thread-content-max-width:40rem] @[64rem]:[--thread-content-max-width:48rem] mx-auto max-w-(--thread-content-max-width) flex-1 group\\/turn-messages focus-visible:outline-hidden relative flex w-full min-w-0 flex-col agent-turn\\\" tabindex=\\\"-1\\\"><div class=\\\"flex max-w-full flex-col grow\\\"><div data-message-author-role=\\\"assistant\\\" data-message-id=\\\"8e7b71ca-b068-42d6-a39a-3083292324d0\\\" dir=\\\"auto\\\" class=\\\"min-h-8 text-message relative flex w-full flex-col items-end gap-2 text-start break-words whitespace-normal [.text-message+&amp;]:mt-5\\\" data-message-model-slug=\\\"gpt-5\\\"><div class=\\\"flex w-full flex-col gap-1 empty:hidden first:pt-[3px]\\\"><div class=\\\"markdown prose dark:prose-invert w-full break-words dark markdown-new-styling\\\"><p data-start=\\\"0\\\" data-end=\\\"49\\\" data-is-last-node=\\\"\\\" data-is-only-node=\\\"\\\">Maximize brand visibility across events globally<br>View all included items on the events page<\\/p><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/article><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/article><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/article>\",\"base_price\":\"2500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-21 08:52:59\",\"updated_at\":\"2025-08-21 09:09:41\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"VI_PL_PA\",\"category_id\":\"6\",\"name\":\"Visibility Plus Package\",\"description\":\"Maximize brand visibility across events globally.\\r\\n<br>View all included items on the events page\",\"base_price\":2500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:16:28'),
(143, 'product_update', 16, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Conference Bag Sponsorship - description: \'<div style=\"font-family: Poppins, system-ui, -apple-system, &quot;Segoe UI&quot;, Roboto, Ubuntu, Cantarell, &quot;Noto Sans&quot;, sans-serif; font-size: 14px; white-space-collapse: collapse;\"><font color=\"#000000\"><span style=\"caret-color: rgb(0, 0, 0);\">3 complimentary delegate registrations</span></font></div><div style=\"font-family: Poppins, system-ui, -apple-system, &quot;Segoe UI&quot;, Roboto, Ubuntu, Cantarell, &quot;Noto Sans&quot;, sans-serif; font-size: 14px; white-space-collapse: collapse;\"><font color=\"#000000\"><span style=\"caret-color: rgb(0, 0, 0);\">View all included items on the events page</span></font></div>\' → \'3 complimentary delegate registrations\r\n&lt;br&gt;View all included items on the events page\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":16,\"category_id\":6,\"product_code\":\"CONF_BAG\",\"name\":\"Conference Bag Sponsorship\",\"description\":\"<div style=\\\"font-family: Poppins, system-ui, -apple-system, &quot;Segoe UI&quot;, Roboto, Ubuntu, Cantarell, &quot;Noto Sans&quot;, sans-serif; font-size: 14px; white-space-collapse: collapse;\\\"><font color=\\\"#000000\\\"><span style=\\\"caret-color: rgb(0, 0, 0);\\\">3 complimentary delegate registrations<\\/span><\\/font><\\/div><div style=\\\"font-family: Poppins, system-ui, -apple-system, &quot;Segoe UI&quot;, Roboto, Ubuntu, Cantarell, &quot;Noto Sans&quot;, sans-serif; font-size: 14px; white-space-collapse: collapse;\\\"><font color=\\\"#000000\\\"><span style=\\\"caret-color: rgb(0, 0, 0);\\\">View all included items on the events page<\\/span><\\/font><\\/div>\",\"base_price\":\"11000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":2,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 06:41:50\",\"updated_at\":\"2025-08-21 09:14:00\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"CONF_BAG\",\"category_id\":\"6\",\"name\":\"Conference Bag Sponsorship\",\"description\":\"3 complimentary delegate registrations\\r\\n&lt;br&gt;View all included items on the events page\",\"base_price\":11000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:17:07'),
(144, 'product_update', 17, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Visibility Plus Package - description: \'Maximize brand visibility across events globally.\r\n<br>View all included items on the events page\' → \'Maximize brand visibility across events globally<br>View all included items on the events page\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":17,\"category_id\":6,\"product_code\":\"VI_PL_PA\",\"name\":\"Visibility Plus Package\",\"description\":\"Maximize brand visibility across events globally.\\r\\n<br>View all included items on the events page\",\"base_price\":\"2500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-21 08:52:59\",\"updated_at\":\"2025-08-21 09:16:28\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"VI_PL_PA\",\"category_id\":\"6\",\"name\":\"Visibility Plus Package\",\"description\":\"Maximize brand visibility across events globally<br>View all included items on the events page\",\"base_price\":2500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:17:14'),
(145, 'product_update', 16, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Conference Bag Sponsorship - description: \'3 complimentary delegate registrations\r\n&lt;br&gt;View all included items on the events page\' → \'3 complimentary delegate registrations <br>View all included items on the events page\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":16,\"category_id\":6,\"product_code\":\"CONF_BAG\",\"name\":\"Conference Bag Sponsorship\",\"description\":\"3 complimentary delegate registrations\\r\\n&lt;br&gt;View all included items on the events page\",\"base_price\":\"11000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":2,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 06:41:50\",\"updated_at\":\"2025-08-21 09:17:07\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"CONF_BAG\",\"category_id\":\"6\",\"name\":\"Conference Bag Sponsorship\",\"description\":\"3 complimentary delegate registrations <br>View all included items on the events page\",\"base_price\":11000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:17:42'),
(146, 'product_update', 15, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Conference Lanyard - base_price: \'1000.00\' → \'8800\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":15,\"category_id\":6,\"product_code\":\"CONF_LANYARD\",\"name\":\"Conference Lanyard\",\"description\":\"2 complimentary delegate registrations<br>View all included items on the events page\",\"base_price\":\"1000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":2,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 06:26:14\",\"updated_at\":\"2025-08-21 02:28:59\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"CONF_LANYARD\",\"category_id\":\"6\",\"name\":\"Conference Lanyard\",\"description\":\"2 complimentary delegate registrations<br>View all included items on the events page\",\"base_price\":8800,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:47:20'),
(147, 'product_update', 8, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Elevator Pitch - total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\', display_order: \'0\' → \'1\'', '{\"id\":8,\"category_id\":6,\"product_code\":\"ELEVATOR_PITCH\",\"name\":\"Elevator Pitch\",\"description\":\"Showcase your institution or service with a focused, high-impact pitch using a prime networking break.\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":2,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 03:47:46\",\"updated_at\":\"2025-08-21 02:28:59\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"ELEVATOR_PITCH\",\"category_id\":\"6\",\"name\":\"Elevator Pitch\",\"description\":\"Showcase your institution or service with a focused, high-impact pitch using a prime networking break.\",\"base_price\":500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":1}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:47:28'),
(148, 'product_update', 8, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Elevator Pitch - total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\', display_order: \'1\' → \'0\'', '{\"id\":8,\"category_id\":6,\"product_code\":\"ELEVATOR_PITCH\",\"name\":\"Elevator Pitch\",\"description\":\"Showcase your institution or service with a focused, high-impact pitch using a prime networking break.\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":2,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":1,\"metadata\":null,\"created_at\":\"2025-08-19 03:47:46\",\"updated_at\":\"2025-08-21 09:47:28\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"ELEVATOR_PITCH\",\"category_id\":\"6\",\"name\":\"Elevator Pitch\",\"description\":\"Showcase your institution or service with a focused, high-impact pitch using a prime networking break.\",\"base_price\":500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":0}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:48:42'),
(149, 'product_update', 8, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Elevator Pitch - total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\', display_order: \'0\' → \'1\'', '{\"id\":8,\"category_id\":6,\"product_code\":\"ELEVATOR_PITCH\",\"name\":\"Elevator Pitch\",\"description\":\"Showcase your institution or service with a focused, high-impact pitch using a prime networking break.\",\"base_price\":\"500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":2,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 03:47:46\",\"updated_at\":\"2025-08-21 09:48:42\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"ELEVATOR_PITCH\",\"category_id\":\"6\",\"name\":\"Elevator Pitch\",\"description\":\"Showcase your institution or service with a focused, high-impact pitch using a prime networking break.\",\"base_price\":500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":1}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:49:23'),
(150, 'product_update', 17, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Visibility Plus Package - total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\', display_order: \'0\' → \'2\'', '{\"id\":17,\"category_id\":6,\"product_code\":\"VI_PL_PA\",\"name\":\"Visibility Plus Package\",\"description\":\"Maximize brand visibility across events globally<br>View all included items on the events page\",\"base_price\":\"2500.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":0,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-21 08:52:59\",\"updated_at\":\"2025-08-21 09:17:14\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"VI_PL_PA\",\"category_id\":\"6\",\"name\":\"Visibility Plus Package\",\"description\":\"Maximize brand visibility across events globally<br>View all included items on the events page\",\"base_price\":2500,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":2}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:49:34');
INSERT INTO `product_activity_log` (`id`, `activity_type`, `product_id`, `category_id`, `pricing_id`, `discount_id`, `registration_id`, `user_id`, `user_name`, `user_role`, `action_description`, `old_values`, `new_values`, `ip_address`, `user_agent`, `session_id`, `affected_count`, `severity`, `tags`, `created_at`) VALUES
(151, 'product_update', 15, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Conference Lanyard - total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\', display_order: \'0\' → \'3\'', '{\"id\":15,\"category_id\":6,\"product_code\":\"CONF_LANYARD\",\"name\":\"Conference Lanyard\",\"description\":\"2 complimentary delegate registrations<br>View all included items on the events page\",\"base_price\":\"8800.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":2,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 06:26:14\",\"updated_at\":\"2025-08-21 09:47:20\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"CONF_LANYARD\",\"category_id\":\"6\",\"name\":\"Conference Lanyard\",\"description\":\"2 complimentary delegate registrations<br>View all included items on the events page\",\"base_price\":8800,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":3}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:49:46'),
(152, 'product_update', 16, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Conference Bag Sponsorship - total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\', display_order: \'0\' → \'4\'', '{\"id\":16,\"category_id\":6,\"product_code\":\"CONF_BAG\",\"name\":\"Conference Bag Sponsorship\",\"description\":\"3 complimentary delegate registrations <br>View all included items on the events page\",\"base_price\":\"11000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":2,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":0,\"metadata\":null,\"created_at\":\"2025-08-19 06:41:50\",\"updated_at\":\"2025-08-21 09:17:42\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"CONF_BAG\",\"category_id\":\"6\",\"name\":\"Conference Bag Sponsorship\",\"description\":\"3 complimentary delegate registrations <br>View all included items on the events page\",\"base_price\":11000,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":4}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:49:57'),
(153, 'product_update', 16, NULL, NULL, NULL, NULL, 3, 'roshel', 'super_admin', 'Updated product: Conference Bag Sponsorship - base_price: \'11000.00\' → \'9900\', total_stock: \'\' → \'\', sale_start_date: \'\' → \'\', sale_end_date: \'\' → \'\'', '{\"id\":16,\"category_id\":6,\"product_code\":\"CONF_BAG\",\"name\":\"Conference Bag Sponsorship\",\"description\":\"3 complimentary delegate registrations <br>View all included items on the events page\",\"base_price\":\"11000.00\",\"currency\":\"USD\",\"total_stock\":null,\"reserved_stock\":0,\"sold_stock\":2,\"available_stock\":999999,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"requires_approval\":0,\"max_per_registration\":5,\"display_order\":4,\"metadata\":null,\"created_at\":\"2025-08-19 06:41:50\",\"updated_at\":\"2025-08-21 09:49:57\",\"category_name\":\"Other Sponsorship\"}', '{\"product_code\":\"CONF_BAG\",\"category_id\":\"6\",\"name\":\"Conference Bag Sponsorship\",\"description\":\"3 complimentary delegate registrations <br>View all included items on the events page\",\"base_price\":9900,\"total_stock\":null,\"max_per_registration\":5,\"sale_start_date\":null,\"sale_end_date\":null,\"is_active\":1,\"display_order\":4}', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '9483b5d9409f4fcd2bb51fc6027b12c1', 1, 'medium', '[\"product\",\"update\",\"catalog\"]', '2025-08-21 09:56:49'),
(156, 'product_status_change', 31, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Event Organizer', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'nt3t4vb991gkjlotg6kal6l5mg', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-22 14:17:17'),
(157, 'product_status_change', 31, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product activated: Event Organizer', '{\"is_active\":0}', '{\"is_active\":1}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'nt3t4vb991gkjlotg6kal6l5mg', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-22 14:17:21'),
(158, 'product_status_change', 31, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Event Organizer', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'nt3t4vb991gkjlotg6kal6l5mg', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-22 14:17:55'),
(159, 'product_status_change', 28, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Student Delegate', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'nt3t4vb991gkjlotg6kal6l5mg', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-22 14:17:57'),
(160, 'product_status_change', 29, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Speaker', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'nt3t4vb991gkjlotg6kal6l5mg', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-22 14:17:59'),
(161, 'product_status_change', 30, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: VIP Delegate', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'nt3t4vb991gkjlotg6kal6l5mg', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-22 14:18:01'),
(162, 'product_status_change', 27, NULL, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Product deactivated: Standard Delegate', '{\"is_active\":1}', '{\"is_active\":0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'nt3t4vb991gkjlotg6kal6l5mg', 1, 'medium', '[\"product\",\"status\",\"catalog\"]', '2025-08-22 14:18:04');

CREATE TABLE `product_attachments` (
  `id` int(11) NOT NULL,
  `parent_product_id` int(11) NOT NULL COMMENT 'The main product (e.g., sponsor package)',
  `attached_product_id` int(11) NOT NULL COMMENT 'The included product (e.g., delegate pass)',
  `quantity` int(11) NOT NULL DEFAULT 1 COMMENT 'How many of the attached product are included',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'Whether this attachment is currently active',
  `display_order` int(11) DEFAULT 0 COMMENT 'Order for displaying attached products',
  `notes` text DEFAULT NULL COMMENT 'Optional notes about this attachment',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `product_attachments` (`id`, `parent_product_id`, `attached_product_id`, `quantity`, `is_active`, `display_order`, `notes`, `created_at`, `updated_at`) VALUES
(2, 7, 6, 8, 1, 0, 'Included delegate passes for Platinum sponsorship', '2025-08-19 13:15:39', '2025-08-19 13:15:39'),
(3, 11, 6, 6, 1, 0, '', '2025-08-19 13:16:01', '2025-08-19 13:16:01'),
(4, 12, 6, 4, 1, 0, '', '2025-08-19 13:16:23', '2025-08-19 13:16:23'),
(5, 13, 6, 2, 1, 0, '', '2025-08-19 13:16:38', '2025-08-19 13:16:38');

CREATE TABLE `product_categories` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `display_order` int(11) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `product_categories` (`id`, `name`, `description`, `display_order`, `is_active`, `created_at`, `updated_at`) VALUES
(3, 'Delegate Pass', '', 0, 1, '2025-08-17 02:14:36', '2025-08-17 02:14:36'),
(4, 'Presentations', '', 1, 1, '2025-08-17 02:59:31', '2025-08-17 02:59:31'),
(5, 'Sponsorship', '', 3, 1, '2025-08-18 11:04:05', '2025-08-19 05:56:14'),
(6, 'Other Sponsorship', '', 4, 1, '2025-08-18 11:04:18', '2025-08-19 05:56:06');

CREATE TABLE `product_discounts` (
  `id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `discount_name` varchar(100) NOT NULL,
  `discount_type` enum('percentage','amount') NOT NULL,
  `discount_value` decimal(10,2) NOT NULL,
  `valid_from` datetime DEFAULT NULL,
  `valid_until` datetime DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `min_quantity` int(11) DEFAULT 1,
  `max_quantity` int(11) DEFAULT NULL,
  `usage_limit` int(11) DEFAULT NULL,
  `usage_count` int(11) DEFAULT 0,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `product_pricing` (
  `id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `pricing_tier` varchar(50) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `valid_from` datetime DEFAULT NULL,
  `valid_until` datetime DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `product_pricing` (`id`, `product_id`, `pricing_tier`, `price`, `valid_from`, `valid_until`, `is_active`, `created_at`) VALUES
(33, 6, 'Early Bird', 550.00, '2025-08-01 21:06:00', '2025-09-07 21:06:00', 1, '2025-08-18 13:51:48'),
(34, 6, 'Standard', 580.00, '2025-09-07 21:06:00', '2025-11-29 21:06:00', 1, '2025-08-18 13:51:48'),
(39, 26, 'Super Early Bird', 400.00, '2025-06-01 00:00:00', '2025-07-31 23:59:59', 1, '2025-08-22 12:42:56'),
(40, 26, 'Early Bird Extended', 475.00, '2025-08-01 00:00:00', '2025-09-30 23:59:59', 1, '2025-08-22 12:42:56'),
(41, 27, 'Late Registration', 600.00, '2025-10-01 00:00:00', '2025-11-25 23:59:59', 1, '2025-08-22 12:42:56'),
(42, 30, 'VIP Early Bird', 750.00, '2025-06-01 00:00:00', '2025-08-31 23:59:59', 1, '2025-08-22 12:42:56');

CREATE TABLE `product_stock_movements` (
  `id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `registration_id` int(11) DEFAULT NULL,
  `movement_type` enum('reserve','release','sell','refund','adjust') NOT NULL,
  `quantity_change` int(11) NOT NULL,
  `previous_available` int(11) NOT NULL,
  `new_available` int(11) NOT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `admin_user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
CREATE TABLE `recent_product_activities` (
`id` int(11)
,`activity_type` enum('product_create','product_update','product_delete','product_status_change','category_create','category_update','category_delete','category_assign','pricing_create','pricing_update','pricing_delete','discount_create','discount_update','discount_delete','discount_status_change','stock_adjustment','stock_reservation','stock_confirmation','stock_release','purchase_create','purchase_update','purchase_cancel','purchase_refund','bulk_operation','import_data','export_data','system_maintenance')
,`product_id` int(11)
,`category_id` int(11)
,`pricing_id` int(11)
,`registration_id` int(11)
,`user_id` int(11)
,`user_name` varchar(255)
,`user_role` varchar(100)
,`action_description` text
,`old_values` longtext
,`new_values` longtext
,`ip_address` varchar(45)
,`user_agent` text
,`session_id` varchar(255)
,`affected_count` int(11)
,`severity` enum('low','medium','high','critical')
,`tags` longtext
,`created_at` timestamp
,`product_name` varchar(200)
,`product_code` varchar(50)
,`category_name` varchar(100)
,`time_category` varchar(9)
);
CREATE TABLE `recent_registration_activities` (
`id` int(11)
,`activity_type` varchar(50)
,`registration_id` int(11)
,`delegate_id` int(11)
,`payment_transaction_id` int(11)
,`email_log_id` int(11)
,`user_id` int(11)
,`user_name` varchar(100)
,`user_role` varchar(50)
,`action_description` text
,`old_values` longtext
,`new_values` longtext
,`ip_address` varchar(45)
,`user_agent` text
,`session_id` varchar(255)
,`affected_count` int(11)
,`severity` enum('low','medium','high','critical')
,`tags` longtext
,`created_at` timestamp
,`registration_number` varchar(50)
,`contact_full_name` varchar(255)
,`contact_email` varchar(255)
,`payment_status` enum('pending','paid','failed','expired','cancelled')
,`total_amount` decimal(10,2)
,`activity_icon` varchar(2)
,`severity_color` varchar(7)
);

CREATE TABLE `registrations` (
  `id` int(11) NOT NULL,
  `registration_number` varchar(50) DEFAULT NULL,
  `delegate_type` enum('earlyBird','standard') NOT NULL,
  `delegate_count` int(11) NOT NULL,
  `has_standard_table` tinyint(1) DEFAULT 0,
  `has_double_table` tinyint(1) DEFAULT 0,
  `contact_salutation` varchar(20) DEFAULT NULL,
  `contact_full_name` varchar(255) NOT NULL,
  `contact_badge_name` varchar(100) NOT NULL,
  `contact_designation` varchar(255) NOT NULL,
  `contact_department` varchar(255) NOT NULL,
  `contact_email` varchar(255) NOT NULL,
  `contact_mobile` varchar(50) NOT NULL,
  `university_name` varchar(255) NOT NULL,
  `country` varchar(100) NOT NULL,
  `payment_method` enum('gateway','tt') NOT NULL,
  `payment_status` enum('pending','paid','failed','expired','cancelled') DEFAULT 'pending',
  `payment_reference` varchar(100) DEFAULT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `payment_deadline` date DEFAULT NULL,
  `admin_notes` text DEFAULT NULL COMMENT 'Rich text admin notes for this registration',
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `registrations` (`id`, `registration_number`, `delegate_type`, `delegate_count`, `has_standard_table`, `has_double_table`, `contact_salutation`, `contact_full_name`, `contact_badge_name`, `contact_designation`, `contact_department`, `contact_email`, `contact_mobile`, `university_name`, `country`, `payment_method`, `payment_status`, `payment_reference`, `total_amount`, `payment_deadline`, `admin_notes`, `ip_address`, `user_agent`, `created_at`, `updated_at`) VALUES
(1, 'XC25-MXFAY9', 'standard', 2, 0, 0, 'Mr', 'Ruwan Chinthaka', '', 'CTO', 'Management', 'mcruwan@gmail.com', '+60169835703', 'AppliedHE', 'Malaysia', 'gateway', 'paid', NULL, 88900.00, '2025-08-20', 'Internal', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 12:54:46', '2025-08-21 02:29:14'),
(3, 'XC25-292253', 'standard', 4, 0, 0, 'Mr', 'Suba Raj', '', 'Professor test', 'HRM', 'suba@dyits.com.my', '+601116721369', 'DYITS', 'Argentina', 'tt', 'paid', NULL, 3050.00, '2025-08-28', 'dfsdfsdfsdgsfdgsfdg', '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 02:44:30', '2025-08-21 02:58:15'),
(4, 'XC25-FEUGPF', 'standard', 1, 0, 0, 'Mr', 'Suba Raj', '', 'Manager', 'Department of Information Technology', 'suba@dyits.com.my', '+601116721369', 'DYITS', 'Austria', 'gateway', 'failed', NULL, 10100.00, '2025-08-21', NULL, '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 02:47:27', '2025-08-21 02:52:17'),
(5, 'XC25-TPBO64', 'standard', 1, 0, 0, 'Mr', 'Suba Raj', '', 'Manager', 'Department of Information Technology', 'suba@dyits.com.my', '+601116721369', 'DYITS', 'Belgium', 'tt', 'paid', NULL, 43600.00, '2025-08-28', NULL, '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 03:00:55', '2025-08-21 03:01:43'),
(6, 'XC25-FLA262', 'standard', 1, 0, 0, 'Mrs', 'sdf', '', 'dsfsdf', 'sdfsdf', 'ds@dd.om', '+65656565656', 'sdf', 'Bahamas', 'gateway', 'failed', NULL, 11600.00, '2025-08-22', NULL, '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 01:15:25', '2025-08-22 04:25:51'),
(7, 'ADMIN_20250822_68a888706e9aa', 'standard', 1, 0, 0, NULL, 'Ruwan', 'mcruwan', 'abc', 'Admin Created', 'admin@xchange.com', 'N/A', 'adasd', 'Admin Created', 'tt', 'paid', NULL, 0.00, NULL, NULL, NULL, NULL, '2025-08-22 15:10:40', '2025-08-22 15:10:40'),
(8, 'ADMIN_20250822_68a88b8b3435c', 'standard', 3, 0, 0, 'Ms', 'John Jo Fizo', 'John Jo Fizo', 'kjhkj', 'kjghkjh', 'demo@demoemail.com', '6060123456789', 'Demo Company Sdn Bhd', 'Malaysia', 'tt', 'paid', NULL, 1350.00, '0000-00-00', '', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 15:23:55', '2025-08-22 15:23:55');

CREATE TABLE `registration_activity_log` (
  `id` int(11) NOT NULL,
  `activity_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `registration_id` int(11) DEFAULT NULL,
  `delegate_id` int(11) DEFAULT NULL,
  `payment_transaction_id` int(11) DEFAULT NULL,
  `email_log_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `user_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_role` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_values` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `new_values` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `session_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `affected_count` int(11) DEFAULT 1,
  `severity` enum('low','medium','high','critical') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'medium',
  `tags` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `registration_activity_log` (`id`, `activity_type`, `registration_id`, `delegate_id`, `payment_transaction_id`, `email_log_id`, `user_id`, `user_name`, `user_role`, `action_description`, `old_values`, `new_values`, `ip_address`, `user_agent`, `session_id`, `affected_count`, `severity`, `tags`, `created_at`) VALUES
(1, 'admin_notes_update', 1, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Added admin notes for registration XC25-MXFAY9', '{\"admin_notes\":\"\"}', '{\"admin_notes\":\"Internal\"}', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '12399c6b389015378ebcc1a85359ca23', 1, 'low', '[\"admin_notes\",\"update\",\"documentation\"]', '2025-08-20 12:55:13'),
(7, 'payment_status_update', 1, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Payment status changed from \'pending\' to \'paid\' for registration XC25-MXFAY9 ($88900.00)', '{\"payment_status\":\"pending\"}', '{\"payment_status\":\"paid\",\"amount\":\"88900.00\"}', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '00e036100b53a5a4ed990723d5ef7c1b', 1, 'high', '[\"payment\",\"status\",\"admin_update\"]', '2025-08-21 02:29:14'),
(8, 'email_sent', 1, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Sent Registration Confirmation email to unknown for registration XC25-MXFAY9', NULL, '{\"email_type\":\"registration_confirmation\",\"recipient\":\"unknown\",\"subject\":\"Registration Confirmation\"}', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '00e036100b53a5a4ed990723d5ef7c1b', 1, 'low', '[\"email\",\"sent\",\"registration_confirmation\"]', '2025-08-21 02:29:15'),
(9, 'payment_status_update', 3, NULL, NULL, NULL, 2, 'suba', 'super_admin', 'Payment status changed from \'pending\' to \'paid\' for registration XC25-292253 ($3050.00)', '{\"payment_status\":\"pending\"}', '{\"payment_status\":\"paid\",\"amount\":\"3050.00\"}', '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'f713f59ae61b508714e08edceb36e85a', 1, 'high', '[\"payment\",\"status\",\"admin_update\"]', '2025-08-21 02:48:33'),
(10, 'email_sent', 3, NULL, NULL, NULL, 2, 'suba', 'super_admin', 'Sent Registration Confirmation email to unknown for registration XC25-292253', NULL, '{\"email_type\":\"registration_confirmation\",\"recipient\":\"unknown\",\"subject\":\"Registration Confirmation\"}', '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'f713f59ae61b508714e08edceb36e85a', 1, 'low', '[\"email\",\"sent\",\"registration_confirmation\"]', '2025-08-21 02:48:33'),
(11, 'data_export', 3, NULL, NULL, NULL, 2, 'suba', 'super_admin', 'Exported registration_details data for registration XC25-292253 (print)', NULL, '{\"export_type\":\"registration_details\",\"format\":\"print\"}', '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'f713f59ae61b508714e08edceb36e85a', 1, 'low', '[\"export\",\"registration_details\",\"print\"]', '2025-08-21 02:48:53'),
(12, 'payment_status_update', 4, NULL, NULL, NULL, 2, 'suba', 'super_admin', 'Payment status changed from \'pending\' to \'failed\' for registration XC25-FEUGPF ($10100.00)', '{\"payment_status\":\"pending\"}', '{\"payment_status\":\"failed\",\"amount\":\"10100.00\"}', '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'f713f59ae61b508714e08edceb36e85a', 1, 'medium', '[\"payment\",\"status\",\"admin_update\"]', '2025-08-21 02:52:17'),
(13, 'contact_update', 3, NULL, NULL, NULL, 2, 'suba', 'super_admin', 'Updated contact information for registration XC25-292253: contact_designation: \'Professor\' → \'Professor test\'', '{\"contact_full_name\":\"Suba Raj\",\"contact_designation\":\"Professor\",\"contact_department\":\"HRM\",\"contact_email\":\"suba@dyits.com.my\",\"contact_mobile\":\"+601116721369\",\"university_name\":\"DYITS\",\"country\":\"Argentina\",\"registration_number\":\"XC25-292253\"}', '{\"contact_full_name\":\"Suba Raj\",\"contact_designation\":\"Professor test\",\"contact_department\":\"HRM\",\"contact_email\":\"suba@dyits.com.my\",\"contact_mobile\":\"+601116721369\",\"university_name\":\"DYITS\",\"country\":\"Argentina\"}', '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'f713f59ae61b508714e08edceb36e85a', 1, 'medium', '[\"contact\",\"update\",\"personal_data\"]', '2025-08-21 02:56:27'),
(14, 'admin_notes_update', 3, NULL, NULL, NULL, 2, 'suba', 'super_admin', 'Added admin notes for registration XC25-292253', '{\"admin_notes\":\"\"}', '{\"admin_notes\":\"dfsdfsdfsdgsfdgsfdg\"}', '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'f713f59ae61b508714e08edceb36e85a', 1, 'low', '[\"admin_notes\",\"update\",\"documentation\"]', '2025-08-21 02:58:15'),
(15, 'payment_status_update', 5, NULL, NULL, NULL, 2, 'suba', 'super_admin', 'Payment status changed from \'pending\' to \'paid\' for registration XC25-TPBO64 ($43600.00)', '{\"payment_status\":\"pending\"}', '{\"payment_status\":\"paid\",\"amount\":\"43600.00\"}', '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'f713f59ae61b508714e08edceb36e85a', 1, 'high', '[\"payment\",\"status\",\"admin_update\"]', '2025-08-21 03:01:43'),
(16, 'email_sent', 5, NULL, NULL, NULL, 2, 'suba', 'super_admin', 'Sent Registration Confirmation email to unknown for registration XC25-TPBO64', NULL, '{\"email_type\":\"registration_confirmation\",\"recipient\":\"unknown\",\"subject\":\"Registration Confirmation\"}', '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', 'f713f59ae61b508714e08edceb36e85a', 1, 'low', '[\"email\",\"sent\",\"registration_confirmation\"]', '2025-08-21 03:01:44'),
(17, 'payment_status_update', 6, NULL, NULL, NULL, 1, 'admin', 'super_admin', 'Payment status changed from \'pending\' to \'failed\' for registration XC25-FLA262 ($11600.00)', '{\"payment_status\":\"pending\"}', '{\"payment_status\":\"failed\",\"amount\":\"11600.00\"}', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '4911006bc6e80f1c0dc369b1bbde12e7', 1, 'medium', '[\"payment\",\"status\",\"admin_update\"]', '2025-08-22 04:25:51'),
(18, 'admin_registration_create', 8, NULL, NULL, NULL, 1, 'System Administrator', 'super_admin', 'Admin created registration ADMIN_20250822_68a88b8b3435c with total amount $1350', NULL, NULL, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', NULL, 1, 'medium', '[\"admin_created\",\"registration\",\"manual\"]', '2025-08-22 15:23:55');
CREATE TABLE `registration_analytics` (
`total_registrations` bigint(21)
,`total_revenue` decimal(32,2)
,`paid_registrations` bigint(21)
,`pending_payments` bigint(21)
,`standard_registrations` bigint(21)
);

CREATE TABLE `registration_products` (
  `id` int(11) NOT NULL,
  `registration_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `unit_price` decimal(10,2) NOT NULL,
  `total_price` decimal(10,2) NOT NULL,
  `pricing_tier` varchar(50) DEFAULT NULL,
  `stock_status` enum('reserved','confirmed','cancelled','refunded') DEFAULT 'reserved',
  `reserved_at` timestamp NULL DEFAULT current_timestamp(),
  `confirmed_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `product_metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES
(1, 1, 27, 2, 550.00, 1100.00, 'Early Bird', 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-22 12:42:56'),
(2, 1, 3, 2, 550.00, 1100.00, NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46'),
(3, 1, 4, 2, 850.00, 1700.00, NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46'),
(4, 1, 7, 2, 10000.00, 20000.00, NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46'),
(5, 1, 11, 2, 8000.00, 16000.00, NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46'),
(6, 1, 12, 2, 5500.00, 11000.00, NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46'),
(7, 1, 13, 2, 5500.00, 11000.00, NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46'),
(8, 1, 8, 2, 500.00, 1000.00, NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46'),
(9, 1, 14, 2, 1000.00, 2000.00, NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46'),
(10, 1, 15, 2, 1000.00, 2000.00, NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46'),
(11, 1, 16, 2, 11000.00, 22000.00, NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46'),
(23, 3, 27, 4, 550.00, 2200.00, 'Early Bird', 'confirmed', '2025-08-21 02:44:30', '2025-08-21 02:44:30', NULL, NULL, '2025-08-21 02:44:30', '2025-08-22 12:42:56'),
(24, 3, 4, 1, 850.00, 850.00, NULL, 'confirmed', '2025-08-21 02:44:30', '2025-08-21 02:44:30', NULL, NULL, '2025-08-21 02:44:30', '2025-08-21 02:44:30'),
(25, 4, 27, 1, 550.00, 550.00, 'Early Bird', 'confirmed', '2025-08-21 02:47:27', '2025-08-21 02:47:27', NULL, NULL, '2025-08-21 02:47:27', '2025-08-22 12:42:56'),
(26, 4, 3, 1, 550.00, 550.00, NULL, 'confirmed', '2025-08-21 02:47:27', '2025-08-21 02:47:27', NULL, NULL, '2025-08-21 02:47:27', '2025-08-21 02:47:27'),
(27, 4, 11, 1, 8000.00, 8000.00, NULL, 'confirmed', '2025-08-21 02:47:27', '2025-08-21 02:47:27', NULL, NULL, '2025-08-21 02:47:27', '2025-08-21 02:47:27'),
(28, 4, 15, 1, 1000.00, 1000.00, NULL, 'confirmed', '2025-08-21 02:47:27', '2025-08-21 02:47:27', NULL, NULL, '2025-08-21 02:47:27', '2025-08-21 02:47:27'),
(29, 5, 27, 1, 550.00, 550.00, 'Early Bird', 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-22 12:42:56'),
(30, 5, 3, 1, 550.00, 550.00, NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55'),
(31, 5, 7, 1, 10000.00, 10000.00, NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55'),
(32, 5, 11, 1, 8000.00, 8000.00, NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55'),
(33, 5, 12, 1, 5500.00, 5500.00, NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55'),
(34, 5, 13, 1, 5500.00, 5500.00, NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55'),
(35, 5, 8, 1, 500.00, 500.00, NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55'),
(36, 5, 14, 1, 1000.00, 1000.00, NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55'),
(37, 5, 15, 1, 1000.00, 1000.00, NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55'),
(38, 5, 16, 1, 11000.00, 11000.00, NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55'),
(39, 6, 27, 1, 550.00, 550.00, 'Early Bird', 'confirmed', '2025-08-22 01:15:25', '2025-08-22 01:15:25', NULL, NULL, '2025-08-22 01:15:25', '2025-08-22 12:42:56'),
(40, 6, 3, 1, 550.00, 550.00, NULL, 'confirmed', '2025-08-22 01:15:25', '2025-08-22 01:15:25', NULL, NULL, '2025-08-22 01:15:25', '2025-08-22 01:15:25'),
(41, 6, 7, 1, 10000.00, 10000.00, NULL, 'confirmed', '2025-08-22 01:15:25', '2025-08-22 01:15:25', NULL, NULL, '2025-08-22 01:15:25', '2025-08-22 01:15:25'),
(42, 6, 8, 1, 500.00, 500.00, NULL, 'confirmed', '2025-08-22 01:15:25', '2025-08-22 01:15:25', NULL, NULL, '2025-08-22 01:15:25', '2025-08-22 01:15:25'),
(43, 8, 26, 3, 450.00, 1350.00, NULL, 'confirmed', '2025-08-22 15:23:55', '2025-08-22 15:23:55', NULL, NULL, '2025-08-22 15:23:55', '2025-08-22 15:23:55');
CREATE TABLE `registration_stats` (
`total_registrations` bigint(21)
,`total_delegates` decimal(32,0)
,`total_revenue` decimal(32,2)
,`paid_registrations` bigint(21)
,`pending_payments` bigint(21)
,`standard_registrations` bigint(21)
);

CREATE TABLE `section_descriptions` (
  `page_section` varchar(50) NOT NULL COMMENT 'Identifier for the page section (e.g., delegate_passes)',
  `description` text DEFAULT NULL COMMENT 'Custom description text for the section',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'When this record was created',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'When this record was last updated'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Stores descriptions for registration form sections';

INSERT INTO `section_descriptions` (`page_section`, `description`, `created_at`, `updated_at`) VALUES
('delegate_passes', '', '2025-08-19 04:00:10', '2025-08-19 04:00:10'),
('other_sponsorship', 'Select additional sponsorship options', '2025-08-19 04:00:10', '2025-08-19 04:00:10'),
('sponsorship', 'Select your sponsorship options', '2025-08-19 04:00:10', '2025-08-19 04:00:10'),
('table_presentations', '', '2025-08-19 04:00:10', '2025-08-19 04:00:10');
CREATE TABLE `special_assistance_summary` (
`registration_number` varchar(50)
,`contact_full_name` varchar(255)
,`contact_email` varchar(255)
,`delegate_name` varchar(255)
,`special_assistance` text
);
DROP TABLE IF EXISTS `dietary_summary`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `dietary_summary`  AS SELECT coalesce(nullif(trim(`d`.`dietary_requirements`),''),'Not Specified') AS `dietary_requirements`, count(0) AS `count` FROM (`delegates` `d` join `registrations` `r` on(`d`.`registration_id` = `r`.`id`)) WHERE `d`.`dietary_requirements` is not null GROUP BY coalesce(nullif(trim(`d`.`dietary_requirements`),''),'Not Specified') ORDER BY count(0) DESC ;
DROP TABLE IF EXISTS `recent_product_activities`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `recent_product_activities`  AS SELECT `pal`.`id` AS `id`, `pal`.`activity_type` AS `activity_type`, `pal`.`product_id` AS `product_id`, `pal`.`category_id` AS `category_id`, `pal`.`pricing_id` AS `pricing_id`, `pal`.`registration_id` AS `registration_id`, `pal`.`user_id` AS `user_id`, `pal`.`user_name` AS `user_name`, `pal`.`user_role` AS `user_role`, `pal`.`action_description` AS `action_description`, `pal`.`old_values` AS `old_values`, `pal`.`new_values` AS `new_values`, `pal`.`ip_address` AS `ip_address`, `pal`.`user_agent` AS `user_agent`, `pal`.`session_id` AS `session_id`, `pal`.`affected_count` AS `affected_count`, `pal`.`severity` AS `severity`, `pal`.`tags` AS `tags`, `pal`.`created_at` AS `created_at`, `p`.`name` AS `product_name`, `p`.`product_code` AS `product_code`, `pc`.`name` AS `category_name`, CASE WHEN `pal`.`created_at` >= current_timestamp() - interval 1 hour THEN 'just_now' WHEN `pal`.`created_at` >= current_timestamp() - interval 1 day THEN 'today' WHEN `pal`.`created_at` >= current_timestamp() - interval 7 day THEN 'this_week' ELSE 'older' END AS `time_category` FROM ((`product_activity_log` `pal` left join `products` `p` on(`pal`.`product_id` = `p`.`id`)) left join `product_categories` `pc` on(`pal`.`category_id` = `pc`.`id`)) ORDER BY `pal`.`created_at` DESC ;
DROP TABLE IF EXISTS `recent_registration_activities`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `recent_registration_activities`  AS SELECT `ral`.`id` AS `id`, `ral`.`activity_type` AS `activity_type`, `ral`.`registration_id` AS `registration_id`, `ral`.`delegate_id` AS `delegate_id`, `ral`.`payment_transaction_id` AS `payment_transaction_id`, `ral`.`email_log_id` AS `email_log_id`, `ral`.`user_id` AS `user_id`, `ral`.`user_name` AS `user_name`, `ral`.`user_role` AS `user_role`, `ral`.`action_description` AS `action_description`, `ral`.`old_values` AS `old_values`, `ral`.`new_values` AS `new_values`, `ral`.`ip_address` AS `ip_address`, `ral`.`user_agent` AS `user_agent`, `ral`.`session_id` AS `session_id`, `ral`.`affected_count` AS `affected_count`, `ral`.`severity` AS `severity`, `ral`.`tags` AS `tags`, `ral`.`created_at` AS `created_at`, `r`.`registration_number` AS `registration_number`, `r`.`contact_full_name` AS `contact_full_name`, `r`.`contact_email` AS `contact_email`, `r`.`payment_status` AS `payment_status`, `r`.`total_amount` AS `total_amount`, CASE WHEN `ral`.`activity_type` like '%payment%' THEN '💳' WHEN `ral`.`activity_type` like '%contact%' THEN '👤' WHEN `ral`.`activity_type` like '%email%' THEN '📧' WHEN `ral`.`activity_type` like '%admin_notes%' THEN '📝' WHEN `ral`.`activity_type` like '%stock%' THEN '📦' WHEN `ral`.`activity_type` like '%view%' THEN '👁️' WHEN `ral`.`activity_type` like '%export%' THEN '📊' ELSE '🔄' END AS `activity_icon`, CASE `ral`.`severity` WHEN 'low' THEN '#10b981' WHEN 'medium' THEN '#f59e0b' WHEN 'high' THEN '#ef4444' WHEN 'critical' THEN '#dc2626' END AS `severity_color` FROM (`registration_activity_log` `ral` left join `registrations` `r` on(`ral`.`registration_id` = `r`.`id`)) ORDER BY `ral`.`created_at` DESC ;
DROP TABLE IF EXISTS `registration_analytics`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `registration_analytics`  AS SELECT count(0) AS `total_registrations`, sum(`registrations`.`total_amount`) AS `total_revenue`, count(case when `registrations`.`payment_status` = 'paid' then 1 end) AS `paid_registrations`, count(case when `registrations`.`payment_status` = 'pending' then 1 end) AS `pending_payments`, count(case when `registrations`.`delegate_type` = 'standard' then 1 end) AS `standard_registrations` FROM `registrations` ;
DROP TABLE IF EXISTS `registration_stats`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `registration_stats`  AS SELECT count(0) AS `total_registrations`, sum(`registrations`.`delegate_count`) AS `total_delegates`, sum(`registrations`.`total_amount`) AS `total_revenue`, count(case when `registrations`.`payment_status` = 'paid' then 1 end) AS `paid_registrations`, count(case when `registrations`.`payment_status` = 'pending' then 1 end) AS `pending_payments`, count(case when `registrations`.`delegate_type` = 'standard' then 1 end) AS `standard_registrations` FROM `registrations` ;
DROP TABLE IF EXISTS `special_assistance_summary`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `special_assistance_summary`  AS SELECT `r`.`registration_number` AS `registration_number`, `r`.`contact_full_name` AS `contact_full_name`, `r`.`contact_email` AS `contact_email`, `d`.`full_name` AS `delegate_name`, `d`.`special_assistance` AS `special_assistance` FROM (`delegates` `d` join `registrations` `r` on(`d`.`registration_id` = `r`.`id`)) WHERE `d`.`special_assistance` is not null AND trim(`d`.`special_assistance`) <> '' ORDER BY `r`.`created_at` ASC ;


ALTER TABLE `admin_activity_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_admin_user_id` (`admin_user_id`),
  ADD KEY `idx_action` (`action`),
  ADD KEY `idx_created_at` (`created_at`);

ALTER TABLE `admin_settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setting_key` (`setting_key`),
  ADD KEY `idx_setting_key` (`setting_key`);

ALTER TABLE `admin_users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD KEY `idx_username` (`username`),
  ADD KEY `idx_role` (`role`),
  ADD KEY `idx_is_active` (`is_active`),
  ADD KEY `created_by` (`created_by`);

ALTER TABLE `delegates`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_registration_id` (`registration_id`),
  ADD KEY `idx_delegate_number` (`delegate_number`);

ALTER TABLE `email_notifications`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_registration_id` (`registration_id`),
  ADD KEY `idx_email_type` (`email_type`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_sent_at` (`sent_at`);

ALTER TABLE `frontend_display_config`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_section_category` (`page_section`,`category_id`),
  ADD KEY `category_id` (`category_id`),
  ADD KEY `idx_page_section` (`page_section`),
  ADD KEY `idx_active` (`is_active`);

ALTER TABLE `payment_transactions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_registration_id` (`registration_id`),
  ADD KEY `idx_transaction_status` (`transaction_status`),
  ADD KEY `idx_transaction_reference` (`transaction_reference`),
  ADD KEY `idx_registration_number` (`registration_number`);

ALTER TABLE `products`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `product_code` (`product_code`),
  ADD KEY `idx_product_code` (`product_code`),
  ADD KEY `idx_category` (`category_id`),
  ADD KEY `idx_active` (`is_active`),
  ADD KEY `idx_stock` (`available_stock`);

ALTER TABLE `product_activity_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_activity_type` (`activity_type`),
  ADD KEY `idx_product_id` (`product_id`),
  ADD KEY `idx_category_id` (`category_id`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_created_at` (`created_at`),
  ADD KEY `idx_severity` (`severity`),
  ADD KEY `idx_activity_time_category` (`created_at`),
  ADD KEY `idx_discount_id` (`discount_id`);

ALTER TABLE `product_attachments`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_attachment` (`parent_product_id`,`attached_product_id`),
  ADD KEY `idx_parent_product` (`parent_product_id`),
  ADD KEY `idx_attached_product` (`attached_product_id`),
  ADD KEY `idx_product_attachments_parent_active` (`parent_product_id`,`is_active`),
  ADD KEY `idx_product_attachments_attached_active` (`attached_product_id`,`is_active`),
  ADD KEY `idx_product_attachments_display_order` (`parent_product_id`,`display_order`);

ALTER TABLE `product_categories`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `product_discounts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_product_id` (`product_id`),
  ADD KEY `idx_active_dates` (`is_active`,`valid_from`,`valid_until`),
  ADD KEY `idx_discount_type` (`discount_type`);

ALTER TABLE `product_pricing`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_product_tier` (`product_id`,`pricing_tier`),
  ADD KEY `idx_pricing_tier` (`pricing_tier`),
  ADD KEY `idx_valid_dates` (`valid_from`,`valid_until`);

ALTER TABLE `product_stock_movements`
  ADD PRIMARY KEY (`id`),
  ADD KEY `registration_id` (`registration_id`),
  ADD KEY `idx_product_movements` (`product_id`,`created_at`),
  ADD KEY `idx_movement_type` (`movement_type`);

ALTER TABLE `registrations`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `registration_number` (`registration_number`),
  ADD KEY `idx_registration_number` (`registration_number`),
  ADD KEY `idx_contact_email` (`contact_email`),
  ADD KEY `idx_payment_status` (`payment_status`),
  ADD KEY `idx_created_at` (`created_at`),
  ADD KEY `idx_registrations_payment_status` (`payment_status`),
  ADD KEY `idx_registrations_delegate_type` (`delegate_type`);

ALTER TABLE `registration_activity_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_activity_type` (`activity_type`),
  ADD KEY `idx_registration_id` (`registration_id`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_created_at` (`created_at`),
  ADD KEY `idx_severity` (`severity`),
  ADD KEY `delegate_id` (`delegate_id`),
  ADD KEY `idx_registration_activity_composite` (`registration_id`,`activity_type`,`created_at`),
  ADD KEY `idx_registration_activity_user_date` (`user_id`,`created_at`);

ALTER TABLE `registration_products`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_registration` (`registration_id`),
  ADD KEY `idx_product` (`product_id`),
  ADD KEY `idx_stock_status` (`stock_status`),
  ADD KEY `idx_expires` (`expires_at`);

ALTER TABLE `section_descriptions`
  ADD PRIMARY KEY (`page_section`);


ALTER TABLE `admin_activity_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=236;

ALTER TABLE `admin_settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=107;

ALTER TABLE `admin_users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

ALTER TABLE `delegates`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

ALTER TABLE `email_notifications`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

ALTER TABLE `frontend_display_config`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=37;

ALTER TABLE `payment_transactions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

ALTER TABLE `products`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=32;

ALTER TABLE `product_activity_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=163;

ALTER TABLE `product_attachments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

ALTER TABLE `product_categories`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

ALTER TABLE `product_discounts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `product_pricing`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=43;

ALTER TABLE `product_stock_movements`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `registrations`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

ALTER TABLE `registration_activity_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19;

ALTER TABLE `registration_products`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=44;


ALTER TABLE `admin_activity_log`
  ADD CONSTRAINT `admin_activity_log_ibfk_1` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_users` (`id`) ON DELETE CASCADE;

ALTER TABLE `admin_users`
  ADD CONSTRAINT `admin_users_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL;

ALTER TABLE `delegates`
  ADD CONSTRAINT `delegates_ibfk_1` FOREIGN KEY (`registration_id`) REFERENCES `registrations` (`id`) ON DELETE CASCADE;

ALTER TABLE `email_notifications`
  ADD CONSTRAINT `email_notifications_ibfk_1` FOREIGN KEY (`registration_id`) REFERENCES `registrations` (`id`) ON DELETE CASCADE;

ALTER TABLE `frontend_display_config`
  ADD CONSTRAINT `frontend_display_config_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `product_categories` (`id`) ON DELETE SET NULL;

ALTER TABLE `payment_transactions`
  ADD CONSTRAINT `payment_transactions_ibfk_1` FOREIGN KEY (`registration_id`) REFERENCES `registrations` (`id`) ON DELETE SET NULL;

ALTER TABLE `products`
  ADD CONSTRAINT `products_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `product_categories` (`id`);

ALTER TABLE `product_activity_log`
  ADD CONSTRAINT `product_activity_log_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `admin_users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `product_activity_log_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `product_activity_log_ibfk_3` FOREIGN KEY (`category_id`) REFERENCES `product_categories` (`id`) ON DELETE SET NULL;

ALTER TABLE `product_attachments`
  ADD CONSTRAINT `fk_attached_product` FOREIGN KEY (`attached_product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_parent_product` FOREIGN KEY (`parent_product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE;

ALTER TABLE `product_discounts`
  ADD CONSTRAINT `product_discounts_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE;

ALTER TABLE `product_pricing`
  ADD CONSTRAINT `product_pricing_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE;

ALTER TABLE `product_stock_movements`
  ADD CONSTRAINT `product_stock_movements_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  ADD CONSTRAINT `product_stock_movements_ibfk_2` FOREIGN KEY (`registration_id`) REFERENCES `registrations` (`id`);

ALTER TABLE `registration_activity_log`
  ADD CONSTRAINT `registration_activity_log_ibfk_1` FOREIGN KEY (`registration_id`) REFERENCES `registrations` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `registration_activity_log_ibfk_2` FOREIGN KEY (`delegate_id`) REFERENCES `delegates` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `registration_activity_log_ibfk_3` FOREIGN KEY (`user_id`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL;

ALTER TABLE `registration_products`
  ADD CONSTRAINT `registration_products_ibfk_1` FOREIGN KEY (`registration_id`) REFERENCES `registrations` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `registration_products_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`);
COMMIT;
