-- Create section_descriptions table
-- This table centralizes all section descriptions for the registration form

CREATE TABLE IF NOT EXISTS section_descriptions (
    page_section VARCHAR(50) NOT NULL PRIMARY KEY COMMENT 'Identifier for the page section (e.g., delegate_passes)',
    description TEXT NULL COMMENT 'Custom description text for the section',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'When this record was created',
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'When this record was last updated'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Stores descriptions for registration form sections';

-- Migrate existing descriptions from frontend_display_config
INSERT INTO section_descriptions (page_section, description)
SELECT DISTINCT page_section, delegate_description 
FROM frontend_display_config 
WHERE page_section = 'delegate_passes' AND delegate_description IS NOT NULL
ON DUPLICATE KEY UPDATE description = VALUES(description);

INSERT INTO section_descriptions (page_section, description)
SELECT DISTINCT page_section, table_description 
FROM frontend_display_config 
WHERE page_section = 'table_presentations' AND table_description IS NOT NULL
ON DUPLICATE KEY UPDATE description = VALUES(description);

-- Insert default descriptions if none exist
INSERT IGNORE INTO section_descriptions (page_section, description) VALUES
('delegate_passes', 'Choose the number of delegate passes'),
('table_presentations', 'Showcase your programs and partnerships'),
('sponsorship', 'Select your sponsorship options'),
('other_sponsorship', 'Select additional sponsorship options');
