-- Add sponsorship and other sponsorship sections to frontend display config
-- This script adds the new page_section values for Sponsorship and Other Sponsorship product lists

-- Insert default configuration for sponsorship sections
-- This will initially show all categories, but can be customized via admin interface
INSERT INTO frontend_display_config (page_section, category_id, display_order, is_active) 
VALUES 
('sponsorship', NULL, 2, 1),
('other_sponsorship', NULL, 3, 1)
ON DUPLICATE KEY UPDATE updated_at = CURRENT_TIMESTAMP;

-- Add some sample data if categories exist
INSERT IGNORE INTO frontend_display_config (page_section, category_id, display_order, is_active)
SELECT 'sponsorship', id, display_order, 1
FROM product_categories 
WHERE name LIKE '%sponsor%' AND name NOT LIKE '%other%'
ORDER BY display_order;

INSERT IGNORE INTO frontend_display_config (page_section, category_id, display_order, is_active)
SELECT 'other_sponsorship', id, display_order, 1
FROM product_categories 
WHERE name LIKE '%other%' AND name LIKE '%sponsor%'
ORDER BY display_order;

-- Add section descriptions if not already present
INSERT INTO section_descriptions (page_section, description)
VALUES 
('sponsorship', 'Select your sponsorship options'),
('other_sponsorship', 'Select additional sponsorship options')
ON DUPLICATE KEY UPDATE updated_at = CURRENT_TIMESTAMP;
