-- Add Print Tracking to Badge Generation Log
-- Adds columns to track when badges are physically printed

ALTER TABLE badge_generation_log
ADD COLUMN is_printed BOOLEAN DEFAULT FALSE COMMENT 'Whether badge has been physically printed',
ADD COLUMN printed_at TIMESTAMP NULL COMMENT 'When the badge was marked as printed',
ADD COLUMN printed_by INT NULL COMMENT 'Admin user who marked the badge as printed',
ADD INDEX idx_is_printed (is_printed),
ADD INDEX idx_printed_at (printed_at);

-- Note: printed_by could be linked to admin_users table if you have one
-- If you want to add foreign key constraint:
-- ADD FOREIGN KEY (printed_by) REFERENCES admin_users(id) ON DELETE SET NULL;

