<?php
/**
 * Setup Badge Tables
 * Run this script once to create badge-related tables
 */

require_once 'db_config.php';

try {
    $pdo = getDBConnection();
    
    // Read and execute SQL file
    $sql = file_get_contents('sql/create_badge_tables.sql');
    
    // Split by semicolon and execute each statement
    $statements = array_filter(array_map('trim', explode(';', $sql)));
    
    foreach ($statements as $statement) {
        if (!empty($statement) && !preg_match('/^--/', $statement)) {
            $pdo->exec($statement);
        }
    }
    
    echo "✅ Badge tables created successfully!\n";
    echo "✅ Default badge settings inserted!\n";
    echo "\nNext steps:\n";
    echo "1. Create uploads/badges/logos/ directory\n";
    echo "2. Create uploads/badges/generated/ directory\n";
    echo "3. Access admin/badges.php to start generating badges\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    exit(1);
}
?>


