<?php
/**
 * Registration Payment Success Page
 */

require_once 'db_config.php';

$registrationNumber = $_GET['registration_number'] ?? '';
$paymentIntentId = $_GET['payment_intent'] ?? '';

// Verify payment and get registration details
$registrationData = null;
if ($registrationNumber) {
    try {
        $pdo = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME,
            DB_USER,
            DB_PASS,
            [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
        );
        
        $stmt = $pdo->prepare("
            SELECT r.*, pt.amount, pt.transaction_status 
            FROM registrations r 
            LEFT JOIN payment_transactions pt ON r.registration_number = pt.registration_number 
            WHERE r.registration_number = ?
        ");
        $stmt->execute([$registrationNumber]);
        $registrationData = $stmt->fetch(PDO::FETCH_ASSOC);
        
    } catch (Exception $e) {
        error_log('Error fetching registration data: ' . $e->getMessage());
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Successful - XChange 2025</title>
    <?php include 'includes/favicon.php'; ?>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <section class="section">
        <div class="container">
            <div class="success-page">
                <div class="success-icon">✅</div>
                <h1 class="text-3xl fw-800 mt-4">Payment Successful!</h1>
                <p class="text-lg mt-3">Thank you for registering for AppliedHE Xchange 2025</p>
                
                <?php if ($registrationData): ?>
                <div class="card mt-8">
                    <h2 class="text-xl">Registration Details</h2>
                    <div class="registration-details mt-4">
                        <div class="detail-row">
                            <strong>Registration Number:</strong>
                            <span><?php echo htmlspecialchars($registrationNumber); ?></span>
                        </div>
                        <div class="detail-row">
                            <strong>Amount Paid:</strong>
                            <span>USD $<?php echo number_format($registrationData['amount'] ?? 0, 2); ?></span>
                        </div>
                        <div class="detail-row">
                            <strong>Payment Status:</strong>
                            <span class="status-badge paid"><?php echo ucfirst($registrationData['transaction_status'] ?? 'pending'); ?></span>
                        </div>
                        <div class="detail-row">
                            <strong>Event Date:</strong>
                            <span>27–28 November 2025</span>
                        </div>
                        <div class="detail-row">
                            <strong>Venue:</strong>
                            <span>Sunway University, Malaysia</span>
                        </div>
                    </div>
                </div>
                
                <div class="card mt-8">
                    <h3 class="text-lg">What's Next?</h3>
                    <ul class="next-steps mt-3">
                        <li>📧 You will receive a confirmation email shortly</li>
                        <li>📋 Event details and agenda will be sent closer to the date</li>
                        <li>🎫 Your delegate badges will be ready for collection at the venue</li>
                        <li>📞 For any queries, contact us at info@appliedhe.com</li>
                    </ul>
                </div>
                <?php endif; ?>
                
                <div class="mt-8">
                    <a href="<?php require_once 'get_event_page_url.php'; echo htmlspecialchars(getEventPageUrl()); ?>" class="btn btn-primary">Return to Event Page</a>
                    <button onclick="window.print()" class="btn btn-ghost ml-3">Print Confirmation</button>
                </div>
            </div>
        </div>
    </section>
    
    <style>
        .success-page {
            text-align: center;
            max-width: 600px;
            margin: 0 auto;
            padding: 2rem 0;
        }
        
        .success-icon {
            font-size: 4rem;
            color: var(--green-600);
        }
        
        .registration-details {
            text-align: left;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 0.75rem 0;
            border-bottom: 1px solid var(--slate-200);
        }
        
        .detail-row:last-child {
            border-bottom: none;
        }
        
        .status-badge.paid {
            background: var(--green-100);
            color: var(--green-800);
            padding: 0.25rem 0.5rem;
            border-radius: 0.375rem;
            font-size: 0.875rem;
            font-weight: 600;
        }
        
        .next-steps {
            text-align: left;
            list-style: none;
            padding: 0;
        }
        
        .next-steps li {
            padding: 0.5rem 0;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
    </style>
</body>
</html>
