<?php
/**
 * Registration Payment Canceled Page
 */
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Canceled - XChange 2025</title>
    <?php include 'includes/favicon.php'; ?>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <section class="section">
        <div class="container">
            <div class="cancel-page">
                <div class="cancel-icon">❌</div>
                <h1 class="text-3xl fw-800 mt-4">Payment Canceled</h1>
                <p class="text-lg mt-3">Your payment was canceled and no charges were made</p>
                
                <div class="card mt-6">
                    <h2 class="text-xl">What happened?</h2>
                    <p class="mt-3">You canceled the payment process before completing your registration for AppliedHE Xchange 2025.</p>
                    
                    <div class="mt-4">
                        <h3 class="text-lg">Your options:</h3>
                        <ul class="options-list mt-3">
                            <li>💳 <strong>Complete Payment</strong> - Your registration data is saved and ready</li>
                            <li>🏦 <strong>Switch to Bank Transfer</strong> - Pay via telegraphic transfer instead</li>
                            <li>📞 <strong>Need Help?</strong> Contact us at finance@appliedhe.com</li>
                        </ul>
                    </div>
                    
                    <div class="mt-4 p-4 bg-blue-50 rounded-lg">
                        <p class="text-sm text-blue-800">
                            <strong>Good news!</strong> Your registration information is safely stored. 
                            You can complete your payment without re-entering all your details.
                        </p>
                    </div>
                </div>
                
                <div class="button-section">
                    <a href="index.html" class="btn btn-primary">Complete Payment</a>
                    <a href="index.html?new=1" class="btn btn-ghost ml-3">Start New Registration</a>
                    <a href="<?php require_once 'get_event_page_url.php'; echo htmlspecialchars(getEventPageUrl()); ?>" class="btn btn-ghost ml-3">Return to Event Page</a>
                </div>
            </div>
        </div>
    </section>
    
    <style>
        .cancel-page {
            text-align: center;
            max-width: 600px;
            margin: 0 auto;
            padding: 2rem 0;
        }
        
        .cancel-icon {
            font-size: 4rem;
            color: var(--red-600);
        }
        
        .options-list {
            text-align: left;
            list-style: none;
            padding: 0;
        }
        
        .options-list li {
            padding: 0.5rem 0;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .button-section {
            margin-top: 3rem;
            padding-top: 2rem;
            border-top: 1px solid var(--slate-200);
        }
    </style>
</body>
</html>
