# File Cleanup Proposal
**Created:** 2025-10-29  
**Purpose:** Analysis of files that can be safely removed or archived

---

## 🔴 Priority 1: 100% Safe to Remove Immediately

These are test/debug files with no production dependencies.

### Test Files
- ✅ `test_query.php` - One-time query testing script (not referenced in production)
- ✅ `admin/debug_email_test.php` - Email debugging test script
- ✅ `admin/test_email_api.php` - Email API test endpoint (if not used for ongoing testing)

### Debug/Diagnostic Files (One-time use)
- ✅ `debug_email_products.php` - One-time debug script for email products
- ✅ `diagnose_env.php` - Environment diagnostic tool (for troubleshooting only)

### Backup Files (No longer needed)
- ✅ `index_backup.html` - Old backup of index.html (replaced by index.php)

### Duplicate Files
- ✅ `public_invoice.php` (root) - Duplicate of `public/public_invoice.php`
- ✅ `registration_success.php` (root) - Duplicate of `public/registration_success.php`
- ✅ `src/` folder - Contains duplicates with different path structure:
  - `src/product_api.php` - Duplicate of root `product_api.php` (uses `config/` subfolder)
  - `src/email_notifications.php` - Likely duplicate of root `email_notifications.php`
  - `src/logo_helper.php` - Likely duplicate of root `logo_helper.php`
  - **Note**: No code references `src/` files, root versions are used instead

---

## 🟡 Priority 2: Archive (One-time Migration Scripts)

These migration scripts have completed their purpose. Archive them to `archive/migrations/`.

### Root Level Migration Scripts
- ✅ `migrate_add_department_field.php` - Completed (documentation indicates completion)
- ✅ `migrate_badge_print_tracking.php` - Completed (referenced in docs as done)
- ✅ `migrate_complete_badge_system.php` - Completed
- ✅ `migrate_complimentary_status.php` - Completed
- ✅ `migrate_email_field.php` - Completed
- ✅ `migrate_make_department_required.php` - Completed
- ✅ `run_badge_sql.php` - One-time SQL setup script (replaced by migration system)

### Verify Scripts (Archive after confirming migrations worked)
- ⚠️ `verify_badge_tables.php` - Verification script (can archive after confirming setup)
- ⚠️ `verify_delegate_migration.php` - Migration verification (archive after confirming)
- ⚠️ `verify_department_field.php` - Field verification (archive after confirming)

**Note:** These verify scripts are referenced in documentation. Archive them rather than delete in case they're needed for troubleshooting.

---

## 🟠 Priority 3: Archive (Fix Scripts - Likely Completed)

One-time fix scripts for specific issues.

### Collation Fix Scripts
- ⚠️ `fix_live_collation.php` - Database collation fix (one-time use)
- ⚠️ `fix_sal_collation.php` - Special Access Links collation fix (one-time use)

**Decision:** If collation issues are resolved, these can be archived.

---

## 🟢 Priority 4: Keep But Document

These files are utilities that may still be useful.

### Setup/Configuration Scripts
- 🔄 `setup.php` - Feature setup utility (may still be used for new features)
- 🔄 `setup_badge_tables.php` - Badge table setup (may still be referenced)
- 🔄 `setup_email_config.php` - Email configuration setup
- 🔄 `setup_database_only.sql` - SQL setup file (keep for reference)

### Utility Scripts
- 🔄 `create_backup.php` - Database backup utility (useful to keep)
- 🔄 `admin/create_backup.php` or `admin/backup-config.php` - Backup utilities (verify which is used)

### Reset/Utility Scripts
- 🔄 `reset_payment_status.php` - Payment reset utility (may still be needed)
- 🔄 `send_payment_reminders.php` - Payment reminder utility (ongoing use)

---

## 📦 Priority 5: Review SQL Files

Many SQL files in `sql/` folder may be one-time migration scripts.

### SQL Files to Archive (One-time migrations)
- ⚠️ `sql/add_department_to_delegates.sql` - Already migrated via PHP script
- ⚠️ `sql/add_email_to_delegates.sql` - Already migrated
- ⚠️ `sql/add_badge_print_tracking.sql` - Already migrated
- ⚠️ `sql/add_complimentary_payment_status.sql` - Already migrated
- ⚠️ `sql/add_referral_code_to_registrations.sql` - Already migrated
- ⚠️ `sql/create_badge_tables.sql` - Already migrated
- ⚠️ `sql/create_special_access_links.sql` - Already migrated

### SQL Files to Keep (Reference/Setup)
- ✅ `sql/database_schema.sql` - Main schema reference (KEEP)
- ✅ `sql/production_db.sql` - Production schema reference (KEEP)
- ✅ `sql/fix_collation.sql` - May be needed for reference (KEEP for now)

---

## 📁 Recommended Archive Structure

```
archive/
├── migrations/
│   ├── 2025_08_22/          (already exists)
│   ├── 2025_10_24/          (new - for Oct 2024 migrations)
│   │   ├── migrate_add_department_field.php
│   │   ├── migrate_email_field.php
│   │   ├── migrate_make_department_required.php
│   │   └── verify_department_field.php
│   ├── badge_system/         (new)
│   │   ├── migrate_complete_badge_system.php
│   │   ├── migrate_badge_print_tracking.php
│   │   ├── run_badge_sql.php
│   │   └── verify_badge_tables.php
│   └── other/               (new)
│       ├── migrate_complimentary_status.php
│       └── verify_delegate_migration.php
├── fixes/                   (new)
│   ├── fix_live_collation.php
│   └── fix_sal_collation.php
├── test_files/              (new)
│   ├── test_query.php
│   ├── debug_email_products.php
│   ├── diagnose_env.php
│   └── admin/
│       ├── debug_email_test.php
│       └── test_email_api.php
└── backups/                 (existing - review old .sql files)
    ├── [keep recent backups]
    └── [archive or delete old ones from Aug 2025]
```

---

## 🗑️ Files Safe to Delete (Not Archive)

These have no value to keep:

1. `index_backup.html` - Duplicate file
2. Root level duplicates:
   - `public_invoice.php` (if `public/public_invoice.php` exists and works)
   - `registration_success.php` (if `public/registration_success.php` exists and works)

---

## ✅ Action Plan Summary

### Immediate Actions (100% Safe)
1. Delete test files: `test_query.php`, `debug_email_products.php`, `diagnose_env.php`
2. Delete admin test files: `admin/debug_email_test.php`, `admin/test_email_api.php`
3. Delete backup HTML: `index_backup.html`
4. Remove duplicate root files (if public/ versions exist and work)
5. Remove entire `src/` folder (confirmed duplicates, not referenced by codebase)

### Archive Actions (After Review)
1. Move completed migration scripts to `archive/migrations/`
2. Move verify scripts to `archive/migrations/`
3. Move fix scripts to `archive/fixes/`
4. Review and archive old SQL migration files
5. Review `src/` folder for duplicates

### Keep Actions
1. Keep utility scripts: `create_backup.php`, `setup.php`
2. Keep reference SQL files: `database_schema.sql`, `production_db.sql`
3. Keep ongoing utilities: `reset_payment_status.php`, `send_payment_reminders.php`

---

## ⚠️ Before Removing Files

1. **Backup First**: Create a full backup of the codebase
2. **Test Production**: Ensure no production dependencies on these files
3. **Check Git**: Make sure files are tracked in version control before deletion
4. **Document**: Update any documentation that references these files

---

## 📝 Notes

- All migration scripts are one-time use and safe to archive after completion
- Verify scripts are useful for troubleshooting - archive rather than delete
- Test files serve no production purpose - safe to delete immediately
- SQL files may be needed for reference - review before archiving

---

## Questions to Resolve

1. ✅ **Duplicate Files**: `src/` folder confirmed as duplicates (RESOLVED - safe to remove)
2. **Ongoing Test Files**: Is `admin/test_email_api.php` used for ongoing testing? (Verify before removal)
3. **Backup Folder**: Should old SQL backups from Aug 2025 be archived or deleted?
4. **Setup Scripts**: Are setup scripts still actively used for new deployments?

---

**Status**: Ready for Review  
**Next Step**: Review this proposal and approve before proceeding with cleanup

