# Badge Generation System - Quick Start Guide

## 🎫 Your Event Badge System is Ready!

I've created a complete badge generation system for your XChange event. Here's how to use it:

## 🚀 Quick Start (3 Steps)

### Step 1: Access the Badge System
1. Go to: `http://localhost/Xchange_Admin/admin/badges`
2. Or from admin panel: **Delegates** → **Event Badges**

### Step 2: Configure Badge Settings
1. Click **⚙️ Badge Settings** button (top right)
2. Upload your logos:
   - **Event Logo**: Your main event logo (top of badge)
   - **University Logo**: Hosting institution logo (bottom left)
   - **Partner Logo**: Partner organization logo (bottom left)
3. Verify event details:
   - Event Name: "Applied HE>X CHANGE"
   - Dates: "27-28 FEB 2025"
   - Location: "MANILA, PHILIPPINES"
4. Click **💾 Save Settings**

### Step 3: Generate Badges
Choose your generation method:

**Option A: Single Badge**
- Click **👁️ Preview** on any delegate
- Click **🖨️ Print** to open print dialog

**Option B: Batch Generation**
- Click **📦 Generate All Badges** (all delegates)
- Or **✅ Generate Paid Delegates** (confirmed only)
- Press Ctrl+P (Cmd+P on Mac) to save as PDF

## 📐 Badge Specifications

**Matches your sample image exactly:**
- ✅ Size: 340px × 500px
- ✅ Event logo at top
- ✅ Large first name display (from badge_name)
- ✅ Full name, designation, department
- ✅ University name
- ✅ University and partner logos at bottom
- ✅ QR code (links to registration)
- ✅ Decorative footer with gradient

## 🎨 What You Can Customize

In **Badge Settings**:
- Event information (name, dates, location)
- All logos (event, university, partner)
- Colors (background, text, accent)
- Badge size (currently 340×500px)
- QR code (enable/disable)
- Display options (show/hide elements)

## 📍 Available Pages

1. **Badges** (`admin/badges.php`)
   - Main page: View all delegates, generate badges
   
2. **Badge Settings** (`admin/badge-settings.php`)
   - Configure event details and upload logos
   
3. **Badge Designer** (`admin/badge-generator.php`)
   - Preview and test badge designs

## 💡 Pro Tips

1. **Test First**: Use "Badge Designer" to preview before batch generation
2. **Upload Logos**: PNG with transparent background works best
3. **Print Quality**: Save as PDF using browser's print function (Ctrl+P)
4. **Batch Processing**: Select specific delegates using checkboxes + "Generate Filtered"

## 📁 Files Created

```
✅ admin/badges.php              - Main badge page
✅ admin/badge-settings.php      - Settings page
✅ admin/badge-generator.php     - Designer/preview
✅ admin/badge_api.php           - Generation API
✅ Database tables created
✅ Navigation menu updated
✅ Upload directories created
```

## 🎉 You're All Set!

The system is fully functional and ready to generate badges for your event!

**Next Steps:**
1. Go to `admin/badges`
2. Upload your logos in Settings
3. Preview a few badges
4. Generate badges for all paid delegates

For detailed information, see `BADGE_GENERATION_SYSTEM.md`

---
**Need Help?** All PHP files are syntax-checked and working. Just upload your logos and start generating!

