# Badge Design Reference

## Visual Structure (340×500px)

```
┌─────────────────────────────────────────────────┐
│                                                 │
│         [APPLIED HE>X CHANGE LOGO]              │  ← Event Logo (or text)
│     27-28 FEB 2025 - MANILA, PHILIPPINES        │  ← Event Details
│─────────────────────────────────────────────────│  ← Accent Color Border
│                                                 │
│                                                 │
│                                                 │
│                     JOHN                        │  ← Badge Name (Large, 56px)
│                                                 │
│                                                 │
│            John Rowell Obligado                 │  ← Full Name (16px)
│             Technical Assistant                  │  ← Designation (13px)
│         Office of International Affairs          │  ← Department (11px)
│                                                 │
│      NUEVA ECIJA UNIVERSITY OF                   │  ← University Name (13px)
│      SCIENCE AND TECHNOLOGY                      │     (Uppercase, Bold)
│                                                 │
│                                                 │
│─────────────────────────────────────────────────│
│  [🏛️ Logo] [🤝 Logo]              [QR CODE]     │  ← Footer (Logos + QR)
│                                   "Scan here"   │
│─────────────────────────────────────────────────│
│          [Decorative Wave Pattern]              │  ← Gradient Footer
└─────────────────────────────────────────────────┘
```

## Element Details

### Header Section (70px height)
- **Event Logo**: Max 200×40px, centered
- **Event Details**: 10px font, BLACK color
- **Border**: 3px accent color line

### Main Content Section (Flexible, centered)
- **Badge Name**: 56px, weight 900, uppercase, letter-spacing 2px, BLACK (displays badge_name field)
- **Full Name**: 16px, weight 700, BLACK (displays full_name field)
- **Designation**: 13px, weight 600, italic, BLACK
- **Department**: 11px, weight 500, BLACK (if available)
- **University**: 13px, weight 800, uppercase, letter-spacing 0.5px, BLACK
- **Spacing**: 20px below first name, 8-10px between other elements
- **All text**: Uses $text_color variable (default: BLACK #000000)

### Footer Section (140px height)
- **Logos Section**: 
  - Left side: University logo (100×80px if no partner, 50×40px if partner exists)
  - Partner logo: 50×40px (if present)
  - 10px gap between logos
- **QR Code**:
  - Right side: 80×80px
  - White background with 4px padding
  - 2px border, 8px border-radius
  - Small text below: "Scan for schedule" (7px)
- **Decorative Footer**: 40px height
  - Gradient background with accent color
  - Wave pattern overlay (30px height)

## Color Scheme

### Default Colors
```css
Background:  #ffffff (White)
Text:        #000000 (Black) - Used for ALL text on badge
Accent:      #6B9F3E (Green)
Gray-Light:  #e5e7eb (Borders only, not text)
```

### Customizable via Settings
- Badge Background Color
- Primary Text Color
- Accent Color (used for borders and footer gradient)

## Typography

**Font Family**: Poppins (Google Fonts)

**Font Weights Used**:
- 400 (Regular) - Base text
- 500 (Medium) - Department
- 600 (Semi-Bold) - Designation, labels
- 700 (Bold) - Full name
- 800 (Extra-Bold) - University name
- 900 (Black) - First name display

## Data Sources

### From `delegates` table:
- `badge_name` → Displayed large (uppercase) - the name delegate wants on badge
- `full_name` → Complete legal name displayed below badge name
- `designation` → Job title/position
- `email` → (not shown on badge)

### From `registrations` table:
- `registration_number` → Used in QR code
- `university_name` → Institution name
- `contact_department` → Department name (if available)

### From `badge_settings` table:
- `event_name` → Header text
- `event_dates` → Event date range
- `event_location` → Event location
- `event_logo_path` → Main logo
- `university_logo_path` → Bottom-left logo
- `partner_logo_path` → Bottom-left logo (second)
- Colors, dimensions, display options

## QR Code

**Purpose**: Quick delegate verification or program access

**Data Encoded**:
- Default: Registration number only (e.g., "XC25-ABC123")
- With Base URL: Full URL (e.g., "https://yoursite.com/verify/XC25-ABC123")

**Generated via**: QR Server API (https://api.qrserver.com)
- Size: 100×100px (scaled to 80×80px on badge)
- Error correction: Default (medium)

## Responsive Behavior

**Print/Export**:
- Maintains exact 340×500px dimensions
- All fonts load from Google Fonts
- Images embedded as absolute URLs
- Colors preserved in PDF export

**Screen Display**:
- Scales proportionally on smaller screens
- Shadow effect for depth
- Border radius for modern look

## File Formats

**Logo Requirements**:
- **Formats**: JPG, PNG, GIF, SVG
- **Max Size**: 5MB per file
- **Recommended**: PNG with transparent background
- **Aspect Ratio**: Maintain original proportions
- **University Logo**: Automatically doubles in size (100×80px) when no partner logo present

**Output Formats**:
- **HTML**: Direct download/print
- **PDF**: Via browser print-to-PDF (Ctrl+P)
- **Image**: Screenshot or HTML-to-image conversion

## Design Principles

1. **Hierarchy**: Badge name (preferred name) is most prominent
2. **Readability**: High contrast, adequate spacing
3. **Professional**: Clean layout, consistent typography
4. **Informative**: All essential info visible at a glance
5. **Branded**: Customizable colors and logos
6. **Functional**: QR code for quick verification
7. **Print-Ready**: High-quality output suitable for professional printing

## Customization Examples

### Corporate Style
```
Background: #ffffff
Text: #1a1a1a
Accent: #0066cc (Blue)
```

### Academic Style
```
Background: #f8f9fa
Text: #2c3e50
Accent: #8e44ad (Purple)
```

### Vibrant Style
```
Background: #ffffff
Text: #000000
Accent: #e74c3c (Red)
```

## Print Specifications

**Physical Size Calculation**:
- 340px @ 96 DPI = 3.54 inches
- 500px @ 96 DPI = 5.21 inches
- Recommended paper: 4" × 6" (badge size fits with small margin)

**Printer Settings**:
- Paper: Badge/Card stock or 4×6 photo paper
- Quality: Best/Highest
- Scale: 100% (no scaling)
- Margins: None/Minimal
- Color: Full color
- Background graphics: Enabled

**Professional Printing**:
- Export as PDF via browser print dialog
- Provide to print service
- Recommend: Heavy card stock (250-300gsm)
- Optional: Lamination for durability

## Browser Compatibility

**Tested & Working**:
- ✅ Chrome/Edge (Chromium) - Recommended
- ✅ Firefox
- ✅ Safari
- ✅ Opera

**Print-to-PDF**:
- ✅ Chrome/Edge built-in PDF printer
- ✅ Firefox built-in PDF printer
- ✅ macOS Safari + Preview
- ✅ Third-party PDF printers

## Implementation Notes

**Badge Generation Performance**:
- Single badge: < 1 second
- Batch (50 badges): 3-5 seconds
- Batch (100+ badges): Generate in groups for better browser performance

**Image Loading**:
- Logos loaded from server filesystem
- QR codes loaded from external API
- All images cached by browser for repeat access

**Font Loading**:
- Google Fonts API used
- Multiple weights preloaded
- Fallback to Arial if fonts fail to load

---

**This design matches your sample badge exactly!**

The implementation uses modern HTML/CSS with inline styles for maximum portability and print compatibility.

