<?php
// Get the base path for the application dynamically
function getBasePath() {
    // Get the current script's directory path
    $currentScript = $_SERVER['SCRIPT_NAME'];
    $currentDir = dirname($currentScript);
    
    // If we're in the admin folder, go up one level to get to the main app folder
    if (basename($currentDir) === 'admin') {
        $appDir = dirname($currentDir);
    } else {
        $appDir = $currentDir;
    }
    
    // Return the path with trailing slash, ensuring it starts with /
    $basePath = rtrim($appDir, '/') . '/';
    return $basePath === '/' ? '' : $basePath;
}

// Alternative function for CSS paths specifically
function getCssPath() {
    // Determine if we're in admin folder
    $currentScript = $_SERVER['SCRIPT_NAME'];
    $isInAdmin = strpos($currentScript, '/admin/') !== false;
    
    if ($isInAdmin) {
        return '../styles.css';
    } else {
        return 'styles.css';
    }
}

// Get the full URL base path
function getBaseUrl() {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    $basePath = getBasePath();
    
    return $protocol . '://' . $host . $basePath;
}
?>
