-- XChange Database Backup (Critical Tables)
-- Created: 2025-08-22 14:49:45
-- Database: xchange_reg

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

-- Table structure for table `products`
DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) DEFAULT NULL,
  `product_code` varchar(50) NOT NULL,
  `name` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `base_price` decimal(10,2) NOT NULL,
  `currency` varchar(3) DEFAULT 'USD',
  `total_stock` int(11) DEFAULT NULL,
  `reserved_stock` int(11) DEFAULT 0,
  `sold_stock` int(11) DEFAULT 0,
  `available_stock` int(11) GENERATED ALWAYS AS (case when `total_stock` is null then 999999 else greatest(0,`total_stock` - `reserved_stock` - `sold_stock`) end) STORED,
  `sale_start_date` datetime DEFAULT NULL,
  `sale_end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `requires_approval` tinyint(1) DEFAULT 0,
  `max_per_registration` int(11) DEFAULT 1,
  `display_order` int(11) DEFAULT 0,
  `metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_code` (`product_code`),
  KEY `idx_product_code` (`product_code`),
  KEY `idx_category` (`category_id`),
  KEY `idx_active` (`is_active`),
  KEY `idx_stock` (`available_stock`),
  CONSTRAINT `products_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `product_categories` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `products` (18 rows)
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('3', '4', 'TABLETOP_STANDARD', 'Table‑top Presentation – Standard', '<div>Ideal for showcasing programs and partnerships.</div><div>-Includes 1 table, 4 chairs</div><div>-Up to 2 standing banners (self‑produced)</div>', '550.00', 'USD', '15', '0', '2', '13', '2025-07-30 19:50:00', '2025-11-28 19:51:00', '1', '0', '10', '0', NULL, '2025-08-17 11:01:16', '2025-08-21 10:28:59');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('4', '4', 'TABLETOP_DOUBLE', 'Table‑top Presentation – Double', '<div>Ideal for showcasing programs and partnerships.</div><div>-Includes 1 table, 4 chairs</div><div>-Up to 2 standing banners (self‑produced)</div>', '850.00', 'USD', '15', '0', '2', '13', '2025-07-31 11:51:00', '2025-11-29 11:51:00', '1', '0', '10', '0', NULL, '2025-08-17 11:01:29', '2025-08-21 10:28:59');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('6', '3', 'DELEGATE_PASS', 'Delegates (Legacy - Migrated)', 'Access to all sessions, exhibits, and networking.', '100.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '0', '0', '1', '0', NULL, '2025-08-18 21:01:13', '2025-08-22 20:42:56');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('7', '5', 'PLATINUM_SPONSOR', 'Platinum Sponsor', 'Includes 8 delegate passes<br data-start=\"72\" data-end=\"75\"><i>\r\nView all included items on the events page</i>', '10000.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '5', '0', NULL, '2025-08-19 00:26:54', '2025-08-21 10:28:59');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('8', '6', 'ELEVATOR_PITCH', 'Elevator Pitch', 'Showcase your institution or service with a focused, high-impact pitch using a prime networking break.', '500.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '5', '1', NULL, '2025-08-19 11:47:46', '2025-08-21 17:49:23');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('11', '5', 'GOLD_SPONSOR', 'Gold Sponsor', 'Includes 6 delegate passes<br data-start=\"72\" data-end=\"75\">\r\nView all included items on the events page', '8000.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '5', '0', NULL, '2025-08-19 13:58:32', '2025-08-21 10:28:59');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('12', '5', 'SILVER_SPONSOR', 'Silver Sponsor', 'Includes 4 delegate passes<br data-start=\"72\" data-end=\"75\">\r\nView all included items on the events page', '5500.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '5', '0', NULL, '2025-08-19 14:08:05', '2025-08-21 10:28:59');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('13', '5', 'BRONZE_SPONSOR', 'Bronze Sponsor', 'Includes 2 delegate passes<br data-start=\"72\" data-end=\"75\">\r\nView all included items on the events page', '5500.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '5', '0', NULL, '2025-08-19 14:09:06', '2025-08-21 10:28:59');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('14', '6', 'IN_AD_IN_PB', 'institution Ad in Program Book', 'Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.', '1000.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '0', '0', '5', '0', NULL, '2025-08-19 14:23:51', '2025-08-21 16:54:57');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('15', '6', 'CONF_LANYARD', 'Conference Lanyard', '2 complimentary delegate registrations<br>View all included items on the events page', '8800.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '5', '3', NULL, '2025-08-19 14:26:14', '2025-08-21 17:49:46');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('16', '6', 'CONF_BAG', 'Conference Bag Sponsorship', '3 complimentary delegate registrations <br>View all included items on the events page', '9900.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '5', '4', NULL, '2025-08-19 14:41:50', '2025-08-21 17:56:49');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('17', '6', 'VI_PL_PA', 'Visibility Plus Package', 'Maximize brand visibility across events globally<br>View all included items on the events page', '2500.00', 'USD', NULL, '0', '0', '999999', NULL, NULL, '1', '0', '5', '2', NULL, '2025-08-21 16:52:59', '2025-08-21 17:49:34');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('26', '3', 'DELEGATE_EARLY_BIRD', 'Early Bird Delegate', 'Discounted delegate pass for early registrations. Access to all sessions, exhibits, and networking.', '450.00', 'USD', NULL, '0', '0', '999999', NULL, NULL, '1', '0', '50', '1', '{\"type\":\"early_bird\",\"eligibility\":[\"general\"],\"approval_required\":false,\"description_short\":\"Early registration discount\"}', '2025-08-22 20:42:56', '2025-08-22 20:42:56');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('27', '3', 'DELEGATE_STANDARD', 'Standard Delegate', 'Regular delegate pass. Access to all sessions, exhibits, and networking.', '550.00', 'USD', NULL, '0', '0', '999999', NULL, NULL, '1', '0', '50', '2', '{\"type\":\"standard\",\"eligibility\":[\"general\"],\"approval_required\":false,\"description_short\":\"Regular registration\"}', '2025-08-22 20:42:56', '2025-08-22 20:42:56');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('28', '3', 'DELEGATE_STUDENT', 'Student Delegate', 'Discounted pass for students. Access to all sessions, exhibits, and networking. Student verification may be required.', '300.00', 'USD', NULL, '0', '0', '999999', NULL, NULL, '1', '0', '50', '3', '{\"type\":\"student\",\"eligibility\":[\"students\"],\"approval_required\":false,\"description_short\":\"Student discount\",\"verification_note\":\"Student ID may be required at event\"}', '2025-08-22 20:42:56', '2025-08-22 20:42:56');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('29', '3', 'DELEGATE_SPEAKER', 'Speaker', 'Complimentary pass for event speakers. Full access to all sessions, exhibits, and networking.', '0.00', 'USD', '50', '0', '0', '50', NULL, NULL, '1', '0', '20', '4', '{\"type\":\"speaker\",\"eligibility\":[\"speakers\"],\"approval_required\":false,\"complimentary\":true,\"description_short\":\"Complimentary for speakers\"}', '2025-08-22 20:42:56', '2025-08-22 20:42:56');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('30', '3', 'DELEGATE_VIP', 'VIP Delegate', 'Premium delegate experience with exclusive access to VIP areas, priority seating, and enhanced networking opportunities.', '800.00', 'USD', '30', '0', '0', '30', NULL, NULL, '1', '0', '20', '5', '{\"type\":\"vip\",\"eligibility\":[\"general\"],\"approval_required\":false,\"premium\":true,\"description_short\":\"Premium experience with exclusive access\"}', '2025-08-22 20:42:56', '2025-08-22 20:42:56');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('31', '3', 'DELEGATE_ORGANIZER', 'Event Organizer', 'Complimentary pass for event organizers and staff. Full access to all sessions, exhibits, and networking.', '0.00', 'USD', '20', '0', '0', '20', NULL, NULL, '1', '0', '10', '6', '{\"type\":\"organizer\",\"eligibility\":[\"organizers\"],\"approval_required\":false,\"complimentary\":true,\"description_short\":\"Complimentary for organizers\"}', '2025-08-22 20:42:56', '2025-08-22 20:42:56');

-- Table structure for table `product_categories`
DROP TABLE IF EXISTS `product_categories`;
CREATE TABLE `product_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `display_order` int(11) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `product_categories` (4 rows)
INSERT INTO `product_categories` (`id`, `name`, `description`, `display_order`, `is_active`, `created_at`, `updated_at`) VALUES ('3', 'Delegate Pass', '', '0', '1', '2025-08-17 10:14:36', '2025-08-17 10:14:36');
INSERT INTO `product_categories` (`id`, `name`, `description`, `display_order`, `is_active`, `created_at`, `updated_at`) VALUES ('4', 'Presentations', '', '1', '1', '2025-08-17 10:59:31', '2025-08-17 10:59:31');
INSERT INTO `product_categories` (`id`, `name`, `description`, `display_order`, `is_active`, `created_at`, `updated_at`) VALUES ('5', 'Sponsorship', '', '3', '1', '2025-08-18 19:04:05', '2025-08-19 13:56:14');
INSERT INTO `product_categories` (`id`, `name`, `description`, `display_order`, `is_active`, `created_at`, `updated_at`) VALUES ('6', 'Other Sponsorship', '', '4', '1', '2025-08-18 19:04:18', '2025-08-19 13:56:06');

-- Table structure for table `product_pricing`
DROP TABLE IF EXISTS `product_pricing`;
CREATE TABLE `product_pricing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `pricing_tier` varchar(50) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `valid_from` datetime DEFAULT NULL,
  `valid_until` datetime DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_product_tier` (`product_id`,`pricing_tier`),
  KEY `idx_pricing_tier` (`pricing_tier`),
  KEY `idx_valid_dates` (`valid_from`,`valid_until`),
  CONSTRAINT `product_pricing_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `product_pricing` (6 rows)
INSERT INTO `product_pricing` (`id`, `product_id`, `pricing_tier`, `price`, `valid_from`, `valid_until`, `is_active`, `created_at`) VALUES ('33', '6', 'Early Bird', '550.00', '2025-08-01 21:06:00', '2025-09-07 21:06:00', '1', '2025-08-18 21:51:48');
INSERT INTO `product_pricing` (`id`, `product_id`, `pricing_tier`, `price`, `valid_from`, `valid_until`, `is_active`, `created_at`) VALUES ('34', '6', 'Standard', '580.00', '2025-09-07 21:06:00', '2025-11-29 21:06:00', '1', '2025-08-18 21:51:48');
INSERT INTO `product_pricing` (`id`, `product_id`, `pricing_tier`, `price`, `valid_from`, `valid_until`, `is_active`, `created_at`) VALUES ('39', '26', 'Super Early Bird', '400.00', '2025-06-01 00:00:00', '2025-07-31 23:59:59', '1', '2025-08-22 20:42:56');
INSERT INTO `product_pricing` (`id`, `product_id`, `pricing_tier`, `price`, `valid_from`, `valid_until`, `is_active`, `created_at`) VALUES ('40', '26', 'Early Bird Extended', '475.00', '2025-08-01 00:00:00', '2025-09-30 23:59:59', '1', '2025-08-22 20:42:56');
INSERT INTO `product_pricing` (`id`, `product_id`, `pricing_tier`, `price`, `valid_from`, `valid_until`, `is_active`, `created_at`) VALUES ('41', '27', 'Late Registration', '600.00', '2025-10-01 00:00:00', '2025-11-25 23:59:59', '1', '2025-08-22 20:42:56');
INSERT INTO `product_pricing` (`id`, `product_id`, `pricing_tier`, `price`, `valid_from`, `valid_until`, `is_active`, `created_at`) VALUES ('42', '30', 'VIP Early Bird', '750.00', '2025-06-01 00:00:00', '2025-08-31 23:59:59', '1', '2025-08-22 20:42:56');

-- Table structure for table `registrations`
DROP TABLE IF EXISTS `registrations`;
CREATE TABLE `registrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `registration_number` varchar(50) DEFAULT NULL,
  `delegate_type` enum('earlyBird','standard') NOT NULL,
  `delegate_count` int(11) NOT NULL,
  `has_standard_table` tinyint(1) DEFAULT 0,
  `has_double_table` tinyint(1) DEFAULT 0,
  `contact_salutation` varchar(20) DEFAULT NULL,
  `contact_full_name` varchar(255) NOT NULL,
  `contact_badge_name` varchar(100) NOT NULL,
  `contact_designation` varchar(255) NOT NULL,
  `contact_department` varchar(255) NOT NULL,
  `contact_email` varchar(255) NOT NULL,
  `contact_mobile` varchar(50) NOT NULL,
  `university_name` varchar(255) NOT NULL,
  `country` varchar(100) NOT NULL,
  `payment_method` enum('gateway','tt') NOT NULL,
  `payment_status` enum('pending','paid','failed','expired','cancelled') DEFAULT 'pending',
  `payment_reference` varchar(100) DEFAULT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `payment_deadline` date DEFAULT NULL,
  `admin_notes` text DEFAULT NULL COMMENT 'Rich text admin notes for this registration',
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `registration_number` (`registration_number`),
  KEY `idx_registration_number` (`registration_number`),
  KEY `idx_contact_email` (`contact_email`),
  KEY `idx_payment_status` (`payment_status`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_registrations_payment_status` (`payment_status`),
  KEY `idx_registrations_delegate_type` (`delegate_type`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `registrations` (5 rows)
INSERT INTO `registrations` (`id`, `registration_number`, `delegate_type`, `delegate_count`, `has_standard_table`, `has_double_table`, `contact_salutation`, `contact_full_name`, `contact_badge_name`, `contact_designation`, `contact_department`, `contact_email`, `contact_mobile`, `university_name`, `country`, `payment_method`, `payment_status`, `payment_reference`, `total_amount`, `payment_deadline`, `admin_notes`, `ip_address`, `user_agent`, `created_at`, `updated_at`) VALUES ('1', 'XC25-MXFAY9', 'standard', '2', '0', '0', 'Mr', 'Ruwan Chinthaka', '', 'CTO', 'Management', 'mcruwan@gmail.com', '+60169835703', 'AppliedHE', 'Malaysia', 'gateway', 'paid', NULL, '88900.00', '2025-08-20', 'Internal', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 20:54:46', '2025-08-21 10:29:14');
INSERT INTO `registrations` (`id`, `registration_number`, `delegate_type`, `delegate_count`, `has_standard_table`, `has_double_table`, `contact_salutation`, `contact_full_name`, `contact_badge_name`, `contact_designation`, `contact_department`, `contact_email`, `contact_mobile`, `university_name`, `country`, `payment_method`, `payment_status`, `payment_reference`, `total_amount`, `payment_deadline`, `admin_notes`, `ip_address`, `user_agent`, `created_at`, `updated_at`) VALUES ('3', 'XC25-292253', 'standard', '4', '0', '0', 'Mr', 'Suba Raj', '', 'Professor test', 'HRM', 'suba@dyits.com.my', '+601116721369', 'DYITS', 'Argentina', 'tt', 'paid', NULL, '3050.00', '2025-08-28', 'dfsdfsdfsdgsfdgsfdg', '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 10:44:30', '2025-08-21 10:58:15');
INSERT INTO `registrations` (`id`, `registration_number`, `delegate_type`, `delegate_count`, `has_standard_table`, `has_double_table`, `contact_salutation`, `contact_full_name`, `contact_badge_name`, `contact_designation`, `contact_department`, `contact_email`, `contact_mobile`, `university_name`, `country`, `payment_method`, `payment_status`, `payment_reference`, `total_amount`, `payment_deadline`, `admin_notes`, `ip_address`, `user_agent`, `created_at`, `updated_at`) VALUES ('4', 'XC25-FEUGPF', 'standard', '1', '0', '0', 'Mr', 'Suba Raj', '', 'Manager', 'Department of Information Technology', 'suba@dyits.com.my', '+601116721369', 'DYITS', 'Austria', 'gateway', 'failed', NULL, '10100.00', '2025-08-21', NULL, '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 10:47:27', '2025-08-21 10:52:17');
INSERT INTO `registrations` (`id`, `registration_number`, `delegate_type`, `delegate_count`, `has_standard_table`, `has_double_table`, `contact_salutation`, `contact_full_name`, `contact_badge_name`, `contact_designation`, `contact_department`, `contact_email`, `contact_mobile`, `university_name`, `country`, `payment_method`, `payment_status`, `payment_reference`, `total_amount`, `payment_deadline`, `admin_notes`, `ip_address`, `user_agent`, `created_at`, `updated_at`) VALUES ('5', 'XC25-TPBO64', 'standard', '1', '0', '0', 'Mr', 'Suba Raj', '', 'Manager', 'Department of Information Technology', 'suba@dyits.com.my', '+601116721369', 'DYITS', 'Belgium', 'tt', 'paid', NULL, '43600.00', '2025-08-28', NULL, '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 11:00:55', '2025-08-21 11:01:43');
INSERT INTO `registrations` (`id`, `registration_number`, `delegate_type`, `delegate_count`, `has_standard_table`, `has_double_table`, `contact_salutation`, `contact_full_name`, `contact_badge_name`, `contact_designation`, `contact_department`, `contact_email`, `contact_mobile`, `university_name`, `country`, `payment_method`, `payment_status`, `payment_reference`, `total_amount`, `payment_deadline`, `admin_notes`, `ip_address`, `user_agent`, `created_at`, `updated_at`) VALUES ('6', 'XC25-FLA262', 'standard', '1', '0', '0', 'Mrs', 'sdf', '', 'dsfsdf', 'sdfsdf', 'ds@dd.om', '+65656565656', 'sdf', 'Bahamas', 'gateway', 'failed', NULL, '11600.00', '2025-08-22', NULL, '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 09:15:25', '2025-08-22 12:25:51');

-- Table structure for table `registration_products`
DROP TABLE IF EXISTS `registration_products`;
CREATE TABLE `registration_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `registration_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `unit_price` decimal(10,2) NOT NULL,
  `total_price` decimal(10,2) NOT NULL,
  `pricing_tier` varchar(50) DEFAULT NULL,
  `stock_status` enum('reserved','confirmed','cancelled','refunded') DEFAULT 'reserved',
  `reserved_at` timestamp NULL DEFAULT current_timestamp(),
  `confirmed_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `product_metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_registration` (`registration_id`),
  KEY `idx_product` (`product_id`),
  KEY `idx_stock_status` (`stock_status`),
  KEY `idx_expires` (`expires_at`),
  CONSTRAINT `registration_products_ibfk_1` FOREIGN KEY (`registration_id`) REFERENCES `registrations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `registration_products_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `registration_products` (31 rows)
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('1', '1', '27', '2', '550.00', '1100.00', 'Early Bird', 'confirmed', '2025-08-20 20:54:46', '2025-08-20 20:54:46', NULL, NULL, '2025-08-20 20:54:46', '2025-08-22 20:42:56');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('2', '1', '3', '2', '550.00', '1100.00', NULL, 'confirmed', '2025-08-20 20:54:46', '2025-08-20 20:54:46', NULL, NULL, '2025-08-20 20:54:46', '2025-08-20 20:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('3', '1', '4', '2', '850.00', '1700.00', NULL, 'confirmed', '2025-08-20 20:54:46', '2025-08-20 20:54:46', NULL, NULL, '2025-08-20 20:54:46', '2025-08-20 20:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('4', '1', '7', '2', '10000.00', '20000.00', NULL, 'confirmed', '2025-08-20 20:54:46', '2025-08-20 20:54:46', NULL, NULL, '2025-08-20 20:54:46', '2025-08-20 20:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('5', '1', '11', '2', '8000.00', '16000.00', NULL, 'confirmed', '2025-08-20 20:54:46', '2025-08-20 20:54:46', NULL, NULL, '2025-08-20 20:54:46', '2025-08-20 20:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('6', '1', '12', '2', '5500.00', '11000.00', NULL, 'confirmed', '2025-08-20 20:54:46', '2025-08-20 20:54:46', NULL, NULL, '2025-08-20 20:54:46', '2025-08-20 20:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('7', '1', '13', '2', '5500.00', '11000.00', NULL, 'confirmed', '2025-08-20 20:54:46', '2025-08-20 20:54:46', NULL, NULL, '2025-08-20 20:54:46', '2025-08-20 20:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('8', '1', '8', '2', '500.00', '1000.00', NULL, 'confirmed', '2025-08-20 20:54:46', '2025-08-20 20:54:46', NULL, NULL, '2025-08-20 20:54:46', '2025-08-20 20:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('9', '1', '14', '2', '1000.00', '2000.00', NULL, 'confirmed', '2025-08-20 20:54:46', '2025-08-20 20:54:46', NULL, NULL, '2025-08-20 20:54:46', '2025-08-20 20:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('10', '1', '15', '2', '1000.00', '2000.00', NULL, 'confirmed', '2025-08-20 20:54:46', '2025-08-20 20:54:46', NULL, NULL, '2025-08-20 20:54:46', '2025-08-20 20:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('11', '1', '16', '2', '11000.00', '22000.00', NULL, 'confirmed', '2025-08-20 20:54:46', '2025-08-20 20:54:46', NULL, NULL, '2025-08-20 20:54:46', '2025-08-20 20:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('23', '3', '27', '4', '550.00', '2200.00', 'Early Bird', 'confirmed', '2025-08-21 10:44:30', '2025-08-21 10:44:30', NULL, NULL, '2025-08-21 10:44:30', '2025-08-22 20:42:56');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('24', '3', '4', '1', '850.00', '850.00', NULL, 'confirmed', '2025-08-21 10:44:30', '2025-08-21 10:44:30', NULL, NULL, '2025-08-21 10:44:30', '2025-08-21 10:44:30');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('25', '4', '27', '1', '550.00', '550.00', 'Early Bird', 'confirmed', '2025-08-21 10:47:27', '2025-08-21 10:47:27', NULL, NULL, '2025-08-21 10:47:27', '2025-08-22 20:42:56');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('26', '4', '3', '1', '550.00', '550.00', NULL, 'confirmed', '2025-08-21 10:47:27', '2025-08-21 10:47:27', NULL, NULL, '2025-08-21 10:47:27', '2025-08-21 10:47:27');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('27', '4', '11', '1', '8000.00', '8000.00', NULL, 'confirmed', '2025-08-21 10:47:27', '2025-08-21 10:47:27', NULL, NULL, '2025-08-21 10:47:27', '2025-08-21 10:47:27');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('28', '4', '15', '1', '1000.00', '1000.00', NULL, 'confirmed', '2025-08-21 10:47:27', '2025-08-21 10:47:27', NULL, NULL, '2025-08-21 10:47:27', '2025-08-21 10:47:27');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('29', '5', '27', '1', '550.00', '550.00', 'Early Bird', 'confirmed', '2025-08-21 11:00:55', '2025-08-21 11:00:55', NULL, NULL, '2025-08-21 11:00:55', '2025-08-22 20:42:56');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('30', '5', '3', '1', '550.00', '550.00', NULL, 'confirmed', '2025-08-21 11:00:55', '2025-08-21 11:00:55', NULL, NULL, '2025-08-21 11:00:55', '2025-08-21 11:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('31', '5', '7', '1', '10000.00', '10000.00', NULL, 'confirmed', '2025-08-21 11:00:55', '2025-08-21 11:00:55', NULL, NULL, '2025-08-21 11:00:55', '2025-08-21 11:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('32', '5', '11', '1', '8000.00', '8000.00', NULL, 'confirmed', '2025-08-21 11:00:55', '2025-08-21 11:00:55', NULL, NULL, '2025-08-21 11:00:55', '2025-08-21 11:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('33', '5', '12', '1', '5500.00', '5500.00', NULL, 'confirmed', '2025-08-21 11:00:55', '2025-08-21 11:00:55', NULL, NULL, '2025-08-21 11:00:55', '2025-08-21 11:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('34', '5', '13', '1', '5500.00', '5500.00', NULL, 'confirmed', '2025-08-21 11:00:55', '2025-08-21 11:00:55', NULL, NULL, '2025-08-21 11:00:55', '2025-08-21 11:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('35', '5', '8', '1', '500.00', '500.00', NULL, 'confirmed', '2025-08-21 11:00:55', '2025-08-21 11:00:55', NULL, NULL, '2025-08-21 11:00:55', '2025-08-21 11:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('36', '5', '14', '1', '1000.00', '1000.00', NULL, 'confirmed', '2025-08-21 11:00:55', '2025-08-21 11:00:55', NULL, NULL, '2025-08-21 11:00:55', '2025-08-21 11:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('37', '5', '15', '1', '1000.00', '1000.00', NULL, 'confirmed', '2025-08-21 11:00:55', '2025-08-21 11:00:55', NULL, NULL, '2025-08-21 11:00:55', '2025-08-21 11:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('38', '5', '16', '1', '11000.00', '11000.00', NULL, 'confirmed', '2025-08-21 11:00:55', '2025-08-21 11:00:55', NULL, NULL, '2025-08-21 11:00:55', '2025-08-21 11:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('39', '6', '27', '1', '550.00', '550.00', 'Early Bird', 'confirmed', '2025-08-22 09:15:25', '2025-08-22 09:15:25', NULL, NULL, '2025-08-22 09:15:25', '2025-08-22 20:42:56');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('40', '6', '3', '1', '550.00', '550.00', NULL, 'confirmed', '2025-08-22 09:15:25', '2025-08-22 09:15:25', NULL, NULL, '2025-08-22 09:15:25', '2025-08-22 09:15:25');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('41', '6', '7', '1', '10000.00', '10000.00', NULL, 'confirmed', '2025-08-22 09:15:25', '2025-08-22 09:15:25', NULL, NULL, '2025-08-22 09:15:25', '2025-08-22 09:15:25');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('42', '6', '8', '1', '500.00', '500.00', NULL, 'confirmed', '2025-08-22 09:15:25', '2025-08-22 09:15:25', NULL, NULL, '2025-08-22 09:15:25', '2025-08-22 09:15:25');

-- Table structure for table `delegates`
DROP TABLE IF EXISTS `delegates`;
CREATE TABLE `delegates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `registration_id` int(11) NOT NULL,
  `delegate_number` int(11) NOT NULL,
  `full_name` varchar(255) NOT NULL,
  `badge_name` varchar(100) NOT NULL,
  `designation` varchar(255) NOT NULL,
  `dietary_requirements` varchar(100) DEFAULT NULL,
  `special_assistance` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_registration_id` (`registration_id`),
  KEY `idx_delegate_number` (`delegate_number`),
  CONSTRAINT `delegates_ibfk_1` FOREIGN KEY (`registration_id`) REFERENCES `registrations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `delegates` (9 rows)
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('1', '1', '1', 'Ruwan Chinthaka', 'Ruwan', 'CTO', 'non-veg-(chicken)', 'No', '2025-08-20 20:54:46', '2025-08-20 20:54:46');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('2', '1', '2', 'Roshel', 'Doe', 'Manager', '', '', '2025-08-20 20:54:46', '2025-08-20 20:54:46');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('5', '3', '1', 'Suba Raj', 'Suba', 'Professor', 'non-veg-(chicken)', '', '2025-08-21 10:44:30', '2025-08-21 10:44:30');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('6', '3', '2', 'Suba - Deg 1', 'Deg 1', 'Professor', 'non-veg-(chicken)', '', '2025-08-21 10:44:30', '2025-08-21 10:44:30');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('7', '3', '3', 'Suba - Deg 2', 'Deg 2', 'Student', 'non-veg-(fish)', '', '2025-08-21 10:44:30', '2025-08-21 10:44:30');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('8', '3', '4', 'Suba - Deg 3', 'Deg 3', 'Student', 'veg', '', '2025-08-21 10:44:30', '2025-08-21 10:44:30');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('9', '4', '1', 'Raj Suba', 'Suba', 'Manager', '', '', '2025-08-21 10:47:27', '2025-08-21 10:47:27');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('10', '5', '1', 'Suba Raj', 'Suba', 'Manager', '', '', '2025-08-21 11:00:55', '2025-08-21 11:00:55');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('11', '6', '1', 's', 'sfdsf', 's', '', '', '2025-08-22 09:15:25', '2025-08-22 09:15:25');

-- Table structure for table `admin_activity_log`
DROP TABLE IF EXISTS `admin_activity_log`;
CREATE TABLE `admin_activity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_user_id` int(11) NOT NULL,
  `action` varchar(100) NOT NULL,
  `target_type` varchar(50) DEFAULT NULL,
  `target_id` int(11) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_admin_user_id` (`admin_user_id`),
  KEY `idx_action` (`action`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `admin_activity_log_ibfk_1` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=226 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `admin_activity_log` (59 rows)
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('7', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 10:52:40');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('8', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 10:52:43');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('45', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 13:00:38');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('46', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 13:00:40');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('64', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 15:46:00');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('65', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 15:46:11');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('68', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 22:43:12');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('69', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 13:13:34');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('84', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 15:35:17');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('85', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 15:35:33');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('86', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 18:43:52');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('87', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 18:43:53');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('103', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 20:45:11');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('104', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 20:45:13');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('119', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 22:46:19');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('120', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 22:46:30');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('127', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 00:48:53');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('128', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 00:48:55');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('129', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 06:58:30');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('130', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 09:26:10');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('131', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 09:26:18');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('132', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 11:28:28');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('133', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 11:28:37');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('146', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 13:48:12');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('147', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 13:53:58');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('182', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 16:01:59');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('183', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 16:02:00');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('184', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 20:17:41');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('185', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 20:17:51');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('192', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 22:42:11');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('193', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 22:42:12');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('194', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 13:22:50');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('195', '1', 'SYSTEM_MIGRATION', 'admin_settings', NULL, 'Removed Early Bird Pricing feature', '127.0.0.1', NULL, '2025-08-20 14:20:13');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('196', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 15:37:09');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('197', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 15:37:11');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('198', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 17:37:30');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('199', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 17:37:32');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('200', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 19:02:31');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('201', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 20:35:13');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('202', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 21:46:08');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('203', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 23:55:15');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('204', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 00:40:49');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('205', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 09:43:29');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('206', '2', 'login', NULL, NULL, 'User logged in', '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 10:47:54');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('207', '3', 'login', NULL, NULL, 'User logged in', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 14:37:17');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('208', '3', 'login', NULL, NULL, 'User logged in', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 16:51:52');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('209', '4', 'login', NULL, NULL, 'User logged in', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 17:50:40');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('210', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 20:19:00');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('211', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 09:14:53');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('212', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 11:32:39');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('213', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 11:39:02');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('214', '3', 'login', NULL, NULL, 'User logged in', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 12:48:15');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('215', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 13:12:37');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('216', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 15:20:53');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('217', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 17:10:25');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('218', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 17:10:27');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('219', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 20:01:01');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('220', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 20:01:03');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('225', '1', 'SYSTEM_MIGRATION', 'products', NULL, 'Multiple Delegate Types Migration (multiple_delegate_types_2025_08_22_14_42_56): Created 6 new delegate type products and migrated existing registration data', '127.0.0.1', NULL, '2025-08-22 20:42:56');


COMMIT;
