-- Backup of delegates table before department field migration
-- Created: 2025-10-24 05:45:49
-- Total records: 17

-- This backup can be used to restore data if needed

CREATE TABLE `delegates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `registration_id` int NOT NULL,
  `delegate_number` int NOT NULL,
  `full_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `badge_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `designation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Optional email for individual delegate communication',
  `dietary_requirements` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `special_assistance` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_registration_id` (`registration_id`),
  KEY `idx_delegate_number` (`delegate_number`),
  KEY `idx_delegate_email` (`email`),
  CONSTRAINT `delegates_ibfk_1` FOREIGN KEY (`registration_id`) REFERENCES `registrations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data backup
INSERT INTO delegates VALUES ('32', '25', '1', 'SONNY SORIANO', 'DR.', 'DIRECTOR', NULL, '', 'MOBILITY', '2025-08-31 22:06:43', '2025-08-31 22:06:43');
INSERT INTO delegates VALUES ('33', '26', '1', 'Maruja Padre Juan', 'Sr. Maru', 'Director', NULL, '', '', '2025-09-02 05:28:02', '2025-09-02 05:28:02');
INSERT INTO delegates VALUES ('34', '26', '2', 'Adrian Raymund Fernandez', 'Adrian', 'Program Officer', NULL, '', '', '2025-09-02 05:28:02', '2025-09-02 05:28:02');
INSERT INTO delegates VALUES ('35', '27', '1', 'Maruja Padre Juan', 'Sr. Maru', 'Director', NULL, '', '', '2025-09-02 05:33:04', '2025-09-02 05:33:04');
INSERT INTO delegates VALUES ('36', '27', '2', 'Adrian Raymund Fernandez', 'Adrian', 'Program Officer', NULL, '', '', '2025-09-02 05:33:04', '2025-09-02 05:33:04');
INSERT INTO delegates VALUES ('37', '28', '1', 'Dr. Adam Lawrence Fenech', 'Dr. Fenech', 'Provost', NULL, '', 'N/A', '2025-09-02 10:14:51', '2025-09-02 10:14:51');
INSERT INTO delegates VALUES ('42', '33', '1', 'Sayed Abbas Ahmed', 'Sayed', 'Professor', NULL, '', 'NO', '2025-09-23 10:02:19', '2025-09-23 10:02:19');
INSERT INTO delegates VALUES ('47', '36', '1', 'Lim Hock Ann', 'Lim', 'Director', NULL, '', '', '2025-10-06 01:12:15', '2025-10-06 01:12:15');
INSERT INTO delegates VALUES ('49', '38', '1', 'NICANOR C. SANTOS', 'DOC NIKKO', 'DIRECTOR', NULL, '', '', '2025-10-14 02:45:23', '2025-10-14 02:45:23');
INSERT INTO delegates VALUES ('50', '39', '1', 'Shameem Rafik Galea', 'Shameem Galea', 'Professor', NULL, 'non-veg-(fish)', '', '2025-10-15 04:05:04', '2025-10-15 04:05:04');
INSERT INTO delegates VALUES ('51', '40', '1', 'IRWAN TRINUGROHO', 'IRWAN', 'Professor', NULL, '', '', '2025-10-15 10:00:53', '2025-10-15 10:00:53');
INSERT INTO delegates VALUES ('52', '41', '1', 'IRWAN TRINUGROHO', 'IRWAN', 'Professor', NULL, '', '', '2025-10-15 10:02:23', '2025-10-15 10:02:23');
INSERT INTO delegates VALUES ('53', '42', '1', 'IRWAN TRINUGROHO', 'IRWAN', 'Professor', NULL, '', '', '2025-10-15 10:03:07', '2025-10-15 10:03:07');
INSERT INTO delegates VALUES ('62', '51', '1', 'Irwan Trinugroho', 'Irwan', 'Vice Rector', 'irwan_t@staff.uns.ac.id', '', '', '2025-10-16 05:56:14', '2025-10-16 05:56:14');
INSERT INTO delegates VALUES ('63', '51', '2', 'Hermawan Rudhianto', 'Hermawan', 'Manager of Planning & Development', 'rudhi.ant@staff.uns.ac.id', '', '', '2025-10-16 05:56:14', '2025-10-16 05:56:14');
INSERT INTO delegates VALUES ('64', '52', '1', 'Richard M. Walker', 'Richard', 'Professor', 'richardwalker@ln.edu.hk', '', 'None', '2025-10-16 09:46:49', '2025-10-16 09:46:49');
INSERT INTO delegates VALUES ('67', '55', '1', 'Roshel D App.le', 'Roshel App.le', 'Student ', 'roshel@dyits.com.my', 'non-veg-(chicken)', 'NON', '2025-10-24 02:16:40', '2025-10-24 02:16:40');
