<?php
// Admin footer component
$currentYear = date('Y');
?>

<footer class="admin-footer">
    <div class="footer-content">
        <div class="footer-main">
            <div class="footer-brand">
                <span class="copyright">&copy; <?php echo $currentYear; ?> AppliedHE Xchange. All rights reserved.</span>
            </div>
            <div class="footer-info">
                <span class="version">v1.0</span>
                <span class="separator">•</span>
                <span class="developer">Developed by Axis Wise Solutions</span>
            </div>
        </div>
    </div>
</footer>

<style>
.admin-footer {
    background: #1e293b;
    border-top: 1px solid #334155;
    margin-top: 3rem;
    font-family: 'Poppins', sans-serif;
}

.footer-content {
    max-width: 1200px;
    margin: 0 auto;
    padding: 2rem;
}

.footer-main {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 2rem;
}

.footer-brand {
    display: flex;
    align-items: center;
}

.copyright {
    color: #f8fafc;
    font-size: 0.95rem;
    font-weight: 500;
}

.footer-info {
    display: flex;
    align-items: center;
    gap: 1rem;
    color: #94a3b8;
    font-size: 0.85rem;
}

.version {
    color: #cbd5e1;
    font-weight: 500;
}

.separator {
    color: #64748b;
    font-weight: 300;
}

.developer {
    color: #94a3b8;
    font-style: italic;
}

/* Responsive Design */
@media (max-width: 768px) {
    .footer-content {
        padding: 1.5rem;
    }
    
    .footer-main {
        flex-direction: column;
        align-items: flex-start;
        gap: 1.5rem;
    }
    
    .footer-info {
        align-items: flex-start;
        flex-direction: column;
        gap: 0.5rem;
    }
    
    .separator {
        display: none;
    }
}

@media (max-width: 480px) {
    .footer-content {
        padding: 1rem;
    }
}
</style>

</body>
</html>
