# Contribution and Development Guidelines

This document outlines the standard structure for all new development in the Xchange_Admin project. By following these guidelines, we can progressively improve the codebase and ensure it remains organized, scalable, and easy to maintain.

**The Golden Rule:** All **new** files and features **must** follow this structure. Do not move existing legacy files unless you are specifically refactoring that part of the application.

---

## 📂 New Directory Structure

Here is the target directory structure for the application. Please place all new files in the appropriate location.

### 🌐 Public-Facing Files (`/public`)

This directory contains all assets that are directly accessible via the web browser.

-   **`/public/assets/css/`**: All new CSS files.
-   **`/public/assets/js/`**: All new public-facing JavaScript files.
-   **`/public/assets/images/`**: All new images, icons, and favicons.

### ⚙️ Core Application Logic (`/app`)

This directory contains the core business logic of the application. These files should **not** be publicly accessible.

-   **`/app/config/`**: All new configuration files (e.g., database connections, API keys, constants).
-   **`/app/helpers/`**: All new helper functions (e.g., date formatters, URL generators, `logo_helper.php`).
-   **`/app/services/`**: All new service classes that interact with external APIs or perform specific business tasks (e.g., `EmailService`, `StripeWebhookService`).

### 🖥️ Views and Templates (`/views`)

This directory contains the HTML and PHP template files responsible for rendering the UI.

-   **`/views/`**: All new primary view files (e.g., `registration_form.php`, `payment_success.php`).
-   **`/views/partials/`**: Reusable template components (e.g., `header.php`, `footer.php`, `sidebar.php`).

### 🔒 Admin Section (`/admin`)

The admin area is a self-contained application and follows a similar structure.

-   **`/admin/assets/css/`**: All new admin-specific CSS files.
-   **`/admin/assets/js/`**: All new admin-specific JavaScript files.
-   **`/admin/views/`**: New admin-facing view files (e.g., `dashboard.php`, `user_list.php`).
-   **`/admin/views/partials/`**: Reusable admin template components.

---

## ✅ Example Scenarios

#### Scenario 1: Adding a new public stylesheet.
-   **File:** `new-feature.css`
-   **Location:** `/public/assets/css/new-feature.css`

#### Scenario 2: Creating a new helper function to calculate prices.
-   **File:** `pricing_helper.php`
-   **Location:** `/app/helpers/pricing_helper.php`

#### Scenario 3: Adding a new admin dashboard panel.
-   **Logic File:** `admin/features/new_dashboard_panel.php`
-   **View File:** `admin/views/new_dashboard_panel_view.php`

---

By adhering to this structure for all new development, we will gradually and safely modernize the codebase.
