<?php
require 'db_config.php';

try {
    $pdo = getDBConnection();
    
    echo "🔍 Verifying Badge System Database Setup...\n\n";
    
    // Check for badge tables
    $tables = $pdo->query("SHOW TABLES LIKE 'badge%'")->fetchAll(PDO::FETCH_COLUMN);
    
    echo "📊 Badge Tables:\n";
    foreach ($tables as $table) {
        echo "   ✅ {$table}\n";
    }
    
    // Check badge_settings
    echo "\n⚙️ Badge Settings:\n";
    $settings = $pdo->query("SELECT COUNT(*) FROM badge_settings")->fetchColumn();
    echo "   Found {$settings} settings\n";
    
    if ($settings > 0) {
        $sample_settings = $pdo->query("SELECT setting_key, setting_value FROM badge_settings LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
        echo "\n   Sample Settings:\n";
        foreach ($sample_settings as $setting) {
            $value = strlen($setting['setting_value']) > 30 ? substr($setting['setting_value'], 0, 30) . '...' : $setting['setting_value'];
            echo "   - {$setting['setting_key']}: {$value}\n";
        }
    }
    
    // Check badge_generation_log
    echo "\n📝 Badge Generation Log:\n";
    $log_count = $pdo->query("SELECT COUNT(*) FROM badge_generation_log")->fetchColumn();
    echo "   {$log_count} generation records\n";
    
    // Check directories
    echo "\n📁 Upload Directories:\n";
    $logos_dir = __DIR__ . '/uploads/badges/logos';
    $generated_dir = __DIR__ . '/uploads/badges/generated';
    
    echo "   " . (is_dir($logos_dir) ? "✅" : "❌") . " uploads/badges/logos/\n";
    echo "   " . (is_dir($generated_dir) ? "✅" : "❌") . " uploads/badges/generated/\n";
    
    echo "\n✅ Badge System Database Setup Complete!\n\n";
    echo "🚀 Next Steps:\n";
    echo "   1. Go to: http://localhost/Xchange_Admin/admin/badges\n";
    echo "   2. Click 'Badge Settings' to upload logos\n";
    echo "   3. Start generating badges!\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    exit(1);
}
?>


