-- XChange Registration Database Setup (Database and User Only)
-- Run this in phpMyAdmin as root user to create the database and user
-- DO NOT run the table creation scripts yet

-- Create the database
CREATE DATABASE IF NOT EXISTS `xchange_reg` 
CHARACTER SET utf8mb4 
COLLATE utf8mb4_unicode_ci;

-- Create the database user (if it doesn't exist)
-- Note: You may need to adjust the host part based on your MySQL configuration
CREATE USER IF NOT EXISTS 'xchange_reg'@'localhost' IDENTIFIED BY 'yQd.SSUemECBiJA)';

-- Grant all privileges on the xchange_reg database to the user
GRANT ALL PRIVILEGES ON `xchange_reg`.* TO 'xchange_reg'@'localhost';

-- Flush privileges to ensure changes take effect
FLUSH PRIVILEGES;

-- Verify the database was created
SHOW DATABASES LIKE 'xchange_reg';

-- Verify the user was created
SELECT User, Host FROM mysql.user WHERE User = 'xchange_reg';
