<?php
/**
 * Migration Script: Add Badge Print Tracking
 * Run this once to add print tracking columns to badge_generation_log table
 */

require_once 'db_config.php';

echo "🔧 Badge Print Tracking Migration\n";
echo "==================================\n\n";

try {
    $pdo = getDBConnection();
    
    echo "📊 Adding print tracking columns to badge_generation_log table...\n";
    
    // Check if columns already exist
    $check = $pdo->query("SHOW COLUMNS FROM badge_generation_log LIKE 'is_printed'");
    if ($check->rowCount() > 0) {
        echo "   ⚠️  Columns already exist. Skipping migration.\n";
        exit(0);
    }
    
    // Add the columns
    $sql = "
        ALTER TABLE badge_generation_log
        ADD COLUMN is_printed BOOLEAN DEFAULT FALSE COMMENT 'Whether badge has been physically printed',
        ADD COLUMN printed_at TIMESTAMP NULL COMMENT 'When the badge was marked as printed',
        ADD COLUMN printed_by INT NULL COMMENT 'Admin user who marked the badge as printed',
        ADD INDEX idx_is_printed (is_printed),
        ADD INDEX idx_printed_at (printed_at)
    ";
    
    $pdo->exec($sql);
    
    echo "   ✅ Successfully added columns:\n";
    echo "      - is_printed (BOOLEAN)\n";
    echo "      - printed_at (TIMESTAMP)\n";
    echo "      - printed_by (INT)\n";
    echo "   ✅ Added indexes for performance\n\n";
    
    echo "🎉 Migration completed successfully!\n";
    echo "\n";
    echo "Next steps:\n";
    echo "1. Go to admin/badges.php\n";
    echo "2. You'll see new 'Print Status' column and filter\n";
    echo "3. Use the print tracking buttons to mark badges as printed\n";
    echo "\n";
    echo "📖 See BADGE_PRINT_TRACKING_FEATURE.md for full documentation\n";
    
} catch (PDOException $e) {
    echo "❌ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    exit(1);
}

