<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registration - AppliedHE Xchange 2025</title>
    <meta name="description" content="Register for AppliedHE Xchange 2025 • 27–28 November 2025 • Sunway University, Malaysia">
    <?php include 'includes/favicon.php'; ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="styles.css">
    <link rel="stylesheet" href="css/pricing-tiers.css">
    <script src="https://js.stripe.com/v3/"></script>
</head>
<body>
    <!-- Registration Hero -->
    <section class="section hero-section" style="background:#fff;border-bottom:1px solid var(--slate-200)">
        <div class="container">
            <div class="text-center mb-6">
                <div class="overline">Event Registration</div>
                <h1 class="text-4xl">AppliedHE Xchange 2025</h1>
                <p class="kicker mt-3">27–28 November 2025 • Sunway University, Malaysia</p>
            </div>
            
            <!-- Progress Indicator -->
            <div class="progress-indicator">
                <div class="progress-step active" data-step="1">
                    <div class="step-number">1</div>
                    <div class="step-label">Select Passes</div>
                </div>
                <div class="progress-step" data-step="2">
                    <div class="step-number">2</div>
                    <div class="step-label">Delegate Details</div>
                </div>
                <div class="progress-step" data-step="3">
                    <div class="step-number">3</div>
                    <div class="step-label">Contact Info</div>
                </div>
                <div class="progress-step" data-step="4">
                    <div class="step-number">4</div>
                    <div class="step-label">Review</div>
                </div>
                <div class="progress-step" data-step="5">
                    <div class="step-number">5</div>
                    <div class="step-label">Payment</div>
                </div>
            </div>
        </div>
    </section>

    <!-- Registration Form -->
    <section class="section">
        <div class="container">
            <form id="registrationForm" class="registration-form" novalidate>
                
                <!-- Step 1: Pass Selection -->
                <div class="form-step active" id="step1">
                    <div class="form-step-header">
                        <h2 class="text-2xl fw-800">Registration Options</h2>
                        <p class="muted mt-2">Select from the available registration options below</p>
                    </div>

                    <div class="grid grid-2" style="gap: 32px;">
                        <!-- Delegate Passes -->
                        <div class="pass-section">
                            <div class="card delegate-highlight">
                                <div class="card-header">
                                    <h3 class="text-xl">Conference Registration</h3>
                                    <div class="highlight-badge">Standard</div>
                                </div>
                                <p class="muted mt-1"></p>
                                
                                <div class="pricing-options mt-4">
                                    <div class="pricing-option" id="earlyBirdOption">
                                        <input type="radio" id="earlyBird" name="delegateType" value="earlyBird" checked>
                                        <label for="earlyBird" class="pricing-label">
                                            <div class="pricing-details">
                                                <strong>Early Bird</strong>
                                                <span class="price" id="earlyBirdPrice"></span>
                                            </div>
                                            <div class="pricing-note">
                                                <span>Until 31 Aug 2025</span>
                                                <div class="countdown-timer" id="countdownTimer">
                                                    <span class="timer-label">Time remaining:</span>
                                                    <span class="timer-display" id="timerDisplay">Loading...</span>
                                                </div>
                                            </div>
                                        </label>
                                    </div>
                                    <div class="pricing-option" id="standardOption">
                                        <input type="radio" id="standard" name="delegateType" value="standard" disabled>
                                        <label for="standard" class="pricing-label disabled">
                                            <div class="pricing-details">
                                                <strong>Standard</strong>
                                                <span class="price" id="standardPrice"></span>
                                            </div>
                                            <div class="pricing-note">Available from 1 Sep 2025</div>
                                        </label>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <!-- Table-top Presentations -->
                        <div class="pass-section">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="text-xl">Exhibition Space</h3>
                                    <span class="optional-badge">Add-on</span>
                                </div>
                                <p class="muted mt-1"></p>
                                
                                <div class="table-options mt-4">
                                    <!-- Table options will be dynamically rendered here -->
                                </div>

                            </div>
                        </div>
                    </div>

                    <!-- Second row for Sponsorship and Other Sponsorship -->
                    <div class="grid grid-2" style="margin-top: 48px; gap: 32px;">
                        <!-- Sponsorship -->
                        <div class="pass-section">
                            <div class="card collapsible-card">
                                <div class="card-header collapsible-header" onclick="toggleCard('sponsorship')">
                                    <div class="header-content">
                                        <h3 class="text-xl">Sponsorship</h3>
                                        <span class="optional-badge">Optional</span>
                                        <p class="muted mt-1">Select sponsorship options</p>
                                    </div>
                                    <div class="collapse-icon" id="sponsorship-icon">
                                        <span>▼</span>
                                    </div>
                                </div>
                                
                                <div class="collapsible-content" id="sponsorship-content" style="display: none;">
                                    
                                    <div class="sponsorship-options mt-4">
                                        <!-- Sponsorship options will be dynamically rendered here -->
                                    </div>

                                </div>
                            </div>
                        </div>

                        <!-- Other Sponsorship -->
                        <div class="pass-section">
                            <div class="card collapsible-card">
                                <div class="card-header collapsible-header" onclick="toggleCard('otherSponsorship')">
                                    <div class="header-content">
                                        <h3 class="text-xl">Other Sponsorship</h3>
                                        <span class="optional-badge">Optional</span>
                                        <p class="muted mt-1">Select additional sponsorship options</p>
                                    </div>
                                    <div class="collapse-icon" id="otherSponsorship-icon">
                                        <span>▼</span>
                                    </div>
                                </div>
                                
                                <div class="collapsible-content" id="otherSponsorship-content" style="display: none;">
                                    
                                    <div class="other-sponsorship-options mt-4">
                                        <!-- Other Sponsorship options will be dynamically rendered here -->
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Order Summary -->
                    <div class="order-summary mt-6">
                        <div class="card">
                            <h3 class="text-lg">Order Summary</h3>
                            <div class="summary-content mt-3">
                                <div class="summary-line" id="delegateSummary">
                                    <span></span>
                                    <span class="price"></span>
                                </div>
                                <div class="summary-line" id="tableSummary" style="display:none">
                                    <span></span>
                                    <span class="price"></span>
                                </div>
                                <div class="summary-line" id="sponsorshipSummary" style="display:none">
                                    <span></span>
                                    <span class="price"></span>
                                </div>
                                <div class="summary-line" id="otherSponsorshipSummary" style="display:none">
                                    <span></span>
                                    <span class="price"></span>
                                </div>
                                <div class="summary-total">
                                    <span><strong>Total</strong></span>
                                    <span class="price"><strong id="totalPrice"></strong></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-actions mt-6">
                        <button type="button" class="btn btn-primary" onclick="nextStep()">Continue to Delegate Details →</button>
                    </div>
                </div>

                <!-- Step 2: Delegate Details -->
                <div class="form-step" id="step2">
                    <div class="form-step-header">
                        <h2 class="text-2xl fw-800">Delegate Details</h2>
                        <p class="muted mt-2">Please provide details for each delegate attending the event</p>
                    </div>

                    <div id="delegateDetailsContainer">
                        <!-- Delegate detail forms will be generated here -->
                    </div>

                    <div class="form-actions mt-6">
                        <button type="button" class="btn btn-ghost" onclick="prevStep()">← Back</button>
                        <button type="button" class="btn btn-primary" onclick="nextStep()">Continue to Contact Info →</button>
                    </div>
                </div>

                <!-- Step 3: Contact Information -->
                <div class="form-step" id="step3">
                    <div class="form-step-header">
                        <h2 class="text-2xl fw-800">University & Contact Information</h2>
                        <p class="muted mt-2">Primary contact and university details for this registration</p>
                    </div>

                    <div class="card">
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="salutation" class="form-label">Salutation *</label>
                                <select id="salutation" name="salutation" class="form-input" required>
                                    <option value="">Select...</option>
                                    <option value="Mr">Mr</option>
                                    <option value="Ms">Ms</option>
                                    <option value="Mrs">Mrs</option>
                                    <option value="Dr">Dr</option>
                                    <option value="Prof">Prof</option>
                                    <option value="Assoc Prof">Assoc Prof</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="contactFullName" class="form-label">Full Name *</label>
                                <input type="text" id="contactFullName" name="contactFullName" class="form-input" required>
                            </div>

                            <!-- Removed duplicate 'Preferred Short Name on Badge' field from Step 3 -->

                            <div class="form-group">
                                <label for="contactDesignation" class="form-label">Designation *</label>
                                <input type="text" id="contactDesignation" name="contactDesignation" class="form-input" placeholder="e.g., Director, Professor, Manager" required>
                            </div>

                            <div class="form-group">
                                <label for="department" class="form-label">Department *</label>
                                <input type="text" id="department" name="department" class="form-input" required>
                            </div>

                            <div class="form-group">
                                <label for="email" class="form-label">Email Address *</label>
                                <input type="email" id="email" name="email" class="form-input" required>
                            </div>

                            <div class="form-group">
                                <label for="mobile" class="form-label">Mobile Number *</label>
                                <input type="tel" id="mobile" name="mobile" class="form-input" 
                                       placeholder="+60 12 345 6789" 
                                       pattern="^\+?[1-9]\d{1,14}$"
                                       title="Please enter a valid international phone number (e.g., +60123456789)"
                                       required>
                            </div>

                            <div class="form-group">
                                <label for="university" class="form-label">University Name *</label>
                                <input type="text" id="university" name="university" class="form-input" required>
                            </div>

                            <div class="form-group">
                                <label for="country" class="form-label">Country *</label>
                                <select id="country" name="country" class="form-input" required>
                                    <option value="">Select Country...</option>
                                    <!-- Countries will be populated dynamically by JavaScript -->
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="form-actions mt-6">
                        <button type="button" class="btn btn-ghost" onclick="prevStep()">← Back</button>
                        <button type="button" class="btn btn-primary" onclick="nextStep()">Review Registration →</button>
                    </div>
                </div>

                <!-- Step 4: Review & Submit -->
                <div class="form-step" id="step4">
                    <div class="form-step-header">
                        <h2 class="text-2xl fw-800">Review Your Registration</h2>
                        <p class="muted mt-2">Please review all details before submitting your registration</p>
                    </div>

                    <div class="review-sections">
                        <!-- Pass Selection Review -->
                        <div class="card mb-4">
                            <h3 class="text-lg">Registration Summary</h3>
                            <div id="passReview" class="review-content mt-3">
                                <!-- Will be populated by JavaScript -->
                            </div>
                        </div>

                        <!-- Delegates Review -->
                        <div class="card mb-4">
                            <h3 class="text-lg">Delegates</h3>
                            <div id="delegatesReview" class="review-content mt-3">
                                <!-- Will be populated by JavaScript -->
                            </div>
                        </div>

                        <!-- Contact Review -->
                        <div class="card mb-4">
                            <h3 class="text-lg">Contact & University Information</h3>
                            <div id="contactReview" class="review-content mt-3">
                                <!-- Will be populated by JavaScript -->
                            </div>
                        </div>

                        <!-- Final Total -->
                        <div class="card total-card">
                            <div class="final-total">
                                <span class="text-xl fw-800">Total Amount</span>
                                <span class="text-xl fw-800" id="finalTotal"></span>
                            </div>
                        </div>
                    </div>

                    <div class="form-actions mt-6">
                        <button type="button" class="btn btn-ghost" onclick="prevStep()">← Back</button>
                        <button type="button" class="btn btn-primary" onclick="nextStep()">Continue to Payment →</button>
                    </div>
                </div>

                <!-- Step 5: Payment Options -->
                <div class="form-step" id="step5">
                    <div class="form-step-header">
                        <h2 class="text-2xl fw-800">Payment Options</h2>
                        <p class="muted mt-2">Choose your preferred payment method</p>
                    </div>

                    <!-- Payment Summary -->
                    <div class="card mb-6">
                        <div class="payment-summary">
                            <h3 class="text-lg">Payment Summary</h3>
                            <div class="summary-total mt-3">
                                <span class="text-xl fw-700">Total Amount</span>
                                <span class="text-xl fw-700" id="paymentTotal"></span>
                            </div>
                        </div>
                    </div>

                    <!-- Payment Methods -->
                    <div class="payment-methods">
                        <div class="payment-option">
                            <input type="radio" id="paymentGateway" name="paymentMethod" value="gateway" checked>
                            <label for="paymentGateway" class="payment-label">
                                <div class="payment-icon">💳</div>
                                <div class="payment-details">
                                    <strong>Online Payment</strong>
                                    <span class="payment-description">Pay securely with credit/debit card</span>
                                </div>
                                <div class="payment-badge recommended">Recommended</div>
                            </label>
                        </div>

                        <div class="payment-option">
                            <input type="radio" id="bankTransfer" name="paymentMethod" value="tt">
                            <label for="bankTransfer" class="payment-label">
                                <div class="payment-icon">🏦</div>
                                <div class="payment-details">
                                    <strong>Bank Transfer (TT)</strong>
                                    <span class="payment-description">Telegraphic Transfer to our bank account</span>
                                </div>
                            </label>
                        </div>
                    </div>

                    <div class="form-actions mt-6">
                        <button type="button" class="btn btn-ghost" onclick="prevStep()">← Back</button>
                        <button type="submit" class="btn btn-primary">Complete Registration</button>
                    </div>
                </div>

            </form>
        </div>
    </section>

    <!-- Payment Gateway Message -->
    <div id="gatewayMessage" class="success-overlay" style="display:none">
        <div class="success-content">
            <div class="payment-processing">
                <div class="spinner"></div>
                <h2 class="text-2xl fw-800 mt-4">Redirecting to Payment...</h2>
                <p class="mt-3">Please wait while we redirect you to our secure payment gateway.</p>
                <p class="text-sm muted mt-2">You will be redirected automatically in a few seconds.</p>
            </div>
        </div>
    </div>

    <!-- Bank Transfer Instructions -->
    <div id="bankTransferMessage" class="success-overlay" style="display:none">
        <div class="success-content bank-transfer-content">
            <div class="success-icon">🏦</div>
            <h2 class="text-2xl fw-800">Bank Transfer Instructions</h2>
            <p class="mt-3">Your registration has been recorded. Please complete payment using the bank details below:</p>
            
            <div class="bank-details mt-4">
                <div class="bank-detail-item">
                    <strong>Bank Name:</strong>
                    <span id="bankName">DBS Bank Ltd Singapore</span>
                </div>
                <div class="bank-detail-item">
                    <strong>Account Name:</strong>
                    <span id="accountName">AppliedHE Pte. Ltd.</span>
                </div>
                <div class="bank-detail-item">
                    <strong>Account Number:</strong>
                    <span id="accountNumber">015-905678-3</span>
                </div>
                <div class="bank-detail-item">
                    <strong>SWIFT Code:</strong>
                    <span id="swiftCode">DBSSSGSG</span>
                </div>
                <div class="bank-detail-item highlight">
                    <strong>Reference:</strong>
                    <span id="transferReference">XCHANGE2025-REG001</span>
                </div>
                <div class="bank-detail-item highlight">
                    <strong>Amount:</strong>
                    <span id="transferAmount"></span>
                </div>
            </div>

            <div class="transfer-notes mt-4">
                <h3 class="text-lg">Important Notes:</h3>
                <ul class="list text-sm">
                    <li>Please use the exact reference number shown above</li>
                    <li>Transfer must be completed within 7 days to secure your registration</li>
                    <li>You will receive a confirmation email once payment is received</li>
                    <li>For any payment queries, contact us at finance@appliedhe.com</li>
                </ul>
            </div>

            <div class="mt-6">
                <button type="button" class="btn btn-primary" onclick="returnToEventPage()">Return to Event Page</button>
                <button type="button" class="btn btn-ghost ml-3" onclick="window.print()">Print Instructions</button>
            </div>
        </div>
    </div>

    <!-- Success Message (Hidden by default) -->
    <div id="successMessage" class="success-overlay" style="display:none">
        <div class="success-content">
            <div class="success-icon">✓</div>
            <h2 class="text-2xl fw-800">Registration Submitted!</h2>
            <p class="mt-3">Thank you for registering for AppliedHE Xchange 2025. You will receive a confirmation email shortly with payment instructions and further details.</p>
            <div class="mt-4">
                <button type="button" class="btn btn-primary" onclick="returnToEventPage()">Return to Event Page</button>
            </div>
        </div>
    </div>

    <script src="registration.js"></script>
    <script>
        // Toggle collapsible cards (sync both sponsorship cards)
        function toggleCard(cardId) {
            const sponsorshipCards = ['sponsorship', 'otherSponsorship'];
            
            // Check current state of the clicked card
            const clickedContent = document.getElementById(cardId + '-content');
            const isCurrentlyHidden = clickedContent.style.display === 'none';
            
            // Apply the same state to both cards
            sponsorshipCards.forEach(id => {
                const content = document.getElementById(id + '-content');
                const icon = document.getElementById(id + '-icon');
                
                if (isCurrentlyHidden) {
                    // Open both cards
                    content.style.display = 'block';
                    content.classList.add('expanded');
                    icon.classList.add('expanded');
                    icon.querySelector('span').textContent = '▲';
                } else {
                    // Close both cards
                    content.style.display = 'none';
                    content.classList.remove('expanded');
                    icon.classList.remove('expanded');
                    icon.querySelector('span').textContent = '▼';
                }
            });
        }
    </script>

    <style>
        /* Form Actions Layout Fix */
        .form-actions {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 1rem;
        }
        
        /* When back button is hidden, keep Complete Registration on the right */
        .form-actions .btn-primary {
            margin-left: auto;
        }
        
        /* Print Styles - Fix duplicate pages */
        @media print {
            /* Hide everything except bank transfer modal */
            body > *:not(#bankTransferMessage) {
                display: none !important;
            }
            
            /* Reset body for clean print */
            body {
                margin: 0 !important;
                padding: 0 !important;
                background: white !important;
            }
            
            /* Position bank transfer content at top of page */
            #bankTransferMessage {
                position: static !important;
                background: white !important;
                padding: 0 !important;
                margin: 0 !important;
                width: 100% !important;
                height: auto !important;
                display: block !important;
                top: 0 !important;
                left: 0 !important;
            }
            
            .success-overlay {
                position: static !important;
                background: white !important;
                padding: 0 !important;
                margin: 0 !important;
                display: block !important;
            }
            
            .success-content {
                box-shadow: none !important;
                border-radius: 0 !important;
                max-width: 100% !important;
                width: 100% !important;
                margin: 0 !important;
                padding: 20px !important;
                position: static !important;
            }
            
            /* Hide buttons in print */
            .btn {
                display: none !important;
            }
            
            /* Ensure content starts at top of page */
            .bank-transfer-content {
                page-break-inside: avoid;
                margin-top: 0 !important;
                padding-top: 0 !important;
            }
            
            /* Remove any top spacing */
            .success-icon {
                margin-top: 0 !important;
            }
        }
        
        /* Recovery Modal Styles */
        .recovery-modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 10000;
            animation: fadeIn 0.3s ease;
        }
        
        .recovery-modal-content {
            background: white;
            padding: 2rem;
            border-radius: 12px;
            max-width: 500px;
            width: 90%;
            text-align: center;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            animation: slideUp 0.3s ease;
        }
        
        .recovery-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
        }
        
        .recovery-modal-content h3 {
            margin: 0 0 1rem 0;
            color: var(--slate-900);
            font-size: 1.5rem;
            font-weight: 700;
        }
        
        .recovery-modal-content p {
            margin: 0 0 1.5rem 0;
            color: var(--slate-600);
            line-height: 1.5;
        }
        
        .recovery-actions {
            display: flex;
            gap: 1rem;
            justify-content: center;
            flex-wrap: wrap;
        }
        
        .retry-message {
            margin-bottom: 2rem;
        }
        
        .retry-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
            padding-bottom: 0.5rem;
            border-bottom: 1px solid rgba(30, 64, 175, 0.2);
        }
        
        .retry-header strong {
            font-size: 1.1rem;
            color: #1e40af;
        }
        
        .retry-header small {
            color: #1e40af;
            opacity: 0.8;
        }
        
        .retry-details {
            display: grid;
            gap: 0.5rem;
        }
        
        .retry-detail-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.25rem 0;
        }
        
        .retry-detail-row span {
            color: #1e40af;
            opacity: 0.9;
        }
        
        .retry-detail-row strong {
            color: #1e40af;
            font-weight: 700;
        }
        
        .form-help {
            display: block;
            margin-top: 0.5rem;
            font-size: 0.875rem;
            color: var(--slate-600);
            line-height: 1.4;
        }
        
        .transaction-details {
            background: var(--slate-50);
            border: 1px solid var(--slate-200);
            border-radius: 8px;
            padding: 1.5rem;
            margin: 1.5rem 0;
            text-align: left;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem 0;
            border-bottom: 1px solid var(--slate-200);
        }
        
        .detail-row:last-child {
            border-bottom: none;
        }
        
        .detail-label {
            font-weight: 600;
            color: var(--slate-700);
        }
        
        .detail-value {
            font-weight: 700;
            color: var(--slate-900);
        }
        
        .retry-question {
            margin-top: 1.5rem;
            font-weight: 500;
        }
        
        .alert {
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
        }
        
        .alert-info {
            background: #dbeafe;
            border: 1px solid #93c5fd;
            color: #1e40af;
        }
        
        .alert-success {
            background: #dcfce7;
            border: 1px solid #86efac;
            color: #166534;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        @keyframes slideUp {
            from { 
                opacity: 0;
                transform: translateY(20px);
            }
            to { 
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
</body>
</html>
