-- Backup of delegates table before department field migration
-- Created: 2025-10-24 02:50:57
-- Total records: 25

-- This backup can be used to restore data if needed

CREATE TABLE `delegates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `registration_id` int(11) NOT NULL,
  `delegate_number` int(11) NOT NULL,
  `full_name` varchar(255) NOT NULL,
  `badge_name` varchar(100) NOT NULL,
  `designation` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT NULL COMMENT 'Optional email for individual delegate communication',
  `dietary_requirements` varchar(100) DEFAULT NULL,
  `special_assistance` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_registration_id` (`registration_id`),
  KEY `idx_delegate_number` (`delegate_number`),
  KEY `idx_delegate_email` (`email`),
  CONSTRAINT `delegates_ibfk_1` FOREIGN KEY (`registration_id`) REFERENCES `registrations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data backup
INSERT INTO delegates VALUES ('32', '25', '1', 'SONNY SORIANO', 'DR.', 'DIRECTOR', NULL, '', 'MOBILITY', '2025-09-01 06:06:43', '2025-09-01 06:06:43');
INSERT INTO delegates VALUES ('33', '26', '1', 'Maruja Padre Juan', 'Sr. Maru', 'Director', NULL, '', '', '2025-09-02 13:28:02', '2025-09-02 13:28:02');
INSERT INTO delegates VALUES ('34', '26', '2', 'Adrian Raymund Fernandez', 'Adrian', 'Program Officer', NULL, '', '', '2025-09-02 13:28:02', '2025-09-02 13:28:02');
INSERT INTO delegates VALUES ('35', '27', '1', 'Maruja Padre Juan', 'Sr. Maru', 'Director', NULL, '', '', '2025-09-02 13:33:04', '2025-09-02 13:33:04');
INSERT INTO delegates VALUES ('36', '27', '2', 'Adrian Raymund Fernandez', 'Adrian', 'Program Officer', NULL, '', '', '2025-09-02 13:33:04', '2025-09-02 13:33:04');
INSERT INTO delegates VALUES ('37', '28', '1', 'Dr. Adam Lawrence Fenech', 'Dr. Fenech', 'Provost', NULL, '', 'N/A', '2025-09-02 18:14:51', '2025-09-02 18:14:51');
INSERT INTO delegates VALUES ('42', '33', '1', 'Sayed Abbas Ahmed', 'Sayed', 'Professor', NULL, '', 'NO', '2025-09-23 18:02:19', '2025-09-23 18:02:19');
INSERT INTO delegates VALUES ('47', '36', '1', 'Lim Hock Ann', 'Lim', 'Director', NULL, '', '', '2025-10-06 09:12:15', '2025-10-06 09:12:15');
INSERT INTO delegates VALUES ('48', '37', '1', 'asdas', 'adasda', 'dadas', NULL, '', '', '2025-10-06 16:38:20', '2025-10-06 16:38:20');
INSERT INTO delegates VALUES ('49', '37', '2', 'dsa', 'ddsadsa', 'sad', NULL, '', '', '2025-10-06 16:38:20', '2025-10-06 16:38:20');
INSERT INTO delegates VALUES ('50', '38', '1', 'sd', 'ssds', 'ds', NULL, '', 'sdsd', '2025-10-06 17:09:58', '2025-10-06 17:09:58');
INSERT INTO delegates VALUES ('51', '39', '1', 'sd', 'ssds', 'ds', NULL, '', '', '2025-10-06 17:14:12', '2025-10-06 17:14:12');
INSERT INTO delegates VALUES ('52', '40', '1', 'sad', 'sasd', 'asd', NULL, '', '', '2025-10-06 17:55:09', '2025-10-06 17:55:09');
INSERT INTO delegates VALUES ('53', '41', '1', 'sd', 'ssd', 'sd', NULL, '', '', '2025-10-06 18:13:24', '2025-10-06 18:13:24');
INSERT INTO delegates VALUES ('54', '42', '1', 's', 'sds', 'ds', NULL, '', '', '2025-10-06 18:19:22', '2025-10-06 18:19:22');
INSERT INTO delegates VALUES ('55', '43', '1', 'Test User', 'Test', 'Tester', NULL, '', '', '2025-10-06 18:22:51', '2025-10-06 18:22:51');
INSERT INTO delegates VALUES ('56', '44', '1', 'Paid User', 'Paid', 'Tester', NULL, '', '', '2025-10-06 18:24:07', '2025-10-06 18:24:07');
INSERT INTO delegates VALUES ('57', '45', '1', 'adsa', 'adada', 'da', NULL, '', '', '2025-10-06 18:25:27', '2025-10-06 18:25:27');
INSERT INTO delegates VALUES ('58', '46', '1', 'Test VIP', 'VIP', 'Manager', NULL, '', '', '2025-10-06 18:27:48', '2025-10-06 18:27:48');
INSERT INTO delegates VALUES ('59', '47', '1', 'Final VIP Test', 'VIP', 'Tester', NULL, '', '', '2025-10-06 18:30:32', '2025-10-06 18:30:32');
INSERT INTO delegates VALUES ('60', '48', '1', 'Free Test User', 'Free', 'Student', NULL, '', '', '2025-10-06 18:32:55', '2025-10-06 18:32:55');
INSERT INTO delegates VALUES ('61', '49', '1', 'Free User', 'F. User', 'Student', NULL, '', '', '2025-10-06 18:44:24', '2025-10-06 18:44:24');
INSERT INTO delegates VALUES ('62', '49', '2', 'Paid User', 'P. User', 'Professor', NULL, '', '', '2025-10-06 18:44:24', '2025-10-06 18:44:24');
INSERT INTO delegates VALUES ('63', '50', '1', 'Ruwan', 'M', 'M', 'mcruwan@gmail.com', '', 'dd', '2025-10-08 17:14:28', '2025-10-08 17:14:28');
INSERT INTO delegates VALUES ('64', '51', '1', 'M Chinthaka Ruwan', 'Ruwan', 'Chief Technology Officer', 'asd@dsd.com', '[\"non-veg-(chicken)\"]', 'sdsfsdf', '2025-10-08 21:33:55', '2025-10-23 23:52:19');
