<?php
require_once 'auth_rbac.php';

// If already logged in, redirect to dashboard
if (isLoggedIn()) {
    header('Location: dashboard');
    exit;
}

$error = '';

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if ($auth->handleLogin($username, $password)) {
        header('Location: dashboard');
        exit;
    } else {
        $error = 'Invalid username or password';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - XChange Registration</title>
    <?php include '../includes/favicon.php'; ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../styles.css">
    <style>
        body {
            background: linear-gradient(135deg, var(--indigo-600), var(--fuchsia-500));
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .login-container {
            background: white;
            padding: 48px;
            border-radius: 16px;
            box-shadow: var(--shadow);
            width: 100%;
            max-width: 400px;
            margin: 20px;
        }
        
        .login-header {
            text-align: center;
            margin-bottom: 32px;
        }
        
        .login-form {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }
        
        .error-message {
            background: var(--red-100);
            color: var(--red-600);
            padding: 12px 16px;
            border-radius: 8px;
            border: 1px solid var(--red-200);
            font-size: 14px;
            text-align: center;
        }
        
        .login-footer {
            text-align: center;
            margin-top: 24px;
            font-size: 12px;
            color: var(--slate-500);
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <h1 class="text-2xl fw-800">Admin Login</h1>
            <p class="muted mt-2">XChange Registration System</p>
        </div>
        
        <?php if ($error): ?>
            <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        
        <form method="POST" class="login-form">
            <div class="form-group">
                <label for="username" class="form-label">Username</label>
                <input type="text" id="username" name="username" class="form-input" required autofocus>
            </div>
            
            <div class="form-group">
                <label for="password" class="form-label">Password</label>
                <input type="password" id="password" name="password" class="form-input" required>
            </div>
            
            <button type="submit" class="btn btn-primary">Login</button>
        </form>
        
        <div class="login-footer">
            <p>Access restricted to authorized personnel only</p>
        </div>
    </div>
</body>
</html>
