<?php
// Navigation component with role-based access control
$currentUser = getCurrentUser();
$currentRole = getCurrentUserRole();
?>

<!-- Admin Navigation CSS -->
<link rel="stylesheet" href="includes/admin_nav.css">

<header class="header">
    <div class="header-content">
        <div class="logo">
            <i class="fas fa-exchange-alt"></i> XChange Admin
        </div>
        <div class="user-info">
            <span><i class="fas fa-user"></i> <?php echo htmlspecialchars($currentUser['full_name']); ?></span>
            <span class="badge badge-primary"><?php echo AdminAuth::getRoleDisplayName($currentRole); ?></span>
            <a href="?logout=1" class="btn btn-sm" style="background: rgba(255,255,255,0.2); color: white;">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </div>
    </div>
</header>

<nav class="nav">
    <div class="nav-content">
        <?php if (hasPermission('dashboard')): ?>
        <a href="dashboard.php" class="nav-item <?php echo ($currentPage === 'dashboard') ? 'active' : ''; ?>">
            <i class="fas fa-tachometer-alt"></i> Dashboard
        </a>
        <?php endif; ?>
        
        <?php if (hasPermission('registrations')): ?>
        <a href="registrations.php" class="nav-item <?php echo ($currentPage === 'registrations') ? 'active' : ''; ?>">
            <i class="fas fa-users"></i> Registrations
        </a>
        <?php endif; ?>
        
        <?php if (hasPermission('payments')): ?>
        <a href="payments.php" class="nav-item <?php echo ($currentPage === 'payments') ? 'active' : ''; ?>">
            <i class="fas fa-credit-card"></i> Payments
        </a>
        <?php endif; ?>
        
        <?php if (hasPermission('delegates')): ?>
        <a href="delegates.php" class="nav-item <?php echo ($currentPage === 'delegates') ? 'active' : ''; ?>">
            <i class="fas fa-id-badge"></i> Delegates
        </a>
        <?php endif; ?>
        
        <?php if (hasPermission('users')): ?>
        <a href="users.php" class="nav-item <?php echo ($currentPage === 'users') ? 'active' : ''; ?>">
            <i class="fas fa-user-cog"></i> Users
        </a>
        <?php endif; ?>
        
        <?php if (hasPermission('settings')): ?>
        <a href="settings.php" class="nav-item <?php echo ($currentPage === 'settings') ? 'active' : ''; ?>">
            <i class="fas fa-cog"></i> Settings
        </a>
        <?php endif; ?>
    </div>
</nav>


