<!-- Favicon -->
<?php include __DIR__ . '/../../includes/favicon.php'; ?>
<!-- Admin Navigation CSS -->
<link rel="stylesheet" href="includes/admin_nav.css">
<!-- Font Awesome Icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<!-- Top Bar with Logo and User Info -->
<div class="admin-top-bar">
    <div class="admin-top-nav">
        <?php 
        require_once '../logo_helper.php';
        $logoHtml = getAdminLogoHtml('40px', '40px', 'XChange Admin Logo', 'admin-logo-img');
        ?>
        <div class="admin-logo">
            <span class="admin-logo-text">Xchange Admin<?php 
            // Get event name from database
            if (!function_exists('getEventName')) {
                function getEventName() {
                    static $eventName = null;
                    if ($eventName === null) {
                        try {
                            require_once '../db_config.php';
                            $pdo = getDBConnection();
                            $stmt = $pdo->prepare("SELECT setting_value FROM admin_settings WHERE setting_key = 'eventName'");
                            $stmt->execute();
                            $eventName = $stmt->fetchColumn() ?: '';
                        } catch (Exception $e) {
                            error_log('Error fetching event name: ' . $e->getMessage());
                            $eventName = '';
                        }
                    }
                    return $eventName;
                }
            }
            $eventName = getEventName();
            if ($eventName) {
                echo ' | <span class="event-name">' . htmlspecialchars($eventName) . '</span>';
            }
            ?></span>
            <!-- Mobile event name - shown only on mobile -->
            <div class="mobile-event-name">
                <?php if ($eventName): ?>
                    <span class="mobile-event-text"><?php echo htmlspecialchars($eventName); ?></span>
                <?php endif; ?>
            </div>
        </div>
        <div class="user-info">
            <a href="../index.html" target="_blank" class="frontend-link" title="Open Frontend">
                View Site
            </a>
            <span class="nav-separator"></span>
            <span class="user-name"><?php echo htmlspecialchars($_SESSION['admin_user']['full_name'] ?? 'System Administrator'); ?></span>
            <span class="user-role-badge"><?php echo strtoupper($_SESSION['admin_user']['role'] ?? 'ADMIN'); ?></span>
            <a href="?logout=1" class="logout-btn">Logout</a>
        </div>
        
        <!-- Mobile Menu Toggle -->
        <button class="mobile-menu-toggle" id="mobileMenuToggle" aria-label="Toggle mobile menu">
            <span class="hamburger-line"></span>
            <span class="hamburger-line"></span>
            <span class="hamburger-line"></span>
        </button>
    </div>
</div>

<!-- Main Navigation Bar -->
<div class="admin-nav-bar">
    <div class="admin-nav-container">
        <nav class="main-nav" id="mainNav">
            <a href="dashboard" class="nav-link <?php echo $currentPage === 'dashboard' ? 'active' : ''; ?>">
                <i class="fas fa-chart-bar"></i> Dashboard
            </a>
            <a href="registrations" class="nav-link <?php echo $currentPage === 'registrations' ? 'active' : ''; ?>">
                <i class="fas fa-users"></i> Registrations
            </a>
            <div class="nav-dropdown <?php echo in_array($currentPage, ['delegates', 'badges']) ? 'active' : ''; ?>">
                <a href="#" class="nav-link dropdown-toggle">
                    <i class="fas fa-graduation-cap"></i> Delegates <span class="dropdown-arrow">▼</span>
                </a>
                <div class="dropdown-menu">
                    <a href="delegates" class="dropdown-item <?php echo $currentPage === 'delegates' ? 'active' : ''; ?>">
                        <i class="fas fa-list"></i> Delegate List
                    </a>
                    <a href="badges" class="dropdown-item <?php echo $currentPage === 'badges' ? 'active' : ''; ?>">
                        <i class="fas fa-id-badge"></i> Event Badges
                    </a>
                </div>
            </div>
            <a href="payments" class="nav-link <?php echo $currentPage === 'payments' ? 'active' : ''; ?>">
                <i class="fas fa-credit-card"></i> Payments
            </a>
            <a href="email_logs" class="nav-link <?php echo $currentPage === 'email_logs' ? 'active' : ''; ?>">
                <i class="fas fa-envelope"></i> Email Logs
            </a>
            
            <?php if (hasPermission('registrations')): ?>
            <div class="nav-dropdown <?php echo in_array($currentPage, ['product-purchases', 'product-catalog', 'product-inventory', 'product-activity-log']) ? 'active' : ''; ?>">
                <a href="#" class="nav-link dropdown-toggle">
                    <i class="fas fa-box"></i> Products <span class="dropdown-arrow">▼</span>
                </a>
                <div class="dropdown-menu">
                    <a href="product-purchases" class="dropdown-item <?php echo $currentPage === 'product-purchases' ? 'active' : ''; ?>">
                        <i class="fas fa-shopping-cart"></i> Purchase Management
                    </a>
                    <a href="product-catalog" class="dropdown-item <?php echo $currentPage === 'product-catalog' ? 'active' : ''; ?>">
                        <i class="fas fa-list"></i> Product Catalog
                    </a>
                    <a href="product-inventory" class="dropdown-item <?php echo $currentPage === 'product-inventory' ? 'active' : ''; ?>">
                        <i class="fas fa-warehouse"></i> Inventory Management
                    </a>
                    <a href="product-analytics" class="dropdown-item <?php echo $currentPage === 'product-analytics' ? 'active' : ''; ?>">
                        <i class="fas fa-chart-line"></i> Product Analytics
                    </a>
                    <a href="product-activity-log" class="dropdown-item <?php echo $currentPage === 'product-activity-log' ? 'active' : ''; ?>">
                        <i class="fas fa-history"></i> Activity Log
                    </a>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if (hasPermission('registrations')): ?>
            <div class="nav-dropdown <?php echo in_array($currentPage, ['delegate-page', 'special-access-links']) ? 'active' : ''; ?>">
                <a href="#" class="nav-link dropdown-toggle">
                    <i class="fas fa-file-alt"></i> Pages <span class="dropdown-arrow">▼</span>
                </a>
                <div class="dropdown-menu">
                    <a href="delegate-page" class="dropdown-item <?php echo $currentPage === 'delegate-page' ? 'active' : ''; ?>">
                        <i class="fas fa-graduation-cap"></i> Delegate Page
                    </a>
                    <a href="special-access-links" class="dropdown-item <?php echo $currentPage === 'special-access-links' ? 'active' : ''; ?>">
                        <i class="fas fa-link"></i> Special Access Links
                    </a>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if (hasPermission('settings', 'view')): ?>
            <div class="nav-dropdown <?php echo in_array($currentPage, ['settings', 'email_templates', 'email_template_editor', 'users', 'exports-page']) ? 'active' : ''; ?>">
                <a href="#" class="nav-link dropdown-toggle">
                    <i class="fas fa-cog"></i> Settings <span class="dropdown-arrow">▼</span>
                </a>
                <div class="dropdown-menu">
                    <a href="settings" class="dropdown-item <?php echo $currentPage === 'settings' ? 'active' : ''; ?>">
                        <i class="fas fa-wrench"></i> General Settings
                    </a>
                    <a href="settings#email" class="dropdown-item <?php echo $currentPage === 'settings' && isset($_GET['tab']) && $_GET['tab'] === 'email' ? 'active' : ''; ?>">
                        <i class="fas fa-envelope-open"></i> Email Configuration
                    </a>
                    <a href="email_templates" class="dropdown-item <?php echo $currentPage === 'email_templates' ? 'active' : ''; ?>">
                        <i class="fas fa-file-text"></i> Email Templates
                    </a>
                    <a href="email_template_editor" class="dropdown-item <?php echo $currentPage === 'email_template_editor' ? 'active' : ''; ?>">
                        <i class="fas fa-edit"></i> Template Editor
                    </a>
                    <a href="exports-page" class="dropdown-item <?php echo $currentPage === 'exports-page' ? 'active' : ''; ?>">
                        <i class="fas fa-download"></i> Data Exports
                    </a>
                    <a href="webhook-settings" class="dropdown-item <?php echo $subPage === 'webhooks' ? 'active' : ''; ?>">
                        <i class="fas fa-link"></i> Webhook Settings
                    </a>
                    <?php if (hasPermission('users', 'view')): ?>
                    <a href="users" class="dropdown-item <?php echo $currentPage === 'users' ? 'active' : ''; ?>">
                        <i class="fas fa-user"></i> User Management
                    </a>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </nav>
    </div>
</div>

<script>
// Enhanced dropdown functionality
document.addEventListener('DOMContentLoaded', function() {
    const dropdowns = document.querySelectorAll('.nav-dropdown');
    
    dropdowns.forEach(dropdown => {
        const toggle = dropdown.querySelector('.dropdown-toggle');
        
        // Desktop hover handling
        if (window.innerWidth > 768) {
            dropdown.addEventListener('mouseenter', function() {
                dropdown.classList.add('show');
            });
            
            dropdown.addEventListener('mouseleave', function() {
                dropdown.classList.remove('show');
            });
        }
        
        // Mobile and desktop click handling
        toggle.addEventListener('click', function(e) {
            // Only prevent default on desktop, allow mobile to work normally
            if (window.innerWidth > 768) {
                e.preventDefault();
            }
            
            // Close other dropdowns
            dropdowns.forEach(otherDropdown => {
                if (otherDropdown !== dropdown) {
                    otherDropdown.classList.remove('mobile-open', 'show');
                }
            });
            
            // Toggle current dropdown
            if (window.innerWidth <= 768) {
                dropdown.classList.toggle('mobile-open');
            } else {
                dropdown.classList.toggle('show');
            }
        });
        
        // Close dropdown when clicking outside
        document.addEventListener('click', function(e) {
            if (!dropdown.contains(e.target)) {
                dropdown.classList.remove('mobile-open', 'show');
            }
        });
    });
    
    // Handle window resize
    window.addEventListener('resize', function() {
        const dropdowns = document.querySelectorAll('.nav-dropdown');
        dropdowns.forEach(dropdown => {
            dropdown.classList.remove('mobile-open', 'show');
        });
        
        // Close mobile menu on resize
        const mainNav = document.getElementById('mainNav');
        const mobileToggle = document.getElementById('mobileMenuToggle');
        if (mainNav && mobileToggle) {
            mainNav.classList.remove('mobile-open');
            mobileToggle.classList.remove('active');
        }
    });
    
    // Mobile menu toggle functionality
    const mobileToggle = document.getElementById('mobileMenuToggle');
    const mainNav = document.getElementById('mainNav');
    
    if (mobileToggle && mainNav) {
        mobileToggle.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            // Toggle mobile menu
            mainNav.classList.toggle('mobile-open');
            mobileToggle.classList.toggle('active');
            document.body.classList.toggle('mobile-menu-open');
            
            // Close any open dropdowns when opening mobile menu
            if (mainNav.classList.contains('mobile-open')) {
                const dropdowns = document.querySelectorAll('.nav-dropdown');
                dropdowns.forEach(dropdown => {
                    dropdown.classList.remove('mobile-open', 'show');
                });
            }
        });
        
        // Close mobile menu when clicking outside
        document.addEventListener('click', function(e) {
            if (!mainNav.contains(e.target) && !mobileToggle.contains(e.target)) {
                mainNav.classList.remove('mobile-open');
                mobileToggle.classList.remove('active');
                document.body.classList.remove('mobile-menu-open');
            }
        });
    }
    
    // Sticky Navigation Enhancement
    const navBar = document.querySelector('.admin-nav-bar');
    const body = document.body;
    let navBarOffset = 0;
    
    if (navBar) {
        // Get the initial offset position of the navbar
        navBarOffset = navBar.offsetTop;
        
        window.addEventListener('scroll', function() {
            const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
            
            // Add sticky class and body padding when scrolled past navbar
            if (scrollTop > navBarOffset) {
                navBar.classList.add('sticky');
                body.classList.add('nav-sticky');
            } else {
                navBar.classList.remove('sticky');
                body.classList.remove('nav-sticky');
            }
        });
        
        // Recalculate offset on window resize
        window.addEventListener('resize', function() {
            if (!navBar.classList.contains('sticky')) {
                navBarOffset = navBar.offsetTop;
            }
        });
    }
});
</script>
</style>
