<?php
/**
 * Get Delegates List API
 * Returns list of delegates for badge generator dropdown
 */

require_once 'auth_rbac.php';
require_once '../db_config.php';

requirePermission('delegates', 'view');

header('Content-Type: application/json');

try {
    $pdo = getDBConnection();
    
    $query = "
        SELECT 
            d.id,
            d.badge_name,
            r.registration_number
        FROM delegates d
        JOIN registrations r ON d.registration_id = r.id
        ORDER BY r.created_at DESC
        LIMIT 100
    ";
    
    $stmt = $pdo->query($query);
    $delegates = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode($delegates);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>


