<?php
/**
 * Get Delegate Info API
 * Returns detailed info for a specific delegate
 */

require_once 'auth_rbac.php';
require_once '../db_config.php';

requirePermission('delegates', 'view');

header('Content-Type: application/json');

$delegate_id = $_GET['id'] ?? 0;

try {
    $pdo = getDBConnection();
    
    $query = "
        SELECT 
            d.id,
            d.full_name,
            d.badge_name,
            d.designation,
            d.email,
            r.registration_number,
            r.university_name,
            r.contact_department
        FROM delegates d
        JOIN registrations r ON d.registration_id = r.id
        WHERE d.id = ?
    ";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute([$delegate_id]);
    $delegate = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($delegate) {
        echo json_encode($delegate);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Delegate not found']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>


