# Stripe Integration Setup Guide

## 1. Install Stripe PHP Library

Run this command in your project directory:
```bash
composer install
```

If you don't have Composer installed, download it from: https://getcomposer.org/

## 2. Get Your Stripe Keys

1. Go to https://dashboard.stripe.com/
2. Create an account or log in
3. Navigate to **Developers > API keys**
4. Copy your **Publishable key** (starts with `pk_test_` or `pk_live_`)
5. Copy your **Secret key** (starts with `sk_test_` or `sk_live_`)

## 3. Configure Your Keys

Edit `stripe_config.php` and replace:
```php
const STRIPE_PUBLISHABLE_KEY = 'pk_test_YOUR_PUBLISHABLE_KEY_HERE';
const STRIPE_SECRET_KEY = 'sk_test_YOUR_SECRET_KEY_HERE';
```

With your actual keys:
```php
const STRIPE_PUBLISHABLE_KEY = 'pk_test_your_actual_key_here';
const STRIPE_SECRET_KEY = 'sk_test_your_actual_key_here';
```

## 4. Set Up Webhook (Important!)

1. In Stripe Dashboard, go to **Developers > Webhooks**
2. Click **Add endpoint**
3. Enter your webhook URL: `https://yourdomain.com/path/to/stripe_webhook.php`
4. Select these events:
   - `payment_intent.succeeded`
   - `payment_intent.payment_failed`
   - `payment_intent.canceled`
5. Copy the **Signing secret** (starts with `whsec_`)
6. Update `stripe_webhook.php` line 17:
   ```php
   $endpoint_secret = 'whsec_your_actual_webhook_secret_here';
   ```

## 5. Test Mode vs Live Mode

- **Test Mode**: Use `pk_test_` and `sk_test_` keys for development
- **Live Mode**: Use `pk_live_` and `sk_live_` keys for production
- Update `IS_LIVE_MODE` in `stripe_config.php` accordingly

## 6. Test Cards (Test Mode Only)

Use these test card numbers:
- **Success**: 4242 4242 4242 4242
- **Decline**: 4000 0000 0000 0002
- **3D Secure**: 4000 0025 0000 3155

## Files Created/Updated

- ✅ `stripe_config.php` - Configuration and keys
- ✅ `stripe_payment.php` - Payment processing
- ✅ `stripe_webhook.php` - Webhook handler
- ✅ `registration_success.php` - Success page
- ✅ `registration_cancel.php` - Cancel page
- ✅ `composer.json` - Dependencies
- ✅ `index.html` - Added Stripe.js
- ✅ `registration.js` - Stripe integration
- ✅ `api.php` - Stripe key endpoint

## Security Notes

- Never expose secret keys in frontend code
- Always validate webhooks with signing secrets
- Use HTTPS in production
- Keep Stripe library updated
