# XChange Registration Application

A standalone registration system for AppliedHE Xchange events that can be reused for different conferences.

## Features

### Multi-Step Registration Process
1. **Pass Selection** - Choose delegate passes and optional table-top presentations
2. **Delegate Details** - Collect information for each attending delegate
3. **Contact Information** - University and primary contact details
4. **Review & Submit** - Final review before submission

### Pricing Structure
- **Delegate Passes**
  - Early Bird: USD $500 (until 31 Aug 2025)
  - Standard: USD $550 (from 1 Sep 2025)
- **Table-top Presentations**
  - Standard Table: USD $550 (1 table, 4 chairs, 2 banners)
  - Double Table: USD $850 (double table, 8 chairs, 2 banners)

### User Experience Features
- Real-time pricing calculations
- Progressive form validation
- Responsive design for mobile and desktop
- Auto-population of badge names from full names
- Dietary requirements and accessibility options
- Visual progress indicator

## Files Structure
```
Xchange_reg/
├── index.html          # Main registration page
├── styles.css          # Registration-specific styles
├── registration.js     # Form logic and validation
└── README.md          # This documentation
```

## Usage

1. Navigate to the `Xchange_reg` folder in your web server
2. Open `index.html` in a browser
3. Follow the multi-step registration process

## Customization for Other Events

To adapt this for other events:

1. Update event details in `index.html`:
   - Event name and dates
   - Venue information
   - Navigation links

2. Modify pricing in `registration.js`:
   - Update the `prices` object with new values
   - Adjust pass types if needed

3. Customize form fields as needed:
   - Add/remove delegate detail fields
   - Modify contact information requirements
   - Update dietary and accessibility options

## Technical Notes

- Built with vanilla JavaScript for maximum compatibility
- Uses CSS Grid and Flexbox for responsive layouts
- Imports base styles from parent directory
- Form data is logged to console (replace with actual API integration)
- Includes form validation and error handling

## Browser Support

- Modern browsers (Chrome, Firefox, Safari, Edge)
- Mobile responsive design
- Progressive enhancement approach
