# Badge Print Tracking - Quick Start Guide

## 🚀 Setup (One-Time)

Run the migration script:
```bash
php migrate_badge_print_tracking.php
```

Or manually execute: `sql/add_badge_print_tracking.sql`

## 📋 Daily Usage

### Mark Single Badge as Printed
1. Go to `http://localhost/Xchange_Admin/admin/badges`
2. Find delegate in table
3. Click **✓** button in Actions column
4. ✅ Done! Status updates instantly

### Mark Multiple Badges (Bulk)
1. Check boxes next to delegates
2. Click **🖨️ Mark Selected as Printed**
3. Confirm
4. ✅ All marked!

### View Only Unprinted Badges
1. Use **Print Status** filter dropdown
2. Select **⚪ Not Printed**
3. Click **Filter**
4. See only badges that need printing

### Unmark Badge (if needed)
- Click **↩️** button to mark as unprinted
- Or select multiple and click **↩️ Mark Selected as Unprinted**

## 📊 New Features You'll See

### Statistics Dashboard
- New card: **🖨️ Badges Printed** (shows count and %)

### Table Columns
- **Print Status** column showing:
  - ✅ Printed (with timestamp)
  - ⚪ Not Printed

### Filters
- **Print Status** dropdown:
  - All
  - 🖨️ Printed
  - ⚪ Not Printed

### Action Buttons (per badge)
- **👁️** Preview
- **🖨️** Print
- **✓/↩️** Toggle print status

### Bulk Actions
- **🖨️ Mark Selected as Printed** (NEW)
- **↩️ Mark Selected as Unprinted** (NEW)

## 💡 Recommended Workflow

```
1. Filter for "Not Printed" badges
   ↓
2. Print physical badges
   ↓
3. Mark badges as printed (individually or bulk)
   ↓
4. Check statistics to verify
```

## ✨ Benefits

✅ Never lose track of which badges are printed  
✅ Avoid duplicate printing  
✅ Quick visual status at a glance  
✅ Bulk operations save time  
✅ Full audit trail with timestamps  

## 🎯 Key Features

- **User-Friendly**: One-click operation
- **Visual**: Color-coded status indicators
- **Fast**: Bulk operations for efficiency
- **Trackable**: Timestamps and audit trail
- **Flexible**: Mark/unmark as needed
- **Filterable**: Find what you need instantly

## 📖 Full Documentation

See `BADGE_PRINT_TRACKING_FEATURE.md` for complete details.

---

**Status:** ✅ Ready to Use  
**Page:** `admin/badges.php`

