# Event Badge Generation System

## Overview

A complete event badge generation system has been created for the XChange Admin platform. This system allows you to generate professional event badges (340x500px) for all registered delegates with customizable designs, logos, and QR codes.

## ✅ What's Been Created

### 1. **Database Tables**
- `badge_settings` - Stores event configuration, logos, colors, and badge design settings
- `badge_generation_log` - Tracks badge generation history and downloads

### 2. **Admin Pages**

#### Main Badge Management (`admin/badges.php`)
- View all delegates with badge generation status
- Filter delegates by payment status, delegate type, and search
- Preview individual badges
- Download individual badges
- Batch generate badges (all delegates, paid only, or filtered selection)
- Statistics dashboard showing total delegates and badges generated

#### Badge Settings (`admin/badge-settings.php`)
- Configure event information (name, dates, location)
- Set badge dimensions (default: 340x500px)
- Upload logos (event logo, hosting university logo, partner logo)
- Customize colors (background, text, accent)
- QR code settings (enable/disable, base URL)
- Display options (show/hide logos, footer decoration)

#### Badge Designer (`admin/badge-generator.php`)
- Live preview of badge design
- Select different delegates to preview
- Real-time badge rendering
- Download sample badges
- View badge specifications

### 3. **Backend API**

#### Badge API (`admin/badge_api.php`)
- `preview` - Generate badge HTML preview
- `download` - Download single badge as HTML (can be saved as image/PDF)
- `batch_generate` - Generate multiple badges at once

#### Helper APIs
- `get_delegates_list.php` - Returns delegates for dropdown selection
- `get_delegate_info.php` - Returns detailed delegate information

### 4. **Badge Design Features**

The badge layout matches your sample (340x500px) and includes:

✅ **Header Section**
- Event logo (or event name if no logo)
- Event dates and location

✅ **Main Content**
- Badge name in large bold letters (from badge_name field - the name they want on their badge)
- Full name (complete legal name)
- Designation/title
- Department (if available)
- University name

✅ **Footer Section**
- Hosting university logo (bigger when no partner logo)
- Partner organization logo (if present)
- QR code (links to registration info)
- Decorative footer with gradient and wave pattern

### 5. **Navigation**

Badge menu has been added under **Delegates** dropdown:
- Delegates > Delegate List
- Delegates > Event Badges

## 🚀 How to Use

### Initial Setup

1. **Access Badge Settings**
   ```
   Go to: Admin > Delegates > Event Badges > Badge Settings (⚙️)
   ```

2. **Configure Event Information**
   - Event Name: "Applied HE>X CHANGE"
   - Event Dates: "27-28 FEB 2025"
   - Event Location: "MANILA, PHILIPPINES"

3. **Upload Logos**
   - Event Logo: Upload your main event logo
   - Hosting University Logo: Upload university logo (bottom left)
   - Partner Logo: Upload partner organization logo (bottom left)

4. **Customize Colors**
   - Background Color: Default #ffffff (white)
   - Text Color: Default #000000 (black)
   - Accent Color: Default #6B9F3E (green)

5. **QR Code Settings**
   - Enable QR Code: ✅ Checked
   - Base URL: Leave empty or enter verification URL

### Generating Badges

#### Single Badge
1. Go to **Delegates > Event Badges**
2. Find the delegate in the list
3. Click **👁️ Preview** to see the badge
4. Click **🖨️ Print** to open print-ready page

#### Batch Generation
1. Go to **Delegates > Event Badges**
2. Choose generation method:
   - **📦 Generate All Badges** - All delegates
   - **✅ Generate Paid Delegates** - Only confirmed/paid
   - **🔍 Generate Filtered** - Select specific delegates using checkboxes

3. The system will generate an HTML page with all badges
4. Use browser's Print function (Ctrl+P / Cmd+P) to:
   - Save as PDF
   - Print directly
   - Or take screenshots for individual badges

### Badge Designer
1. Go to **Delegates > Event Badges > Badge Designer**
2. Select different delegates from dropdown
3. Preview how badges look with different names/universities
4. Download sample badges for testing

## 📁 File Structure

```
admin/
  ├── badges.php                 # Main badge management page
  ├── badge-settings.php         # Badge configuration
  ├── badge-generator.php        # Badge designer/preview
  ├── badge_api.php              # Badge generation API
  ├── get_delegates_list.php     # Helper API
  └── get_delegate_info.php      # Helper API

uploads/
  └── badges/
      ├── logos/                 # Uploaded logo files
      └── generated/             # Generated badge files

sql/
  └── create_badge_tables.sql    # Database schema

setup_badge_tables.php           # Setup script (already run)
```

## 🎨 Badge Specifications

- **Dimensions**: 340px × 500px (configurable)
- **Format**: HTML/CSS with web fonts (Poppins)
- **Print Ready**: Can be saved as PDF or printed directly
- **Responsive**: Maintains aspect ratio
- **Font**: Poppins (weights: 400, 500, 600, 700, 800, 900)
- **QR Code**: 80x80px, links to registration verification

## 🔧 Customization Options

### Available Settings

| Setting | Default | Description |
|---------|---------|-------------|
| Event Name | "Applied HE>X CHANGE" | Main event title |
| Event Dates | "27-28 FEB 2025" | Event date range |
| Event Location | "MANILA, PHILIPPINES" | Event location |
| Badge Width | 340px | Badge width in pixels |
| Badge Height | 500px | Badge height in pixels |
| Background Color | #ffffff | Badge background |
| Text Color | #000000 | Primary text color |
| Accent Color | #6B9F3E | Highlight/accent color |
| Enable QR Code | Yes | Show QR code on badge |
| Show University Logo | Yes | Display hosting logo |
| Show Partner Logo | Yes | Display partner logo |
| Footer Decoration | Yes | Show decorative footer |

## 💡 Tips & Best Practices

### Logo Guidelines
- **Recommended Format**: PNG with transparent background
- **Maximum Size**: 5MB per file
- **Event Logo**: Ideal size 200x40px (will auto-resize)
- **University/Partner Logos**: Ideal size 50x40px each
- **Aspect Ratio**: Maintain original proportions

### Badge Generation
1. **Test First**: Use Badge Designer to preview before batch generation
2. **Check Payment Status**: Filter by "Paid" status for final badges
3. **Review Data**: Ensure delegate names and universities are correct
4. **Batch Size**: Generate in smaller batches for better browser performance
5. **Save as PDF**: Use browser's print-to-PDF for best quality

### Printing
- **Recommended Paper**: 340x500px equals ~3.5" × 5.2" (business card size)
- **Print Settings**: 
  - Scale: 100%
  - Margins: None
  - Background Graphics: Enabled
- **Professional Printing**: Export as PDF and send to print service

## 🔒 Security & Permissions

- Requires `delegates` permission with `view` access
- Settings modification requires `edit` permission
- All file uploads are validated (type, size)
- QR codes are generated securely via external API

## 📊 Badge Generation Log

The system tracks:
- Date/time of generation
- Delegate ID (for single badges)
- Generation type (single, batch, preview)
- File path
- Download count
- Admin user who generated

## 🐛 Troubleshooting

### Badge Not Displaying Correctly
1. Check if logos are uploaded in Badge Settings
2. Verify event information is configured
3. Clear browser cache and refresh

### QR Code Not Showing
1. Go to Badge Settings
2. Enable "Enable QR Code on Badges"
3. Optionally set Base URL for verification

### Logos Not Appearing
1. Verify logos are uploaded (check uploads/badges/logos/)
2. Check file permissions on uploads directory
3. Ensure logos are in supported format (JPG, PNG, GIF, SVG)

### Batch Generation Issues
- For large batches (100+ badges), generate in smaller groups
- Ensure browser has enough memory
- Try different browser if issues persist

## 🚀 Future Enhancements

Potential additions:
- Direct PDF generation (server-side)
- Bulk ZIP download
- Badge templates (multiple designs)
- Print layout presets
- Email badges to delegates
- Badge check-in system with QR scanning

## 📞 Support

For issues or questions:
1. Check this documentation first
2. Review Badge Settings configuration
3. Test with Badge Designer
4. Check browser console for errors

## 🎉 Ready to Use!

Your badge generation system is fully functional. To get started:

1. Go to: `http://localhost/Xchange_Admin/admin/badges`
2. Configure settings: Click "⚙️ Badge Settings"
3. Upload your logos
4. Preview in Badge Designer
5. Generate badges for your event!

The badge design matches your sample image with:
- ✅ 340×500px dimensions
- ✅ Event logo at top
- ✅ Large first name display
- ✅ Full delegate information
- ✅ University logos at bottom
- ✅ QR code integration
- ✅ Decorative footer

**Happy Badge Generating! 🎫**

