-- SQL Migration to remove obsolete pricing and registration limit settings
-- This script removes all hardcoded pricing and registration limit settings from the database
-- as these are now managed through the products system

-- Delete obsolete pricing and registration limit settings from admin_settings table
DELETE FROM admin_settings WHERE setting_key IN (
    'early_bird_enabled', 
    'early_bird_deadline', 
    'early_bird_price',
    'earlyBirdPrice',
    'standardPrice',
    'standardTablePrice', 
    'doubleTablePrice',
    'maxDelegates',
    'maxTables'
);

-- Update any registrations that might be using earlyBird delegate type
-- This is a safety measure to ensure data consistency
UPDATE registrations SET delegate_type = 'standard' WHERE delegate_type = 'earlyBird';

-- Remove early bird registrations count from analytics view if it exists
-- Note: This is a view modification, so we drop and recreate the view if it exists
DROP VIEW IF EXISTS registration_stats;

-- Recreate the view without the early bird count
CREATE VIEW registration_stats AS
SELECT 
    COUNT(*) AS total_registrations,
    SUM(delegate_count) AS total_delegates,
    SUM(total_amount) AS total_revenue,
    COUNT(CASE WHEN payment_status = 'paid' THEN 1 END) AS paid_registrations,
    COUNT(CASE WHEN payment_status = 'pending' THEN 1 END) AS pending_payments,
    COUNT(CASE WHEN delegate_type = 'standard' THEN 1 END) AS standard_registrations
FROM registrations;

-- Log the migration (using admin_activity_log table)
INSERT INTO admin_activity_log (admin_user_id, action, target_type, details, ip_address) 
VALUES (1, 'SYSTEM_MIGRATION', 'admin_settings', 'Removed Early Bird Pricing feature', '127.0.0.1');
