-- Create table for frontend display configuration
-- This table stores which product categories should be displayed on the frontend registration form

CREATE TABLE IF NOT EXISTS frontend_display_config (
    id INT AUTO_INCREMENT PRIMARY KEY,
    page_section VARCHAR(50) NOT NULL COMMENT 'Section identifier (e.g., delegate_passes, table_presentations)',
    category_id INT NULL COMMENT 'Product category ID to display (NULL means use all categories)',
    display_order INT DEFAULT 0 COMMENT 'Order in which to display categories',
    is_active TINYINT(1) DEFAULT 1 COMMENT 'Whether this configuration is active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
    FOREIGN KEY (category_id) REFERENCES product_categories(id) ON DELETE SET NULL,
    UNIQUE KEY unique_section_category (page_section, category_id),
    INDEX idx_page_section (page_section),
    INDEX idx_active (is_active)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default configuration for delegate passes section
-- This will initially show all categories, but can be customized via admin interface
INSERT INTO frontend_display_config (page_section, category_id, display_order, is_active) 
VALUES 
('delegate_passes', NULL, 0, 1),
('table_presentations', NULL, 1, 1)
ON DUPLICATE KEY UPDATE updated_at = CURRENT_TIMESTAMP;

-- Add some sample data if categories exist
INSERT IGNORE INTO frontend_display_config (page_section, category_id, display_order, is_active)
SELECT 'delegate_passes', id, display_order, 1
FROM product_categories 
WHERE name LIKE '%delegate%' OR name LIKE '%pass%'
ORDER BY display_order;

INSERT IGNORE INTO frontend_display_config (page_section, category_id, display_order, is_active)
SELECT 'table_presentations', id, display_order, 1
FROM product_categories 
WHERE name LIKE '%table%' OR name LIKE '%presentation%'
ORDER BY display_order;
