-- XChange Database Backup (Critical Tables)
-- Created: 2025-08-22 14:21:01
-- Database: appsappliedhe_xchange_live

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

-- Table structure for table `products`
DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category_id` int DEFAULT NULL,
  `product_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `base_price` decimal(10,2) NOT NULL,
  `currency` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'USD',
  `total_stock` int DEFAULT NULL,
  `reserved_stock` int DEFAULT '0',
  `sold_stock` int DEFAULT '0',
  `available_stock` int GENERATED ALWAYS AS ((case when (`total_stock` is null) then 999999 else greatest(0,((`total_stock` - `reserved_stock`) - `sold_stock`)) end)) STORED,
  `sale_start_date` datetime DEFAULT NULL,
  `sale_end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `requires_approval` tinyint(1) DEFAULT '0',
  `max_per_registration` int DEFAULT '1',
  `display_order` int DEFAULT '0',
  `metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_code` (`product_code`),
  KEY `idx_product_code` (`product_code`),
  KEY `idx_category` (`category_id`),
  KEY `idx_active` (`is_active`),
  KEY `idx_stock` (`available_stock`),
  CONSTRAINT `products_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `product_categories` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- Dumping data for table `products` (12 rows)
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('3', '4', 'TABLETOP_STANDARD', 'Table‑top Presentation – Standard', '<div>Ideal for showcasing programs and partnerships.</div><div>-Includes 1 table, 4 chairs</div><div>-Up to 2 standing banners (self‑produced)</div>', '550.00', 'USD', '15', '0', '2', '13', '2025-07-30 19:50:00', '2025-11-28 19:51:00', '1', '0', '10', '0', NULL, '2025-08-17 03:01:16', '2025-08-21 02:28:59');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('4', '4', 'TABLETOP_DOUBLE', 'Table‑top Presentation – Double', '<div>Ideal for showcasing programs and partnerships.</div><div>-Includes 1 table, 4 chairs</div><div>-Up to 2 standing banners (self‑produced)</div>', '850.00', 'USD', '15', '0', '2', '13', '2025-07-31 11:51:00', '2025-11-29 11:51:00', '1', '0', '10', '0', NULL, '2025-08-17 03:01:29', '2025-08-21 02:28:59');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('6', '3', 'DELEGATE_PASS', 'Delegates', 'Access to all sessions, exhibits, and networking.', '100.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '1', '0', NULL, '2025-08-18 13:01:13', '2025-08-21 02:28:59');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('7', '5', 'PLATINUM_SPONSOR', 'Platinum Sponsor', 'Includes 8 delegate passes<br data-start=\"72\" data-end=\"75\"><i>\r\nView all included items on the events page</i>', '10000.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '5', '0', NULL, '2025-08-18 16:26:54', '2025-08-21 02:28:59');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('8', '6', 'ELEVATOR_PITCH', 'Elevator Pitch', 'Showcase your institution or service with a focused, high-impact pitch using a prime networking break.', '500.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '5', '1', NULL, '2025-08-19 03:47:46', '2025-08-21 09:49:23');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('11', '5', 'GOLD_SPONSOR', 'Gold Sponsor', 'Includes 6 delegate passes<br data-start=\"72\" data-end=\"75\">\r\nView all included items on the events page', '8000.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '5', '0', NULL, '2025-08-19 05:58:32', '2025-08-21 02:28:59');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('12', '5', 'SILVER_SPONSOR', 'Silver Sponsor', 'Includes 4 delegate passes<br data-start=\"72\" data-end=\"75\">\r\nView all included items on the events page', '5500.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '5', '0', NULL, '2025-08-19 06:08:05', '2025-08-21 02:28:59');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('13', '5', 'BRONZE_SPONSOR', 'Bronze Sponsor', 'Includes 2 delegate passes<br data-start=\"72\" data-end=\"75\">\r\nView all included items on the events page', '5500.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '5', '0', NULL, '2025-08-19 06:09:06', '2025-08-21 02:28:59');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('14', '6', 'IN_AD_IN_PB', 'institution Ad in Program Book', 'Promote your institution with a prominent advertisement in both the physical and electronic editions of the event program, reaching all delegates and extending your brand visibility beyond the event.', '1000.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '0', '0', '5', '0', NULL, '2025-08-19 06:23:51', '2025-08-21 08:54:57');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('15', '6', 'CONF_LANYARD', 'Conference Lanyard', '2 complimentary delegate registrations<br>View all included items on the events page', '8800.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '5', '3', NULL, '2025-08-19 06:26:14', '2025-08-21 09:49:46');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('16', '6', 'CONF_BAG', 'Conference Bag Sponsorship', '3 complimentary delegate registrations <br>View all included items on the events page', '9900.00', 'USD', NULL, '0', '2', '999999', NULL, NULL, '1', '0', '5', '4', NULL, '2025-08-19 06:41:50', '2025-08-21 09:56:49');
INSERT INTO `products` (`id`, `category_id`, `product_code`, `name`, `description`, `base_price`, `currency`, `total_stock`, `reserved_stock`, `sold_stock`, `available_stock`, `sale_start_date`, `sale_end_date`, `is_active`, `requires_approval`, `max_per_registration`, `display_order`, `metadata`, `created_at`, `updated_at`) VALUES ('17', '6', 'VI_PL_PA', 'Visibility Plus Package', 'Maximize brand visibility across events globally<br>View all included items on the events page', '2500.00', 'USD', NULL, '0', '0', '999999', NULL, NULL, '1', '0', '5', '2', NULL, '2025-08-21 08:52:59', '2025-08-21 09:49:34');

-- Table structure for table `product_categories`
DROP TABLE IF EXISTS `product_categories`;
CREATE TABLE `product_categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `display_order` int DEFAULT '0',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `product_categories` (4 rows)
INSERT INTO `product_categories` (`id`, `name`, `description`, `display_order`, `is_active`, `created_at`, `updated_at`) VALUES ('3', 'Delegate Pass', '', '0', '1', '2025-08-17 02:14:36', '2025-08-17 02:14:36');
INSERT INTO `product_categories` (`id`, `name`, `description`, `display_order`, `is_active`, `created_at`, `updated_at`) VALUES ('4', 'Presentations', '', '1', '1', '2025-08-17 02:59:31', '2025-08-17 02:59:31');
INSERT INTO `product_categories` (`id`, `name`, `description`, `display_order`, `is_active`, `created_at`, `updated_at`) VALUES ('5', 'Sponsorship', '', '3', '1', '2025-08-18 11:04:05', '2025-08-19 05:56:14');
INSERT INTO `product_categories` (`id`, `name`, `description`, `display_order`, `is_active`, `created_at`, `updated_at`) VALUES ('6', 'Other Sponsorship', '', '4', '1', '2025-08-18 11:04:18', '2025-08-19 05:56:06');

-- Table structure for table `product_pricing`
DROP TABLE IF EXISTS `product_pricing`;
CREATE TABLE `product_pricing` (
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `pricing_tier` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `valid_from` datetime DEFAULT NULL,
  `valid_until` datetime DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_product_tier` (`product_id`,`pricing_tier`),
  KEY `idx_pricing_tier` (`pricing_tier`),
  KEY `idx_valid_dates` (`valid_from`,`valid_until`),
  CONSTRAINT `product_pricing_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `product_pricing` (2 rows)
INSERT INTO `product_pricing` (`id`, `product_id`, `pricing_tier`, `price`, `valid_from`, `valid_until`, `is_active`, `created_at`) VALUES ('33', '6', 'Early Bird', '550.00', '2025-08-01 21:06:00', '2025-09-07 21:06:00', '1', '2025-08-18 13:51:48');
INSERT INTO `product_pricing` (`id`, `product_id`, `pricing_tier`, `price`, `valid_from`, `valid_until`, `is_active`, `created_at`) VALUES ('34', '6', 'Standard', '580.00', '2025-09-07 21:06:00', '2025-11-29 21:06:00', '1', '2025-08-18 13:51:48');

-- Table structure for table `registrations`
DROP TABLE IF EXISTS `registrations`;
CREATE TABLE `registrations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `registration_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `delegate_type` enum('earlyBird','standard') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `delegate_count` int NOT NULL,
  `has_standard_table` tinyint(1) DEFAULT '0',
  `has_double_table` tinyint(1) DEFAULT '0',
  `contact_salutation` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contact_full_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `contact_badge_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `contact_designation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `contact_department` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `contact_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `contact_mobile` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `university_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `payment_method` enum('gateway','tt') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `payment_status` enum('pending','paid','failed','expired','cancelled') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'pending',
  `payment_reference` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `payment_deadline` date DEFAULT NULL,
  `admin_notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT 'Rich text admin notes for this registration',
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `registration_number` (`registration_number`),
  KEY `idx_registration_number` (`registration_number`),
  KEY `idx_contact_email` (`contact_email`),
  KEY `idx_payment_status` (`payment_status`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_registrations_payment_status` (`payment_status`),
  KEY `idx_registrations_delegate_type` (`delegate_type`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `registrations` (6 rows)
INSERT INTO `registrations` (`id`, `registration_number`, `delegate_type`, `delegate_count`, `has_standard_table`, `has_double_table`, `contact_salutation`, `contact_full_name`, `contact_badge_name`, `contact_designation`, `contact_department`, `contact_email`, `contact_mobile`, `university_name`, `country`, `payment_method`, `payment_status`, `payment_reference`, `total_amount`, `payment_deadline`, `admin_notes`, `ip_address`, `user_agent`, `created_at`, `updated_at`) VALUES ('1', 'XC25-MXFAY9', 'standard', '2', '0', '0', 'Mr', 'Ruwan Chinthaka', '', 'CTO', 'Management', 'mcruwan@gmail.com', '+60169835703', 'AppliedHE', 'Malaysia', 'gateway', 'paid', NULL, '88900.00', '2025-08-20', 'Internal', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 12:54:46', '2025-08-21 02:29:14');
INSERT INTO `registrations` (`id`, `registration_number`, `delegate_type`, `delegate_count`, `has_standard_table`, `has_double_table`, `contact_salutation`, `contact_full_name`, `contact_badge_name`, `contact_designation`, `contact_department`, `contact_email`, `contact_mobile`, `university_name`, `country`, `payment_method`, `payment_status`, `payment_reference`, `total_amount`, `payment_deadline`, `admin_notes`, `ip_address`, `user_agent`, `created_at`, `updated_at`) VALUES ('3', 'XC25-292253', 'standard', '4', '0', '0', 'Mr', 'Suba Raj', '', 'Professor test', 'HRM', 'suba@dyits.com.my', '+601116721369', 'DYITS', 'Argentina', 'tt', 'paid', NULL, '3050.00', '2025-08-28', 'dfsdfsdfsdgsfdgsfdg', '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 02:44:30', '2025-08-21 02:58:15');
INSERT INTO `registrations` (`id`, `registration_number`, `delegate_type`, `delegate_count`, `has_standard_table`, `has_double_table`, `contact_salutation`, `contact_full_name`, `contact_badge_name`, `contact_designation`, `contact_department`, `contact_email`, `contact_mobile`, `university_name`, `country`, `payment_method`, `payment_status`, `payment_reference`, `total_amount`, `payment_deadline`, `admin_notes`, `ip_address`, `user_agent`, `created_at`, `updated_at`) VALUES ('4', 'XC25-FEUGPF', 'standard', '1', '0', '0', 'Mr', 'Suba Raj', '', 'Manager', 'Department of Information Technology', 'suba@dyits.com.my', '+601116721369', 'DYITS', 'Austria', 'gateway', 'failed', NULL, '10100.00', '2025-08-21', NULL, '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 02:47:27', '2025-08-21 02:52:17');
INSERT INTO `registrations` (`id`, `registration_number`, `delegate_type`, `delegate_count`, `has_standard_table`, `has_double_table`, `contact_salutation`, `contact_full_name`, `contact_badge_name`, `contact_designation`, `contact_department`, `contact_email`, `contact_mobile`, `university_name`, `country`, `payment_method`, `payment_status`, `payment_reference`, `total_amount`, `payment_deadline`, `admin_notes`, `ip_address`, `user_agent`, `created_at`, `updated_at`) VALUES ('5', 'XC25-TPBO64', 'standard', '1', '0', '0', 'Mr', 'Suba Raj', '', 'Manager', 'Department of Information Technology', 'suba@dyits.com.my', '+601116721369', 'DYITS', 'Belgium', 'tt', 'paid', NULL, '43600.00', '2025-08-28', NULL, '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 03:00:55', '2025-08-21 03:01:43');
INSERT INTO `registrations` (`id`, `registration_number`, `delegate_type`, `delegate_count`, `has_standard_table`, `has_double_table`, `contact_salutation`, `contact_full_name`, `contact_badge_name`, `contact_designation`, `contact_department`, `contact_email`, `contact_mobile`, `university_name`, `country`, `payment_method`, `payment_status`, `payment_reference`, `total_amount`, `payment_deadline`, `admin_notes`, `ip_address`, `user_agent`, `created_at`, `updated_at`) VALUES ('6', 'XC25-FLA262', 'standard', '1', '0', '0', 'Mrs', 'sdf', '', 'dsfsdf', 'sdfsdf', 'ds@dd.om', '+65656565656', 'sdf', 'Bahamas', 'gateway', 'failed', NULL, '11600.00', '2025-08-22', NULL, '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 01:15:25', '2025-08-22 04:25:51');
INSERT INTO `registrations` (`id`, `registration_number`, `delegate_type`, `delegate_count`, `has_standard_table`, `has_double_table`, `contact_salutation`, `contact_full_name`, `contact_badge_name`, `contact_designation`, `contact_department`, `contact_email`, `contact_mobile`, `university_name`, `country`, `payment_method`, `payment_status`, `payment_reference`, `total_amount`, `payment_deadline`, `admin_notes`, `ip_address`, `user_agent`, `created_at`, `updated_at`) VALUES ('7', 'XC25-824358', 'standard', '1', '0', '0', 'Mr', 'ROSHEL UNI TEST ', '', 'Manager', 'Science ', 'roshel@dyits.com.my', '+94779738488', 'TEST UNI R 1', 'Sri Lanka', 'tt', 'pending', NULL, '19900.00', '2025-08-29', NULL, '112.134.221.36', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 10:51:59', '2025-08-22 10:51:59');

-- Table structure for table `registration_products`
DROP TABLE IF EXISTS `registration_products`;
CREATE TABLE `registration_products` (
  `id` int NOT NULL AUTO_INCREMENT,
  `registration_id` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` int NOT NULL DEFAULT '1',
  `unit_price` decimal(10,2) NOT NULL,
  `total_price` decimal(10,2) NOT NULL,
  `pricing_tier` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `stock_status` enum('reserved','confirmed','cancelled','refunded') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'reserved',
  `reserved_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `confirmed_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `product_metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_registration` (`registration_id`),
  KEY `idx_product` (`product_id`),
  KEY `idx_stock_status` (`stock_status`),
  KEY `idx_expires` (`expires_at`),
  CONSTRAINT `registration_products_ibfk_1` FOREIGN KEY (`registration_id`) REFERENCES `registrations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `registration_products_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- Dumping data for table `registration_products` (35 rows)
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('1', '1', '6', '2', '550.00', '1100.00', 'Early Bird', 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('2', '1', '3', '2', '550.00', '1100.00', NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('3', '1', '4', '2', '850.00', '1700.00', NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('4', '1', '7', '2', '10000.00', '20000.00', NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('5', '1', '11', '2', '8000.00', '16000.00', NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('6', '1', '12', '2', '5500.00', '11000.00', NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('7', '1', '13', '2', '5500.00', '11000.00', NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('8', '1', '8', '2', '500.00', '1000.00', NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('9', '1', '14', '2', '1000.00', '2000.00', NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('10', '1', '15', '2', '1000.00', '2000.00', NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('11', '1', '16', '2', '11000.00', '22000.00', NULL, 'confirmed', '2025-08-20 12:54:46', '2025-08-20 12:54:46', NULL, NULL, '2025-08-20 12:54:46', '2025-08-20 12:54:46');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('23', '3', '6', '4', '550.00', '2200.00', 'Early Bird', 'confirmed', '2025-08-21 02:44:30', '2025-08-21 02:44:30', NULL, NULL, '2025-08-21 02:44:30', '2025-08-21 02:44:30');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('24', '3', '4', '1', '850.00', '850.00', NULL, 'confirmed', '2025-08-21 02:44:30', '2025-08-21 02:44:30', NULL, NULL, '2025-08-21 02:44:30', '2025-08-21 02:44:30');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('25', '4', '6', '1', '550.00', '550.00', 'Early Bird', 'confirmed', '2025-08-21 02:47:27', '2025-08-21 02:47:27', NULL, NULL, '2025-08-21 02:47:27', '2025-08-21 02:47:27');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('26', '4', '3', '1', '550.00', '550.00', NULL, 'confirmed', '2025-08-21 02:47:27', '2025-08-21 02:47:27', NULL, NULL, '2025-08-21 02:47:27', '2025-08-21 02:47:27');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('27', '4', '11', '1', '8000.00', '8000.00', NULL, 'confirmed', '2025-08-21 02:47:27', '2025-08-21 02:47:27', NULL, NULL, '2025-08-21 02:47:27', '2025-08-21 02:47:27');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('28', '4', '15', '1', '1000.00', '1000.00', NULL, 'confirmed', '2025-08-21 02:47:27', '2025-08-21 02:47:27', NULL, NULL, '2025-08-21 02:47:27', '2025-08-21 02:47:27');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('29', '5', '6', '1', '550.00', '550.00', 'Early Bird', 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('30', '5', '3', '1', '550.00', '550.00', NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('31', '5', '7', '1', '10000.00', '10000.00', NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('32', '5', '11', '1', '8000.00', '8000.00', NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('33', '5', '12', '1', '5500.00', '5500.00', NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('34', '5', '13', '1', '5500.00', '5500.00', NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('35', '5', '8', '1', '500.00', '500.00', NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('36', '5', '14', '1', '1000.00', '1000.00', NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('37', '5', '15', '1', '1000.00', '1000.00', NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('38', '5', '16', '1', '11000.00', '11000.00', NULL, 'confirmed', '2025-08-21 03:00:55', '2025-08-21 03:00:55', NULL, NULL, '2025-08-21 03:00:55', '2025-08-21 03:00:55');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('39', '6', '6', '1', '550.00', '550.00', 'Early Bird', 'confirmed', '2025-08-22 01:15:25', '2025-08-22 01:15:25', NULL, NULL, '2025-08-22 01:15:25', '2025-08-22 01:15:25');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('40', '6', '3', '1', '550.00', '550.00', NULL, 'confirmed', '2025-08-22 01:15:25', '2025-08-22 01:15:25', NULL, NULL, '2025-08-22 01:15:25', '2025-08-22 01:15:25');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('41', '6', '7', '1', '10000.00', '10000.00', NULL, 'confirmed', '2025-08-22 01:15:25', '2025-08-22 01:15:25', NULL, NULL, '2025-08-22 01:15:25', '2025-08-22 01:15:25');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('42', '6', '8', '1', '500.00', '500.00', NULL, 'confirmed', '2025-08-22 01:15:25', '2025-08-22 01:15:25', NULL, NULL, '2025-08-22 01:15:25', '2025-08-22 01:15:25');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('43', '7', '6', '1', '550.00', '550.00', 'Early Bird', 'confirmed', '2025-08-22 10:51:59', '2025-08-22 10:51:59', NULL, NULL, '2025-08-22 10:51:59', '2025-08-22 10:51:59');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('44', '7', '3', '1', '550.00', '550.00', NULL, 'confirmed', '2025-08-22 10:51:59', '2025-08-22 10:51:59', NULL, NULL, '2025-08-22 10:51:59', '2025-08-22 10:51:59');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('45', '7', '7', '1', '10000.00', '10000.00', NULL, 'confirmed', '2025-08-22 10:51:59', '2025-08-22 10:51:59', NULL, NULL, '2025-08-22 10:51:59', '2025-08-22 10:51:59');
INSERT INTO `registration_products` (`id`, `registration_id`, `product_id`, `quantity`, `unit_price`, `total_price`, `pricing_tier`, `stock_status`, `reserved_at`, `confirmed_at`, `expires_at`, `product_metadata`, `created_at`, `updated_at`) VALUES ('46', '7', '15', '1', '8800.00', '8800.00', NULL, 'confirmed', '2025-08-22 10:51:59', '2025-08-22 10:51:59', NULL, NULL, '2025-08-22 10:51:59', '2025-08-22 10:51:59');

-- Table structure for table `delegates`
DROP TABLE IF EXISTS `delegates`;
CREATE TABLE `delegates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `registration_id` int NOT NULL,
  `delegate_number` int NOT NULL,
  `full_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `badge_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `designation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `dietary_requirements` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `special_assistance` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_registration_id` (`registration_id`),
  KEY `idx_delegate_number` (`delegate_number`),
  CONSTRAINT `delegates_ibfk_1` FOREIGN KEY (`registration_id`) REFERENCES `registrations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `delegates` (10 rows)
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('1', '1', '1', 'Ruwan Chinthaka', 'Ruwan', 'CTO', 'non-veg-(chicken)', 'No', '2025-08-20 12:54:46', '2025-08-20 12:54:46');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('2', '1', '2', 'Roshel', 'Doe', 'Manager', '', '', '2025-08-20 12:54:46', '2025-08-20 12:54:46');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('5', '3', '1', 'Suba Raj', 'Suba', 'Professor', 'non-veg-(chicken)', '', '2025-08-21 02:44:30', '2025-08-21 02:44:30');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('6', '3', '2', 'Suba - Deg 1', 'Deg 1', 'Professor', 'non-veg-(chicken)', '', '2025-08-21 02:44:30', '2025-08-21 02:44:30');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('7', '3', '3', 'Suba - Deg 2', 'Deg 2', 'Student', 'non-veg-(fish)', '', '2025-08-21 02:44:30', '2025-08-21 02:44:30');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('8', '3', '4', 'Suba - Deg 3', 'Deg 3', 'Student', 'veg', '', '2025-08-21 02:44:30', '2025-08-21 02:44:30');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('9', '4', '1', 'Raj Suba', 'Suba', 'Manager', '', '', '2025-08-21 02:47:27', '2025-08-21 02:47:27');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('10', '5', '1', 'Suba Raj', 'Suba', 'Manager', '', '', '2025-08-21 03:00:55', '2025-08-21 03:00:55');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('11', '6', '1', 's', 'sfdsf', 's', '', '', '2025-08-22 01:15:25', '2025-08-22 01:15:25');
INSERT INTO `delegates` (`id`, `registration_id`, `delegate_number`, `full_name`, `badge_name`, `designation`, `dietary_requirements`, `special_assistance`, `created_at`, `updated_at`) VALUES ('12', '7', '1', 'Roshel D (TEST)', 'Roshel', 'Student ', 'veg', 'TEST SA', '2025-08-22 10:51:59', '2025-08-22 10:51:59');

-- Table structure for table `admin_activity_log`
DROP TABLE IF EXISTS `admin_activity_log`;
CREATE TABLE `admin_activity_log` (
  `id` int NOT NULL AUTO_INCREMENT,
  `admin_user_id` int NOT NULL,
  `action` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `target_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `target_id` int DEFAULT NULL,
  `details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_admin_user_id` (`admin_user_id`),
  KEY `idx_action` (`action`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `admin_activity_log_ibfk_1` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=219 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `admin_activity_log` (56 rows)
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('7', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 02:52:40');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('8', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 02:52:43');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('45', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 05:00:38');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('46', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 05:00:40');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('64', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 07:46:00');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('65', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 07:46:11');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('68', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-17 14:43:12');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('69', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 05:13:34');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('84', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 07:35:17');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('85', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 07:35:33');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('86', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 10:43:52');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('87', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 10:43:53');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('103', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 12:45:11');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('104', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 12:45:13');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('119', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 14:46:19');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('120', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 14:46:30');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('127', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 16:48:53');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('128', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 16:48:55');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('129', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 22:58:30');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('130', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 01:26:10');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('131', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 01:26:18');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('132', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 03:28:28');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('133', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 03:28:37');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('146', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 05:48:12');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('147', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 05:53:58');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('182', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 08:01:59');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('183', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 08:02:00');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('184', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 12:17:41');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('185', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 12:17:51');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('192', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 14:42:11');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('193', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 14:42:12');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('194', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 05:22:50');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('195', '1', 'SYSTEM_MIGRATION', 'admin_settings', NULL, 'Removed Early Bird Pricing feature', '127.0.0.1', NULL, '2025-08-20 06:20:13');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('196', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:37:09');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('197', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:37:11');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('198', '1', 'logout', NULL, NULL, 'User logged out', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 09:37:30');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('199', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 09:37:32');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('200', '1', 'login', NULL, NULL, 'User logged in', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 11:02:31');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('201', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 12:35:13');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('202', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 13:46:08');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('203', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 15:55:15');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('204', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 16:40:49');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('205', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 01:43:29');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('206', '2', 'login', NULL, NULL, 'User logged in', '111.223.159.35', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 02:47:54');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('207', '3', 'login', NULL, NULL, 'User logged in', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 06:37:17');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('208', '3', 'login', NULL, NULL, 'User logged in', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 08:51:52');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('209', '4', 'login', NULL, NULL, 'User logged in', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 09:50:40');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('210', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-21 12:19:00');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('211', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 01:14:53');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('212', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 03:32:39');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('213', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 03:39:02');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('214', '3', 'login', NULL, NULL, 'User logged in', '112.134.217.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 04:48:15');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('215', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 05:12:37');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('216', '1', 'login', NULL, NULL, 'User logged in', '175.143.208.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 07:20:53');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('217', '3', 'login', NULL, NULL, 'User logged in', '112.134.221.36', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 08:57:40');
INSERT INTO `admin_activity_log` (`id`, `admin_user_id`, `action`, `target_type`, `target_id`, `details`, `ip_address`, `user_agent`, `created_at`) VALUES ('218', '3', 'login', NULL, NULL, 'User logged in', '112.134.221.36', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-22 10:41:54');


COMMIT;
