<?php
/**
 * Special Access Links Setup Script
 * Run this script to set up the special access links feature
 */

require_once 'auto_migrate.php';

echo "=== Special Access Links Setup ===\n\n";

// Check current status
$status = AutoMigrate::getFeatureStatus('special_access_links');

echo "Current Status:\n";
echo "Existing tables: " . implode(', ', $status['existing']) . "\n";
echo "Missing tables: " . implode(', ', $status['missing']) . "\n";
echo "All tables exist: " . ($status['all_exist'] ? 'Yes' : 'No') . "\n\n";

if ($status['all_exist']) {
    echo "✓ Special Access Links feature is already set up!\n";
    echo "You can access it at: special-access-links.php\n";
    exit(0);
}

echo "Setting up Special Access Links feature...\n\n";

// Run auto-migration
if (auto_migrate_feature('special_access_links')) {
    echo "\n✓ Setup completed successfully!\n";
    echo "✓ Database tables created\n";
    echo "✓ Indexes created\n";
    echo "✓ Migration recorded\n\n";
    
    echo "You can now access the Special Access Links feature at:\n";
    echo "http://your-domain/admin/special-access-links.php\n\n";
    
    echo "Features available:\n";
    echo "- Create special access links\n";
    echo "- Manage product visibility\n";
    echo "- Track access and conversions\n";
    echo "- Set expiration dates\n";
    echo "- Custom access messages\n";
    
} else {
    echo "\n✗ Setup failed!\n";
    echo "Please check:\n";
    echo "1. Database connection\n";
    echo "2. Database permissions\n";
    echo "3. Error logs\n";
    exit(1);
}
?>
