<?php
// Global header and navigation for all admin pages
$currentUser = getCurrentUser();
$currentRole = getCurrentUserRole();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle : 'Admin'; ?> - XChange Admin</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../styles.css">
    <link rel="stylesheet" href="includes/admin_nav.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">

</head>
<body>
    <div class="admin-header">
        <div class="admin-nav">
            <h1>XChange Admin</h1>
            <div class="nav-links">
                <?php if (hasPermission('dashboard')): ?>
                <a href="dashboard.php" <?php echo ($currentPage === 'dashboard') ? 'class="active"' : ''; ?>>Dashboard</a>
                <?php endif; ?>
                
                <?php if (hasPermission('registrations')): ?>
                <a href="registrations.php" <?php echo ($currentPage === 'registrations') ? 'class="active"' : ''; ?>>Registrations</a>
                <?php endif; ?>
                
                <?php if (hasPermission('delegates')): ?>
                <a href="delegates.php" <?php echo ($currentPage === 'delegates') ? 'class="active"' : ''; ?>>Delegates</a>
                <?php endif; ?>
                
                <?php if (hasPermission('payments')): ?>
                <a href="payments.php" <?php echo ($currentPage === 'payments') ? 'class="active"' : ''; ?>>Payments</a>
                <?php endif; ?>
                
                <?php if (hasPermission('users')): ?>
                <a href="users.php" <?php echo ($currentPage === 'users') ? 'class="active"' : ''; ?>>Users</a>
                <?php endif; ?>
                
                <?php if (hasPermission('settings')): ?>
                <a href="settings.php" <?php echo ($currentPage === 'settings') ? 'class="active"' : ''; ?>>Settings</a>
                <?php endif; ?>
                
                <a href="?logout=1">Logout</a>
            </div>
        </div>
    </div>
