<?php
require_once 'auth_rbac.php';
require_once '../db_config.php';

// Require admin login
requirePermission('settings', 'view');

$pageTitle = 'Data Exports';
$currentPage = 'exports-page';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> - XChange Admin</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../styles.css">
    <link rel="stylesheet" href="admin.css">
</head>
<body>
    <?php include 'includes/admin_nav.php'; ?>

    <div class="admin-content">
        <div class="page-header">
            <h1 class="page-title">Data Exports</h1>
        </div>

        <?php if (isset($_GET['error'])): ?>
            <div class="alert alert-error mb-4"><?php echo htmlspecialchars($_GET['error']); ?></div>
        <?php endif; ?>

        <div class="card mb-6">
            <div class="card-header">
                <h2 class="card-title">Export Options</h2>
            </div>
            <div class="card-body">
                <p class="mb-4">
                    Export data for external analysis, reporting, or backup purposes. All exports are generated in CSV format.
                </p>
                
                <div class="actions-row">
                    <a href="export.php?type=registrations&format=csv" class="btn btn-primary">
                        📊 Export Registrations (CSV)
                    </a>
                    <a href="export.php?type=delegates&format=csv" class="btn btn-primary">
                        👥 Export Delegates (CSV)
                    </a>
                    <a href="export.php?type=payments&format=csv" class="btn btn-primary">
                        💳 Export Payments (CSV)
                    </a>
                </div>
                
                <div class="mt-6">
                    <h3>Export Details</h3>
                    <div class="table-container mt-4">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Export Type</th>
                                    <th>Description</th>
                                    <th>Included Fields</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Registrations</td>
                                    <td>Complete registration records including contact details and payment information</td>
                                    <td>Registration number, delegate type, contact details, university, payment status, etc.</td>
                                </tr>
                                <tr>
                                    <td>Delegates</td>
                                    <td>Individual delegate information linked to registrations</td>
                                    <td>Name, badge name, designation, dietary requirements, special assistance, etc.</td>
                                </tr>
                                <tr>
                                    <td>Payments</td>
                                    <td>Payment-specific information for all registrations</td>
                                    <td>Registration number, payment method, status, reference, amount, deadlines, etc.</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
