<?php
require_once 'auth.php';
require_once '../db_config.php';

// Require admin login
requireLogin();

try {
    $pdo = getDBConnection();
    
    // Get all settings from database
    $stmt = $pdo->query("SELECT setting_key, setting_value, setting_type FROM admin_settings ORDER BY setting_key");
    $settings = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Build config structure
    $config = [
        'pricing' => [
            'earlyBirdActive' => false,
            'earlyBirdPrice' => 500,
            'standardPrice' => 550,
            'standardTablePrice' => 550,
            'doubleTablePrice' => 850
        ],
        'event' => [
            'name' => 'AppliedHE Xchange 2025',
            'dates' => '27-28 November 2025',
            'location' => 'Sunway University, Malaysia'
        ],
        'registration' => [
            'maxDelegates' => 10,
            'maxTables' => 50
        ],
        'payment' => [
            'bankName' => 'CIMB Bank Berhad',
            'accountName' => 'Applied Higher Education Sdn Bhd',
            'accountNumber' => '1234567890',
            'swiftCode' => 'CIBBMYKL'
        ],
        'dietaryOptions' => [
            'None',
            'Vegetarian',
            'Vegan',
            'Halal',
            'Kosher',
            'Gluten-free',
            'Dairy-free',
            'Nut allergy',
            'Other'
        ]
    ];
    
    // Update config with database values
    foreach ($settings as $setting) {
        $key = $setting['setting_key'];
        $value = $setting['setting_value'];
        $type = $setting['setting_type'];
        
        // Convert value based on type
        switch ($type) {
            case 'boolean':
                $value = $value === 'true';
                break;
            case 'number':
                $value = is_numeric($value) ? (float)$value : $value;
                break;
            case 'json':
                $value = json_decode($value, true);
                break;
        }
        
        // Map to config structure
        switch ($key) {
            case 'earlyBirdActive':
                $config['pricing']['earlyBirdActive'] = $value;
                break;
            case 'earlyBirdPrice':
                $config['pricing']['earlyBirdPrice'] = $value;
                break;
            case 'standardPrice':
                $config['pricing']['standardPrice'] = $value;
                break;
            case 'standardTablePrice':
                $config['pricing']['standardTablePrice'] = $value;
                break;
            case 'doubleTablePrice':
                $config['pricing']['doubleTablePrice'] = $value;
                break;
            case 'maxDelegates':
                $config['registration']['maxDelegates'] = $value;
                break;
            case 'maxTables':
                $config['registration']['maxTables'] = $value;
                break;
            case 'eventName':
                $config['event']['name'] = $value;
                break;
            case 'eventDates':
                $config['event']['dates'] = $value;
                break;
            case 'eventLocation':
                $config['event']['location'] = $value;
                break;
            case 'bankName':
                $config['payment']['bankName'] = $value;
                break;
            case 'accountName':
                $config['payment']['accountName'] = $value;
                break;
            case 'accountNumber':
                $config['payment']['accountNumber'] = $value;
                break;
            case 'swiftCode':
                $config['payment']['swiftCode'] = $value;
                break;
            case 'dietaryOptions':
                $config['dietaryOptions'] = $value;
                break;
        }
    }
    
    // Generate backup filename
    $filename = 'xchange_config_backup_' . date('Y-m-d_H-i-s') . '.json';
    
    // Set headers for download
    header('Content-Type: application/json');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    header('Cache-Control: no-cache, must-revalidate');
    header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
    
    // Output JSON
    echo json_encode($config, JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    header('Content-Type: text/html');
    echo "Error creating backup: " . htmlspecialchars($e->getMessage());
}
?>
