<?php
/**
 * One-Click Setup for Xchange_Admin Features
 * This script sets up all required features automatically
 */

// Prevent direct access from web
if (isset($_SERVER['HTTP_HOST'])) {
    die('This script can only be run from command line.');
}

echo "=== Xchange_Admin Feature Setup ===\n\n";

// Check if we're in the right directory
if (!file_exists('admin/db_config.php')) {
    die("Error: Please run this script from the Xchange_Admin root directory.\n");
}

// List of features to set up
$features = [
    'special_access_links' => [
        'name' => 'Special Access Links',
        'description' => 'Create special URLs for targeted product access',
        'required' => true
    ]
];

echo "Available features:\n";
foreach ($features as $key => $feature) {
    $status = $feature['required'] ? 'Required' : 'Optional';
    echo "- {$feature['name']} ({$status})\n";
}
echo "\n";

// Check current status
require_once 'admin/auto_migrate.php';

$allReady = true;
foreach ($features as $key => $feature) {
    $status = AutoMigrate::getFeatureStatus($key);
    $ready = $status['all_exist'] ? 'Ready' : 'Not Ready';
    echo "{$feature['name']}: {$ready}\n";
    
    if (!$status['all_exist']) {
        $allReady = false;
    }
}

if ($allReady) {
    echo "\n✓ All features are already set up!\n";
    exit(0);
}

echo "\nSetting up features...\n\n";

$success = true;
foreach ($features as $key => $feature) {
    echo "Setting up {$feature['name']}...\n";
    
    if (auto_migrate_feature($key)) {
        echo "✓ {$feature['name']} setup completed\n";
    } else {
        echo "✗ {$feature['name']} setup failed\n";
        $success = false;
    }
    echo "\n";
}

if ($success) {
    echo "🎉 All features set up successfully!\n\n";
    echo "You can now access:\n";
    echo "- Special Access Links: admin/special-access-links.php\n";
    echo "- Admin Dashboard: admin/dashboard.php\n\n";
    
    echo "Next steps:\n";
    echo "1. Configure your admin users\n";
    echo "2. Set up product categories\n";
    echo "3. Create your first special access link\n";
    echo "4. Test the registration flow\n";
    
} else {
    echo "❌ Some features failed to set up.\n";
    echo "Please check the error messages above and try again.\n";
    exit(1);
}
?>
