<?php
/**
 * Get the configurable event page URL from admin settings
 * Returns the URL where users should be redirected when clicking "Return to Event Page"
 */

require_once 'db_config.php';

function getEventPageUrl() {
    try {
        $pdo = getDBConnection();
        $stmt = $pdo->prepare("SELECT setting_value FROM admin_settings WHERE setting_key = 'eventPageUrl'");
        $stmt->execute();
        $eventPageUrl = $stmt->fetchColumn();
        
        // Return configured URL or default fallback
        return $eventPageUrl ?: '../index.html';
    } catch (Exception $e) {
        // Fallback to default if database error
        return '../index.html';
    }
}
?>
