<?php
require_once 'db_config.php';

// Test registration ID (use the one from your screenshot - likely 83 or 84)
$registrationId = 83; // Change this to the actual registration ID

try {
    $pdo = getDBConnection();
    
    // Check if registration exists
    $stmt = $pdo->prepare("SELECT * FROM registrations WHERE id = ?");
    $stmt->execute([$registrationId]);
    $registration = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "<h2>Registration Data:</h2>";
    if ($registration) {
        echo "<pre>";
        print_r($registration);
        echo "</pre>";
    } else {
        echo "No registration found with ID: $registrationId<br>";
    }
    
    // Check products for this registration
    $stmt = $pdo->prepare("
        SELECT rp.*, p.name, p.description, c.name as category_name 
        FROM registration_products rp
        LEFT JOIN products p ON rp.product_id = p.id
        LEFT JOIN product_categories c ON p.category_id = c.id
        WHERE rp.registration_id = ?
        ORDER BY c.display_order, p.id
    ");
    $stmt->execute([$registrationId]);
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h2>Products Found: " . count($products) . "</h2>";
    if (count($products) > 0) {
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Product Name</th><th>Description</th><th>Category</th><th>Quantity</th><th>Unit Price</th><th>Total Price</th></tr>";
        foreach ($products as $product) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($product['name']) . "</td>";
            echo "<td>" . htmlspecialchars($product['description'] ?? '') . "</td>";
            echo "<td>" . htmlspecialchars($product['category_name']) . "</td>";
            echo "<td>" . $product['quantity'] . "</td>";
            echo "<td>$" . number_format($product['unit_price'], 2) . "</td>";
            echo "<td>$" . number_format($product['total_price'], 2) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "No products found for registration ID: $registrationId<br>";
        
        // Check if registration_products table has any data for this registration
        $stmt = $pdo->prepare("SELECT * FROM registration_products WHERE registration_id = ?");
        $stmt->execute([$registrationId]);
        $rawProducts = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<h3>Raw registration_products data: " . count($rawProducts) . "</h3>";
        if (count($rawProducts) > 0) {
            echo "<pre>";
            print_r($rawProducts);
            echo "</pre>";
        }
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
