<?php
// Simple debug script to identify the issue
header('Content-Type: application/json');

try {
    // Test 1: Basic PHP functionality
    $debug = [
        'php_version' => phpversion(),
        'timestamp' => date('Y-m-d H:i:s'),
        'request_method' => $_SERVER['REQUEST_METHOD'] ?? 'unknown',
        'content_type' => $_SERVER['CONTENT_TYPE'] ?? 'unknown'
    ];
    
    // Test 2: Check if files exist
    $files = [
        'auth_rbac.php' => file_exists('auth_rbac.php'),
        '../db_config.php' => file_exists('../db_config.php'),
        '../email_service.php' => file_exists('../email_service.php')
    ];
    
    // Test 3: Try including files one by one
    $includes = [];
    
    if ($files['auth_rbac.php']) {
        try {
            require_once 'auth_rbac.php';
            $includes['auth_rbac'] = 'success';
        } catch (Exception $e) {
            $includes['auth_rbac'] = 'error: ' . $e->getMessage();
        }
    } else {
        $includes['auth_rbac'] = 'file not found';
    }
    
    if ($files['../db_config.php']) {
        try {
            require_once '../db_config.php';
            $includes['db_config'] = 'success';
        } catch (Exception $e) {
            $includes['db_config'] = 'error: ' . $e->getMessage();
        }
    } else {
        $includes['db_config'] = 'file not found';
    }
    
    if ($files['../email_service.php']) {
        try {
            require_once '../email_service.php';
            $includes['email_service'] = 'success';
            $includes['BrevoEmailService_exists'] = class_exists('BrevoEmailService');
        } catch (Exception $e) {
            $includes['email_service'] = 'error: ' . $e->getMessage();
        }
    } else {
        $includes['email_service'] = 'file not found';
    }
    
    // Test 4: Check input data
    $input_raw = file_get_contents('php://input');
    $input_decoded = json_decode($input_raw, true);
    
    echo json_encode([
        'success' => true,
        'debug' => $debug,
        'files' => $files,
        'includes' => $includes,
        'input_raw' => $input_raw,
        'input_decoded' => $input_decoded,
        'json_last_error' => json_last_error_msg()
    ], JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ]);
} catch (Error $e) {
    echo json_encode([
        'success' => false,
        'fatal_error' => $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ]);
}
?>
