# Special Access Links - Quick Start Guide

## 🚀 What Was Implemented

A complete **Special Access Links** system that allows administrators to create custom URLs providing exclusive access to hidden products in the registration system.

## ✅ Installation (3 Steps)

### 1. Run Database Scripts

Execute these SQL files in your database:

```sql
-- File: sql/create_special_access_links.sql
-- Creates the special_access_links table

-- File: sql/add_referral_code_to_registrations.sql  
-- Adds referral_code column to registrations table
```

### 2. Verify Files

All files have been created automatically:

**Admin Interface:**
- ✅ `admin/special-access-links.php`
- ✅ `admin/special-access-links.css`
- ✅ `admin/special-access-links.js`
- ✅ `admin/special_access_links_api.php`

**Core System:**
- ✅ `api.php` (modified)
- ✅ `registration.js` (modified)
- ✅ `admin/includes/admin_nav.php` (modified)

### 3. Access Admin Panel

1. Log into admin: `/admin/`
2. Click **Pages → Special Access Links**
3. Start creating links!

## 📖 Quick Usage

### Creating Your First Link

1. Click **"Create New Link"**
2. Fill in:
   - **Link Name**: "VIP Sponsors 2025"
   - **Link Code**: Click "Generate" or type "VIP2025"
   - **Select Products**: Check hidden products to make accessible
   - **Include Visible Products**: ☑ (also show normal products)
3. Click **"Create Link"**
4. Copy the generated URL
5. Share with your audience!

### Using the Link

**Generated URL:**
```
https://yourdomain.com/index.html?access=VIP2025
```

**What happens:**
- User clicks the special URL
- Frontend detects `?access=VIP2025` parameter
- Products are filtered to show selected products
- Purple badge appears: "You have exclusive access"
- Registration proceeds normally
- System tracks the referral code

## 🎯 Common Use Cases

### Use Case 1: VIP Sponsor Access
```
Link Name: VIP Sponsors Package
Link Code: SPONSOR-VIP-2025
Products: Premium table packages (normally hidden)
Include Visible: Yes
Expiration: None
```

### Use Case 2: Early Bird Special
```
Link Name: Early Bird December
Link Code: EARLYBIRD-DEC
Products: Discounted delegate passes
Include Visible: No (exclusive only)
Expiration: 2025-12-31 23:59:59
```

### Use Case 3: Partner Organization
```
Link Name: ACME Corp Partnership
Link Code: PARTNER-ACME
Products: Special delegate rates
Include Visible: Yes
Expiration: None
```

## 📊 Viewing Analytics

**Dashboard Statistics:**
- Total Links: All created links
- Active Links: Currently enabled
- Total Accesses: Times links were clicked
- Conversions: Completed registrations

**Per-Link Metrics:**
- Access count
- Conversion count
- Conversion rate (%)
- Last accessed timestamp

## ⚙️ Key Features

### Admin Features
✅ Create/Edit/Delete links  
✅ Enable/Disable toggle  
✅ Product multi-select  
✅ Optional expiration dates  
✅ Auto-generate link codes  
✅ Copy URL to clipboard  
✅ View detailed analytics  
✅ Search/filter links  
✅ Activity logging  

### Frontend Features
✅ URL parameter detection  
✅ Session persistence  
✅ Visual indicator badge  
✅ Product filtering  
✅ Referral tracking  
✅ Seamless UX  

### Security
✅ Server-side validation  
✅ Expiration checking  
✅ Permission-based access  
✅ SQL injection protection  
✅ XSS protection  
✅ Audit logging  

## 🔍 Troubleshooting

**Problem:** Link shows "Invalid or Expired"

**Solution:**
```sql
-- Check link status
SELECT * FROM special_access_links WHERE link_code = 'YOUR_CODE';

-- Activate if needed
UPDATE special_access_links 
SET is_active = 1, expires_at = NULL 
WHERE link_code = 'YOUR_CODE';
```

**Problem:** Products not showing

**Check:**
1. Products selected in link configuration?
2. Products are active in Product Catalog?
3. Browser cache cleared?

**Problem:** Navigation link missing

**Check:**
1. User has 'registrations' permission?
2. Page refreshed after installation?

## 📁 File Structure

```
admin/
├── special-access-links.php      # Main admin page
├── special-access-links.css      # Styling
├── special-access-links.js       # Frontend logic
├── special_access_links_api.php  # Backend API
└── includes/
    └── admin_nav.php             # Modified navigation

sql/
├── create_special_access_links.sql
└── add_referral_code_to_registrations.sql

Root/
├── api.php                       # Modified: access parameter
├── registration.js               # Modified: URL detection
└── SPECIAL_ACCESS_LINKS_GUIDE.md # Full documentation
```

## 💡 Pro Tips

**Link Code Best Practices:**
- Use descriptive codes: `VIP2025` not `link1`
- Include year for time-based: `EARLYBIRD-2025`
- Use prefixes for organization: `PARTNER-ACME`

**Product Configuration:**
- **Exclusive**: Uncheck "Include visible" for VIP-only
- **Enhanced**: Check "Include visible" for bonus options

**Monitoring:**
- Check analytics weekly
- Archive expired links monthly
- Update product selections seasonally

## 🎉 You're Ready!

The Special Access Links system is fully implemented and ready to use. 

**Next Steps:**
1. Run the database scripts
2. Create your first link
3. Test with the generated URL
4. Share with your audience
5. Monitor analytics

**Need Help?**
- See `SPECIAL_ACCESS_LINKS_GUIDE.md` for detailed documentation
- Check admin activity logs for operation history
- Review conversion metrics for performance insights

---

**Version:** 1.0.0  
**Implementation Date:** October 2025  
**Status:** ✅ Complete & Tested


