-- Migration Script: Remove config.json dependency and use database-only configuration
-- Run this script to populate all required settings in the admin_settings table

-- First, ensure the admin_settings table has the correct structure
ALTER TABLE admin_settings MODIFY COLUMN setting_type ENUM('string', 'number', 'boolean', 'json', 'text') DEFAULT 'string';

-- Clear existing settings to avoid conflicts
DELETE FROM admin_settings;

-- Insert all required configuration settings
INSERT INTO admin_settings (setting_key, setting_value, setting_type, description) VALUES
-- Pricing Settings
('earlyBirdActive', 'true', 'boolean', 'Enable early bird pricing'),
('early_bird_enabled', 'enabled', 'string', 'Early bird status (enabled/disabled)'),
('earlyBirdDeadline', '2025-08-31T23:59:59', 'string', 'Early bird registration deadline'),
('earlyBirdPrice', '500', 'number', 'Early bird delegate pass price in USD'),
('standardPrice', '550', 'number', 'Standard delegate pass price in USD'),
('standardTablePrice', '550', 'number', 'Standard table presentation price in USD'),
('doubleTablePrice', '850', 'number', 'Double table presentation price in USD'),

-- Registration Limits
('maxDelegates', '50', 'number', 'Maximum delegates per registration'),
('maxTables', '100', 'number', 'Maximum table bookings allowed'),

-- Event Information
('eventName', 'AppliedHE Xchange 2025', 'text', 'Event name'),
('eventDates', '27–28 November 2025', 'text', 'Event dates'),
('eventLocation', 'Sunway University, Malaysia', 'text', 'Event location'),

-- Payment Configuration
('bankName', 'DBS Bank Ltd Singapore', 'text', 'Bank name for transfers'),
('accountName', 'AppliedHE Pte. Ltd.', 'text', 'Bank account name'),
('accountNumber', '1234567890', 'text', 'Bank account number'),
('swiftCode', 'DBSSSGSG', 'text', 'Bank SWIFT code'),
('referencePrefix', 'XCHANGE2025', 'text', 'Payment reference prefix'),

-- Dietary Options (JSON array)
('dietaryOptions', '["None","Vegetarian","Vegan","Halal","Kosher","Gluten-free","Dairy-free","Nut allergy","Other"]', 'json', 'Available dietary requirement options'),

-- System Settings
('systemName', 'XChange 2025 Registration System', 'text', 'System name'),
('adminEmail', 'admin@xchange2025.com', 'text', 'System administrator email'),
('timezone', 'Asia/Kuala_Lumpur', 'text', 'System timezone'),
('currency', 'USD', 'text', 'Default currency'),
('dateFormat', 'M j, Y', 'text', 'Default date format'),
('timeFormat', 'H:i', 'text', 'Default time format');

-- Verify the insertion
SELECT COUNT(*) as total_settings FROM admin_settings;
SELECT setting_key, setting_value, setting_type FROM admin_settings ORDER BY setting_key;
