-- Migration script to fix admin_settings table for logo support
-- Run this on your production database

-- First, let's check the current structure
-- SHOW CREATE TABLE admin_settings;

-- Update the setting_type ENUM to include 'file' type
ALTER TABLE admin_settings 
MODIFY COLUMN setting_type ENUM('string', 'number', 'boolean', 'json', 'file') DEFAULT 'string';

-- Verify the change
-- DESCRIBE admin_settings;

-- Optional: Add any missing logo settings if they don't exist
INSERT IGNORE INTO admin_settings (setting_key, setting_value, setting_type, description) VALUES 
('companyLogo', '', 'file', 'Company/Organization logo image'),
('eventLogo', '', 'file', 'Event logo image');
