-- Insert sample products and pricing tiers for testing dynamic frontend
-- This will populate the products and pricing_tiers tables with realistic data

-- Insert products for Delegate Pass category (assuming category_id = 3)
INSERT INTO products (category_id, product_code, name, description, is_active, created_at) VALUES
(3, 'DELEGATE_PASS_EARLY', 'Early Bird Delegate Pass', 'Full conference access with early bird discount - includes all sessions, materials, and meals', 1, NOW()),
(3, 'DELEGATE_PASS_STANDARD', 'Standard Delegate Pass', 'Full conference access at standard rate - includes all sessions, materials, and meals', 1, NOW());

-- Insert products for Presentations category (assuming category_id = 4)  
INSERT INTO products (category_id, product_code, name, description, is_active, created_at) VALUES
(4, 'TABLE_STANDARD', 'Standard Table Presentation', 'Standard table space for poster/materials display - includes table, chairs, and power outlet', 1, NOW()),
(4, 'TABLE_DOUBLE', 'Double Table Presentation', 'Double table space for larger displays - includes two connected tables, chairs, and power outlets', 1, NOW());

-- Insert pricing tiers for Early Bird Delegate Pass
INSERT INTO pricing_tiers (product_id, tier_name, price, currency, is_active, valid_from, valid_until, max_quantity, created_at) VALUES
((SELECT id FROM products WHERE product_code = 'DELEGATE_PASS_EARLY'), 'Early Bird Rate', 500.00, 'USD', 1, '2025-01-01 00:00:00', '2025-08-31 23:59:59', 100, NOW());

-- Insert pricing tiers for Standard Delegate Pass
INSERT INTO pricing_tiers (product_id, tier_name, price, currency, is_active, valid_from, valid_until, max_quantity, created_at) VALUES
((SELECT id FROM products WHERE product_code = 'DELEGATE_PASS_STANDARD'), 'Standard Rate', 550.00, 'USD', 1, '2025-09-01 00:00:00', '2025-11-27 23:59:59', 200, NOW());

-- Insert pricing tiers for Standard Table
INSERT INTO pricing_tiers (product_id, tier_name, price, currency, is_active, valid_from, valid_until, max_quantity, created_at) VALUES
((SELECT id FROM products WHERE product_code = 'TABLE_STANDARD'), 'Standard Table Rate', 550.00, 'USD', 1, '2025-01-01 00:00:00', '2025-11-27 23:59:59', 50, NOW());

-- Insert pricing tiers for Double Table
INSERT INTO pricing_tiers (product_id, tier_name, price, currency, is_active, valid_from, valid_until, max_quantity, created_at) VALUES
((SELECT id FROM products WHERE product_code = 'TABLE_DOUBLE'), 'Double Table Rate', 850.00, 'USD', 1, '2025-01-01 00:00:00', '2025-11-27 23:59:59', 25, NOW());
