-- Fix for production database schema
-- Your database has 'text' instead of 'file' in the ENUM

-- Update the setting_type ENUM to include 'file' type (keeping existing 'text')
ALTER TABLE admin_settings 
MODIFY COLUMN setting_type ENUM('string', 'number', 'boolean', 'json', 'text', 'file') DEFAULT 'string';

-- Verify the change
-- DESCRIBE admin_settings;

-- Now add the logo settings
INSERT IGNORE INTO admin_settings (setting_key, setting_value, setting_type, description) VALUES 
('companyLogo', '', 'file', 'Company/Organization logo image'),
('eventLogo', '', 'file', 'Event logo image');

-- Also ensure email settings have correct types
UPDATE admin_settings SET setting_type = 'string' WHERE setting_key IN ('brevoApiKey', 'senderEmail', 'senderName') AND setting_type != 'string';
UPDATE admin_settings SET setting_type = 'json' WHERE setting_key = 'adminEmails' AND setting_type != 'json';
UPDATE admin_settings SET setting_type = 'text' WHERE setting_key = 'bankTransferDetails' AND setting_type != 'text';
