-- Webhook System Tables and Settings
-- Run this SQL to set up webhook functionality

-- Webhook logs table for tracking webhook delivery
CREATE TABLE IF NOT EXISTS webhook_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    event VARCHAR(100) NOT NULL,
    webhook_id VARCHAR(50) NOT NULL,
    http_code INT,
    response TEXT,
    error_message TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    
    INDEX idx_event (event),
    INDEX idx_webhook_id (webhook_id),
    INDEX idx_created_at (created_at)
);

-- Add webhook settings to admin_settings table
INSERT INTO admin_settings (setting_key, setting_value, setting_type, description) VALUES 
('webhook_enabled', 'false', 'boolean', 'Enable/disable webhook notifications'),
('webhook_url', '', 'string', 'Webhook endpoint URL for registration updates'),
('webhook_secret', '', 'string', 'Secret key for webhook authentication'),
('webhook_events', '["registration_created","payment_status_changed","registration_updated"]', 'json', 'Events to send via webhook'),
('webhook_retry_count', '3', 'number', 'Number of retry attempts for failed webhook calls'),
('webhook_timeout', '30', 'number', 'Timeout in seconds for webhook requests')
ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value);
