<?php
/**
 * Email Configuration Setup Script
 * Run this once to set up email configuration in the database
 */

require_once 'db_config.php';

echo "=== XChange 2025 Email Configuration Setup ===\n\n";

try {
    $pdo = getDBConnection();
    
    // Check if email_notifications table exists, if not create it
    $stmt = $pdo->query("SHOW TABLES LIKE 'email_notifications'");
    if ($stmt->rowCount() == 0) {
        echo "Creating email_notifications table...\n";
        
        $createTable = "
        CREATE TABLE email_notifications (
            id INT AUTO_INCREMENT PRIMARY KEY,
            registration_id INT,
            email_type ENUM('pending_registration', 'registration_confirmation', 'payment_failure', 'payment_reminder_24h', 'payment_reminder_48h', 'payment_reminder_7d', 'admin_notification') NOT NULL,
            recipient_email VARCHAR(255) NOT NULL,
            recipient_name VARCHAR(255),
            subject VARCHAR(500) NOT NULL,
            status ENUM('sent', 'failed', 'pending') DEFAULT 'pending',
            sent_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            brevo_message_id VARCHAR(255),
            error_message TEXT,
            
            FOREIGN KEY (registration_id) REFERENCES registrations(id) ON DELETE CASCADE,
            INDEX idx_registration_id (registration_id),
            INDEX idx_email_type (email_type),
            INDEX idx_status (status),
            INDEX idx_sent_at (sent_at)
        )";
        
        $pdo->exec($createTable);
        echo "✓ Email notifications table created\n";
    } else {
        echo "✓ Email notifications table already exists\n";
    }
    
    // Insert default email configuration settings
    $settings = [
        'brevoApiKey' => '',
        'senderEmail' => 'noreply@xchange2025.com',
        'senderName' => 'XChange 2025 Team',
        'adminEmails' => '["admin@xchange2025.com"]',
        'bankTransferDetails' => "Bank Name: [Your Bank Name]\nAccount Name: [Account Name]\nAccount Number: [Account Number]\nSwift Code: [Swift Code]\n\nIMPORTANT: Please use your registration number as the payment reference."
    ];
    
    echo "\nSetting up email configuration...\n";
    
    foreach ($settings as $key => $value) {
        $stmt = $pdo->prepare("
            INSERT INTO admin_settings (setting_key, setting_value) 
            VALUES (?, ?) 
            ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)
        ");
        $stmt->execute([$key, $value]);
        echo "✓ Set $key\n";
    }
    
    echo "\n=== Setup Complete! ===\n";
    echo "\nNext steps:\n";
    echo "1. Update your Brevo API key in Admin → Settings\n";
    echo "2. Update sender email and name in Admin → Settings\n";
    echo "3. Update admin notification emails in Admin → Settings\n";
    echo "4. Update bank transfer details in Admin → Settings\n";
    echo "\nThe email notification system is now ready to use!\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}
?>
