<?php
/**
 * Payment Reminder Cron Job
 * Run this script via cron job to send payment reminders
 * 
 * Usage:
 * php send_payment_reminders.php [reminder_type]
 * 
 * reminder_type: 24h, 48h, 7d (default: all)
 */

require_once 'email_notifications.php';

// Get reminder type from command line argument
$reminderType = $argv[1] ?? 'all';

$validTypes = ['24h', '48h', '7d'];

if ($reminderType === 'all') {
    $typesToSend = $validTypes;
} elseif (in_array($reminderType, $validTypes)) {
    $typesToSend = [$reminderType];
} else {
    echo "Invalid reminder type. Use: 24h, 48h, 7d, or all\n";
    exit(1);
}

$totalSent = 0;

foreach ($typesToSend as $type) {
    echo "Sending $type payment reminders...\n";
    $sent = sendPaymentReminders($type);
    echo "Sent $sent reminders for $type\n";
    $totalSent += $sent;
}

echo "Total reminders sent: $totalSent\n";

// Log the cron job execution
error_log("Payment reminder cron job completed. Total sent: $totalSent");
?>
